/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.SDKMethodInterfaces;
import com.clerk.backend_api.models.operations.UpdateSAMLConnectionRequestBody;
import com.clerk.backend_api.models.operations.UpdateSAMLConnectionResponse;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class UpdateSAMLConnectionRequestBuilder {
    private String samlConnectionId;
    private UpdateSAMLConnectionRequestBody requestBody;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallUpdateSAMLConnection sdk;

    public UpdateSAMLConnectionRequestBuilder(SDKMethodInterfaces.MethodCallUpdateSAMLConnection sdk) {
        this.sdk = sdk;
    }

    public UpdateSAMLConnectionRequestBuilder samlConnectionId(String samlConnectionId) {
        Utils.checkNotNull(samlConnectionId, "samlConnectionId");
        this.samlConnectionId = samlConnectionId;
        return this;
    }

    public UpdateSAMLConnectionRequestBuilder requestBody(UpdateSAMLConnectionRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public UpdateSAMLConnectionRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public UpdateSAMLConnectionRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public UpdateSAMLConnectionResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.update(this.samlConnectionId, this.requestBody, options);
    }
}

