/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.UpdateSignUpRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;

public class UpdateSignUpRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private Optional<? extends UpdateSignUpRequestBody> requestBody;

    @JsonCreator
    public UpdateSignUpRequest(String id, Optional<? extends UpdateSignUpRequestBody> requestBody) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(requestBody, "requestBody");
        this.id = id;
        this.requestBody = requestBody;
    }

    public UpdateSignUpRequest(String id) {
        this(id, Optional.empty());
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<UpdateSignUpRequestBody> requestBody() {
        return this.requestBody;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public UpdateSignUpRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public UpdateSignUpRequest withRequestBody(UpdateSignUpRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.ofNullable(requestBody);
        return this;
    }

    public UpdateSignUpRequest withRequestBody(Optional<? extends UpdateSignUpRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateSignUpRequest other = (UpdateSignUpRequest)o;
        return Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.requestBody);
    }

    public String toString() {
        return Utils.toString(UpdateSignUpRequest.class, "id", this.id, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String id;
        private Optional<? extends UpdateSignUpRequestBody> requestBody = Optional.empty();

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder requestBody(UpdateSignUpRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = Optional.ofNullable(requestBody);
            return this;
        }

        public Builder requestBody(Optional<? extends UpdateSignUpRequestBody> requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public UpdateSignUpRequest build() {
            return new UpdateSignUpRequest(this.id, this.requestBody);
        }
    }
}

