/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class UpdateUserMetadataRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="public_metadata")
    private Optional<? extends Map<String, Object>> publicMetadata;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="private_metadata")
    private Optional<? extends Map<String, Object>> privateMetadata;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="unsafe_metadata")
    private Optional<? extends Map<String, Object>> unsafeMetadata;

    @JsonCreator
    public UpdateUserMetadataRequestBody(@JsonProperty(value="public_metadata") Optional<? extends Map<String, Object>> publicMetadata, @JsonProperty(value="private_metadata") Optional<? extends Map<String, Object>> privateMetadata, @JsonProperty(value="unsafe_metadata") Optional<? extends Map<String, Object>> unsafeMetadata) {
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        Utils.checkNotNull(privateMetadata, "privateMetadata");
        Utils.checkNotNull(unsafeMetadata, "unsafeMetadata");
        this.publicMetadata = publicMetadata;
        this.privateMetadata = privateMetadata;
        this.unsafeMetadata = unsafeMetadata;
    }

    public UpdateUserMetadataRequestBody() {
        this(Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<Map<String, Object>> publicMetadata() {
        return this.publicMetadata;
    }

    @JsonIgnore
    public Optional<Map<String, Object>> privateMetadata() {
        return this.privateMetadata;
    }

    @JsonIgnore
    public Optional<Map<String, Object>> unsafeMetadata() {
        return this.unsafeMetadata;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public UpdateUserMetadataRequestBody withPublicMetadata(Map<String, Object> publicMetadata) {
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        this.publicMetadata = Optional.ofNullable(publicMetadata);
        return this;
    }

    public UpdateUserMetadataRequestBody withPublicMetadata(Optional<? extends Map<String, Object>> publicMetadata) {
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        this.publicMetadata = publicMetadata;
        return this;
    }

    public UpdateUserMetadataRequestBody withPrivateMetadata(Map<String, Object> privateMetadata) {
        Utils.checkNotNull(privateMetadata, "privateMetadata");
        this.privateMetadata = Optional.ofNullable(privateMetadata);
        return this;
    }

    public UpdateUserMetadataRequestBody withPrivateMetadata(Optional<? extends Map<String, Object>> privateMetadata) {
        Utils.checkNotNull(privateMetadata, "privateMetadata");
        this.privateMetadata = privateMetadata;
        return this;
    }

    public UpdateUserMetadataRequestBody withUnsafeMetadata(Map<String, Object> unsafeMetadata) {
        Utils.checkNotNull(unsafeMetadata, "unsafeMetadata");
        this.unsafeMetadata = Optional.ofNullable(unsafeMetadata);
        return this;
    }

    public UpdateUserMetadataRequestBody withUnsafeMetadata(Optional<? extends Map<String, Object>> unsafeMetadata) {
        Utils.checkNotNull(unsafeMetadata, "unsafeMetadata");
        this.unsafeMetadata = unsafeMetadata;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateUserMetadataRequestBody other = (UpdateUserMetadataRequestBody)o;
        return Objects.deepEquals(this.publicMetadata, other.publicMetadata) && Objects.deepEquals(this.privateMetadata, other.privateMetadata) && Objects.deepEquals(this.unsafeMetadata, other.unsafeMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.publicMetadata, this.privateMetadata, this.unsafeMetadata);
    }

    public String toString() {
        return Utils.toString(UpdateUserMetadataRequestBody.class, "publicMetadata", this.publicMetadata, "privateMetadata", this.privateMetadata, "unsafeMetadata", this.unsafeMetadata);
    }

    public static final class Builder {
        private Optional<? extends Map<String, Object>> publicMetadata = Optional.empty();
        private Optional<? extends Map<String, Object>> privateMetadata = Optional.empty();
        private Optional<? extends Map<String, Object>> unsafeMetadata = Optional.empty();

        private Builder() {
        }

        public Builder publicMetadata(Map<String, Object> publicMetadata) {
            Utils.checkNotNull(publicMetadata, "publicMetadata");
            this.publicMetadata = Optional.ofNullable(publicMetadata);
            return this;
        }

        public Builder publicMetadata(Optional<? extends Map<String, Object>> publicMetadata) {
            Utils.checkNotNull(publicMetadata, "publicMetadata");
            this.publicMetadata = publicMetadata;
            return this;
        }

        public Builder privateMetadata(Map<String, Object> privateMetadata) {
            Utils.checkNotNull(privateMetadata, "privateMetadata");
            this.privateMetadata = Optional.ofNullable(privateMetadata);
            return this;
        }

        public Builder privateMetadata(Optional<? extends Map<String, Object>> privateMetadata) {
            Utils.checkNotNull(privateMetadata, "privateMetadata");
            this.privateMetadata = privateMetadata;
            return this;
        }

        public Builder unsafeMetadata(Map<String, Object> unsafeMetadata) {
            Utils.checkNotNull(unsafeMetadata, "unsafeMetadata");
            this.unsafeMetadata = Optional.ofNullable(unsafeMetadata);
            return this;
        }

        public Builder unsafeMetadata(Optional<? extends Map<String, Object>> unsafeMetadata) {
            Utils.checkNotNull(unsafeMetadata, "unsafeMetadata");
            this.unsafeMetadata = unsafeMetadata;
            return this;
        }

        public UpdateUserMetadataRequestBody build() {
            return new UpdateUserMetadataRequestBody(this.publicMetadata, this.privateMetadata, this.unsafeMetadata);
        }
    }
}

