/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.UpsertTemplatePathParamTemplateType;
import com.clerk.backend_api.models.operations.UpsertTemplateRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;

public class UpsertTemplateRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=template_type")
    private UpsertTemplatePathParamTemplateType templateType;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=slug")
    private String slug;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private Optional<? extends UpsertTemplateRequestBody> requestBody;

    @JsonCreator
    public UpsertTemplateRequest(UpsertTemplatePathParamTemplateType templateType, String slug, Optional<? extends UpsertTemplateRequestBody> requestBody) {
        Utils.checkNotNull(templateType, "templateType");
        Utils.checkNotNull(slug, "slug");
        Utils.checkNotNull(requestBody, "requestBody");
        this.templateType = templateType;
        this.slug = slug;
        this.requestBody = requestBody;
    }

    public UpsertTemplateRequest(UpsertTemplatePathParamTemplateType templateType, String slug) {
        this(templateType, slug, Optional.empty());
    }

    @JsonIgnore
    public UpsertTemplatePathParamTemplateType templateType() {
        return this.templateType;
    }

    @JsonIgnore
    public String slug() {
        return this.slug;
    }

    @JsonIgnore
    public Optional<UpsertTemplateRequestBody> requestBody() {
        return this.requestBody;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public UpsertTemplateRequest withTemplateType(UpsertTemplatePathParamTemplateType templateType) {
        Utils.checkNotNull(templateType, "templateType");
        this.templateType = templateType;
        return this;
    }

    public UpsertTemplateRequest withSlug(String slug) {
        Utils.checkNotNull(slug, "slug");
        this.slug = slug;
        return this;
    }

    public UpsertTemplateRequest withRequestBody(UpsertTemplateRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.ofNullable(requestBody);
        return this;
    }

    public UpsertTemplateRequest withRequestBody(Optional<? extends UpsertTemplateRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertTemplateRequest other = (UpsertTemplateRequest)o;
        return Objects.deepEquals((Object)this.templateType, (Object)other.templateType) && Objects.deepEquals(this.slug, other.slug) && Objects.deepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.templateType, this.slug, this.requestBody});
    }

    public String toString() {
        return Utils.toString(UpsertTemplateRequest.class, new Object[]{"templateType", this.templateType, "slug", this.slug, "requestBody", this.requestBody});
    }

    public static final class Builder {
        private UpsertTemplatePathParamTemplateType templateType;
        private String slug;
        private Optional<? extends UpsertTemplateRequestBody> requestBody = Optional.empty();

        private Builder() {
        }

        public Builder templateType(UpsertTemplatePathParamTemplateType templateType) {
            Utils.checkNotNull(templateType, "templateType");
            this.templateType = templateType;
            return this;
        }

        public Builder slug(String slug) {
            Utils.checkNotNull(slug, "slug");
            this.slug = slug;
            return this;
        }

        public Builder requestBody(UpsertTemplateRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = Optional.ofNullable(requestBody);
            return this;
        }

        public Builder requestBody(Optional<? extends UpsertTemplateRequestBody> requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public UpsertTemplateRequest build() {
            return new UpsertTemplateRequest(this.templateType, this.slug, this.requestBody);
        }
    }
}

