/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.SDKMethodInterfaces;
import com.clerk.backend_api.models.operations.UpsertTemplatePathParamTemplateType;
import com.clerk.backend_api.models.operations.UpsertTemplateRequestBody;
import com.clerk.backend_api.models.operations.UpsertTemplateResponse;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class UpsertTemplateRequestBuilder {
    private UpsertTemplatePathParamTemplateType templateType;
    private String slug;
    private Optional<? extends UpsertTemplateRequestBody> requestBody = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallUpsertTemplate sdk;

    public UpsertTemplateRequestBuilder(SDKMethodInterfaces.MethodCallUpsertTemplate sdk) {
        this.sdk = sdk;
    }

    public UpsertTemplateRequestBuilder templateType(UpsertTemplatePathParamTemplateType templateType) {
        Utils.checkNotNull(templateType, "templateType");
        this.templateType = templateType;
        return this;
    }

    public UpsertTemplateRequestBuilder slug(String slug) {
        Utils.checkNotNull(slug, "slug");
        this.slug = slug;
        return this;
    }

    public UpsertTemplateRequestBuilder requestBody(UpsertTemplateRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.of(requestBody);
        return this;
    }

    public UpsertTemplateRequestBuilder requestBody(Optional<? extends UpsertTemplateRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public UpsertTemplateRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public UpsertTemplateRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public UpsertTemplateResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.upsert(this.templateType, this.slug, this.requestBody, options);
    }
}

