/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public class UserWeb3WalletDeleteRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=user_id")
    private String userId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=web3_wallet_identification_id")
    private String web3WalletIdentificationId;

    @JsonCreator
    public UserWeb3WalletDeleteRequest(String userId, String web3WalletIdentificationId) {
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(web3WalletIdentificationId, "web3WalletIdentificationId");
        this.userId = userId;
        this.web3WalletIdentificationId = web3WalletIdentificationId;
    }

    @JsonIgnore
    public String userId() {
        return this.userId;
    }

    @JsonIgnore
    public String web3WalletIdentificationId() {
        return this.web3WalletIdentificationId;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public UserWeb3WalletDeleteRequest withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public UserWeb3WalletDeleteRequest withWeb3WalletIdentificationId(String web3WalletIdentificationId) {
        Utils.checkNotNull(web3WalletIdentificationId, "web3WalletIdentificationId");
        this.web3WalletIdentificationId = web3WalletIdentificationId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserWeb3WalletDeleteRequest other = (UserWeb3WalletDeleteRequest)o;
        return Objects.deepEquals(this.userId, other.userId) && Objects.deepEquals(this.web3WalletIdentificationId, other.web3WalletIdentificationId);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.web3WalletIdentificationId);
    }

    public String toString() {
        return Utils.toString(UserWeb3WalletDeleteRequest.class, "userId", this.userId, "web3WalletIdentificationId", this.web3WalletIdentificationId);
    }

    public static final class Builder {
        private String userId;
        private String web3WalletIdentificationId;

        private Builder() {
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder web3WalletIdentificationId(String web3WalletIdentificationId) {
            Utils.checkNotNull(web3WalletIdentificationId, "web3WalletIdentificationId");
            this.web3WalletIdentificationId = web3WalletIdentificationId;
            return this;
        }

        public UserWeb3WalletDeleteRequest build() {
            return new UserWeb3WalletDeleteRequest(this.userId, this.web3WalletIdentificationId);
        }
    }
}

