/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.DeletedObject;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class UserWeb3WalletDeleteResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends DeletedObject> deletedObject;

    @JsonCreator
    public UserWeb3WalletDeleteResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends DeletedObject> deletedObject) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(deletedObject, "deletedObject");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.deletedObject = deletedObject;
    }

    public UserWeb3WalletDeleteResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<DeletedObject> deletedObject() {
        return this.deletedObject;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public UserWeb3WalletDeleteResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public UserWeb3WalletDeleteResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public UserWeb3WalletDeleteResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public UserWeb3WalletDeleteResponse withDeletedObject(DeletedObject deletedObject) {
        Utils.checkNotNull(deletedObject, "deletedObject");
        this.deletedObject = Optional.ofNullable(deletedObject);
        return this;
    }

    public UserWeb3WalletDeleteResponse withDeletedObject(Optional<? extends DeletedObject> deletedObject) {
        Utils.checkNotNull(deletedObject, "deletedObject");
        this.deletedObject = deletedObject;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserWeb3WalletDeleteResponse other = (UserWeb3WalletDeleteResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.deletedObject, other.deletedObject);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.deletedObject);
    }

    public String toString() {
        return Utils.toString(UserWeb3WalletDeleteResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "deletedObject", this.deletedObject);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends DeletedObject> deletedObject = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder deletedObject(DeletedObject deletedObject) {
            Utils.checkNotNull(deletedObject, "deletedObject");
            this.deletedObject = Optional.ofNullable(deletedObject);
            return this;
        }

        public Builder deletedObject(Optional<? extends DeletedObject> deletedObject) {
            Utils.checkNotNull(deletedObject, "deletedObject");
            this.deletedObject = deletedObject;
            return this;
        }

        public UserWeb3WalletDeleteResponse build() {
            return new UserWeb3WalletDeleteResponse(this.contentType, this.statusCode, this.rawResponse, this.deletedObject);
        }
    }
}

