/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class VerifyDomainProxyRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="domain_id")
    private Optional<String> domainId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="proxy_url")
    private Optional<String> proxyUrl;

    @JsonCreator
    public VerifyDomainProxyRequestBody(@JsonProperty(value="domain_id") Optional<String> domainId, @JsonProperty(value="proxy_url") Optional<String> proxyUrl) {
        Utils.checkNotNull(domainId, "domainId");
        Utils.checkNotNull(proxyUrl, "proxyUrl");
        this.domainId = domainId;
        this.proxyUrl = proxyUrl;
    }

    public VerifyDomainProxyRequestBody() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> domainId() {
        return this.domainId;
    }

    @JsonIgnore
    public Optional<String> proxyUrl() {
        return this.proxyUrl;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public VerifyDomainProxyRequestBody withDomainId(String domainId) {
        Utils.checkNotNull(domainId, "domainId");
        this.domainId = Optional.ofNullable(domainId);
        return this;
    }

    public VerifyDomainProxyRequestBody withDomainId(Optional<String> domainId) {
        Utils.checkNotNull(domainId, "domainId");
        this.domainId = domainId;
        return this;
    }

    public VerifyDomainProxyRequestBody withProxyUrl(String proxyUrl) {
        Utils.checkNotNull(proxyUrl, "proxyUrl");
        this.proxyUrl = Optional.ofNullable(proxyUrl);
        return this;
    }

    public VerifyDomainProxyRequestBody withProxyUrl(Optional<String> proxyUrl) {
        Utils.checkNotNull(proxyUrl, "proxyUrl");
        this.proxyUrl = proxyUrl;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifyDomainProxyRequestBody other = (VerifyDomainProxyRequestBody)o;
        return Objects.deepEquals(this.domainId, other.domainId) && Objects.deepEquals(this.proxyUrl, other.proxyUrl);
    }

    public int hashCode() {
        return Objects.hash(this.domainId, this.proxyUrl);
    }

    public String toString() {
        return Utils.toString(VerifyDomainProxyRequestBody.class, "domainId", this.domainId, "proxyUrl", this.proxyUrl);
    }

    public static final class Builder {
        private Optional<String> domainId = Optional.empty();
        private Optional<String> proxyUrl = Optional.empty();

        private Builder() {
        }

        public Builder domainId(String domainId) {
            Utils.checkNotNull(domainId, "domainId");
            this.domainId = Optional.ofNullable(domainId);
            return this;
        }

        public Builder domainId(Optional<String> domainId) {
            Utils.checkNotNull(domainId, "domainId");
            this.domainId = domainId;
            return this;
        }

        public Builder proxyUrl(String proxyUrl) {
            Utils.checkNotNull(proxyUrl, "proxyUrl");
            this.proxyUrl = Optional.ofNullable(proxyUrl);
            return this;
        }

        public Builder proxyUrl(Optional<String> proxyUrl) {
            Utils.checkNotNull(proxyUrl, "proxyUrl");
            this.proxyUrl = proxyUrl;
            return this;
        }

        public VerifyDomainProxyRequestBody build() {
            return new VerifyDomainProxyRequestBody(this.domainId, this.proxyUrl);
        }
    }
}

