/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.ProxyCheck;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class VerifyDomainProxyResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends ProxyCheck> proxyCheck;

    @JsonCreator
    public VerifyDomainProxyResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends ProxyCheck> proxyCheck) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(proxyCheck, "proxyCheck");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.proxyCheck = proxyCheck;
    }

    public VerifyDomainProxyResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ProxyCheck> proxyCheck() {
        return this.proxyCheck;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public VerifyDomainProxyResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public VerifyDomainProxyResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public VerifyDomainProxyResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public VerifyDomainProxyResponse withProxyCheck(ProxyCheck proxyCheck) {
        Utils.checkNotNull(proxyCheck, "proxyCheck");
        this.proxyCheck = Optional.ofNullable(proxyCheck);
        return this;
    }

    public VerifyDomainProxyResponse withProxyCheck(Optional<? extends ProxyCheck> proxyCheck) {
        Utils.checkNotNull(proxyCheck, "proxyCheck");
        this.proxyCheck = proxyCheck;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifyDomainProxyResponse other = (VerifyDomainProxyResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.proxyCheck, other.proxyCheck);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.proxyCheck);
    }

    public String toString() {
        return Utils.toString(VerifyDomainProxyResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "proxyCheck", this.proxyCheck);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends ProxyCheck> proxyCheck = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder proxyCheck(ProxyCheck proxyCheck) {
            Utils.checkNotNull(proxyCheck, "proxyCheck");
            this.proxyCheck = Optional.ofNullable(proxyCheck);
            return this;
        }

        public Builder proxyCheck(Optional<? extends ProxyCheck> proxyCheck) {
            Utils.checkNotNull(proxyCheck, "proxyCheck");
            this.proxyCheck = proxyCheck;
            return this;
        }

        public VerifyDomainProxyResponse build() {
            return new VerifyDomainProxyResponse(this.contentType, this.statusCode, this.rawResponse, this.proxyCheck);
        }
    }
}

