/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.VerifyPasswordRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;

public class VerifyPasswordRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=user_id")
    private String userId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private Optional<? extends VerifyPasswordRequestBody> requestBody;

    @JsonCreator
    public VerifyPasswordRequest(String userId, Optional<? extends VerifyPasswordRequestBody> requestBody) {
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.userId = userId;
        this.requestBody = requestBody;
    }

    public VerifyPasswordRequest(String userId) {
        this(userId, Optional.empty());
    }

    @JsonIgnore
    public String userId() {
        return this.userId;
    }

    @JsonIgnore
    public Optional<VerifyPasswordRequestBody> requestBody() {
        return this.requestBody;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public VerifyPasswordRequest withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public VerifyPasswordRequest withRequestBody(VerifyPasswordRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.ofNullable(requestBody);
        return this;
    }

    public VerifyPasswordRequest withRequestBody(Optional<? extends VerifyPasswordRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifyPasswordRequest other = (VerifyPasswordRequest)o;
        return Objects.deepEquals(this.userId, other.userId) && Objects.deepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(VerifyPasswordRequest.class, "userId", this.userId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String userId;
        private Optional<? extends VerifyPasswordRequestBody> requestBody = Optional.empty();

        private Builder() {
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder requestBody(VerifyPasswordRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = Optional.ofNullable(requestBody);
            return this;
        }

        public Builder requestBody(Optional<? extends VerifyPasswordRequestBody> requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public VerifyPasswordRequest build() {
            return new VerifyPasswordRequest(this.userId, this.requestBody);
        }
    }
}

