/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class VerifySessionRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="token")
    private Optional<String> token;

    @JsonCreator
    public VerifySessionRequestBody(@JsonProperty(value="token") Optional<String> token) {
        Utils.checkNotNull(token, "token");
        this.token = token;
    }

    public VerifySessionRequestBody() {
        this(Optional.empty());
    }

    @JsonIgnore
    public Optional<String> token() {
        return this.token;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public VerifySessionRequestBody withToken(String token) {
        Utils.checkNotNull(token, "token");
        this.token = Optional.ofNullable(token);
        return this;
    }

    public VerifySessionRequestBody withToken(Optional<String> token) {
        Utils.checkNotNull(token, "token");
        this.token = token;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifySessionRequestBody other = (VerifySessionRequestBody)o;
        return Objects.deepEquals(this.token, other.token);
    }

    public int hashCode() {
        return Objects.hash(this.token);
    }

    public String toString() {
        return Utils.toString(VerifySessionRequestBody.class, "token", this.token);
    }

    public static final class Builder {
        private Optional<String> token = Optional.empty();

        private Builder() {
        }

        public Builder token(String token) {
            Utils.checkNotNull(token, "token");
            this.token = Optional.ofNullable(token);
            return this;
        }

        public Builder token(Optional<String> token) {
            Utils.checkNotNull(token, "token");
            this.token = token;
            return this;
        }

        public VerifySessionRequestBody build() {
            return new VerifySessionRequestBody(this.token);
        }
    }
}

