/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.utils;

import com.clerk.backend_api.SecuritySource;
import com.clerk.backend_api.utils.HTTPClient;
import com.clerk.backend_api.utils.Helpers;
import com.clerk.backend_api.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public final class Hook {
    private Hook() {
    }

    public static final class IdempotencyHook
    implements BeforeRequest {
        @Override
        public HttpRequest beforeRequest(BeforeRequestContext context, HttpRequest request) throws Exception {
            HttpRequest.Builder b = Helpers.copy(request);
            b.header("Idempotency-Key", UUID.randomUUID().toString());
            return b.build();
        }
    }

    public static interface SdkInit {
        public static final SdkInit DEFAULT = data -> data;

        public SdkInitData sdkInit(SdkInitData var1);
    }

    public static final class SdkInitData {
        private final String baseUrl;
        private final HTTPClient client;

        public SdkInitData(String baseUrl, HTTPClient client) {
            this.baseUrl = baseUrl;
            this.client = client;
        }

        public String baseUrl() {
            return this.baseUrl;
        }

        public HTTPClient client() {
            return this.client;
        }
    }

    public static interface AfterError {
        public static final AfterError DEFAULT = (context, response, error) -> {
            Utils.checkArgument(response.isPresent() ^ error.isPresent(), "one and only one of response or error must be present");
            if (error.isPresent()) {
                throw (Exception)error.get();
            }
            return (HttpResponse)response.get();
        };

        public HttpResponse<InputStream> afterError(AfterErrorContext var1, Optional<HttpResponse<InputStream>> var2, Optional<Exception> var3) throws Exception;
    }

    public static interface AfterSuccess {
        public static final AfterSuccess DEFAULT = (context, response) -> response;

        public HttpResponse<InputStream> afterSuccess(AfterSuccessContext var1, HttpResponse<InputStream> var2) throws Exception;
    }

    public static interface BeforeRequest {
        public static final BeforeRequest DEFAULT = (context, request) -> request;

        public HttpRequest beforeRequest(BeforeRequestContext var1, HttpRequest var2) throws Exception;
    }

    public static final class AfterErrorContextImpl
    implements AfterErrorContext {
        private final String baseUrl;
        private final String operationId;
        private final Optional<List<String>> oauthScopes;
        private final Optional<SecuritySource> securitySource;

        public AfterErrorContextImpl(String baseUrl, String operationId, Optional<List<String>> oauthScopes, Optional<SecuritySource> securitySource) {
            Utils.checkNotNull(securitySource, "securitySource");
            this.baseUrl = baseUrl;
            this.operationId = operationId;
            this.oauthScopes = oauthScopes;
            this.securitySource = securitySource;
        }

        @Override
        public String baseUrl() {
            return this.baseUrl;
        }

        @Override
        public String operationId() {
            return this.operationId;
        }

        @Override
        public Optional<SecuritySource> securitySource() {
            return this.securitySource;
        }

        @Override
        public Optional<List<String>> oauthScopes() {
            return this.oauthScopes;
        }
    }

    public static interface AfterErrorContext
    extends HookContext {
    }

    public static final class AfterSuccessContextImpl
    implements AfterSuccessContext {
        private final String baseUrl;
        private final String operationId;
        private final Optional<List<String>> oauthScopes;
        private final Optional<SecuritySource> securitySource;

        public AfterSuccessContextImpl(String baseUrl, String operationId, Optional<List<String>> oauthScopes, Optional<SecuritySource> securitySource) {
            Utils.checkNotNull(securitySource, "securitySource");
            this.baseUrl = baseUrl;
            this.operationId = operationId;
            this.oauthScopes = oauthScopes;
            this.securitySource = securitySource;
        }

        @Override
        public String baseUrl() {
            return this.baseUrl;
        }

        @Override
        public String operationId() {
            return this.operationId;
        }

        @Override
        public Optional<SecuritySource> securitySource() {
            return this.securitySource;
        }

        @Override
        public Optional<List<String>> oauthScopes() {
            return this.oauthScopes;
        }
    }

    public static interface AfterSuccessContext
    extends HookContext {
    }

    public static final class BeforeRequestContextImpl
    implements BeforeRequestContext {
        private final String baseUrl;
        private final String operationId;
        private final Optional<List<String>> oauthScopes;
        private final Optional<SecuritySource> securitySource;

        public BeforeRequestContextImpl(String baseUrl, String operationId, Optional<List<String>> oauthScopes, Optional<SecuritySource> securitySource) {
            this.baseUrl = baseUrl;
            this.operationId = operationId;
            this.oauthScopes = oauthScopes;
            this.securitySource = securitySource;
        }

        @Override
        public String baseUrl() {
            return this.baseUrl;
        }

        @Override
        public String operationId() {
            return this.operationId;
        }

        @Override
        public Optional<SecuritySource> securitySource() {
            return this.securitySource;
        }

        @Override
        public Optional<List<String>> oauthScopes() {
            return this.oauthScopes;
        }
    }

    public static interface BeforeRequestContext
    extends HookContext {
    }

    public static interface HookContext {
        public String baseUrl();

        public String operationId();

        public Optional<List<String>> oauthScopes();

        public Optional<SecuritySource> securitySource();
    }
}

