/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.SecuritySource;
import com.clerk.backend_api.models.components.SvixURL;
import com.clerk.backend_api.models.errors.ClerkErrors;
import com.clerk.backend_api.models.errors.SDKError;
import com.clerk.backend_api.models.operations.CreateSvixAppRequestBuilder;
import com.clerk.backend_api.models.operations.CreateSvixAppResponse;
import com.clerk.backend_api.models.operations.DeleteSvixAppRequestBuilder;
import com.clerk.backend_api.models.operations.DeleteSvixAppResponse;
import com.clerk.backend_api.models.operations.GenerateSvixAuthURLRequestBuilder;
import com.clerk.backend_api.models.operations.GenerateSvixAuthURLResponse;
import com.clerk.backend_api.models.operations.SDKMethodInterfaces;
import com.clerk.backend_api.utils.BackoffStrategy;
import com.clerk.backend_api.utils.HTTPClient;
import com.clerk.backend_api.utils.HTTPRequest;
import com.clerk.backend_api.utils.Hook;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.Retries;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class Webhooks
implements SDKMethodInterfaces.MethodCallCreateSvixApp,
SDKMethodInterfaces.MethodCallDeleteSvixApp,
SDKMethodInterfaces.MethodCallGenerateSvixAuthURL {
    private final SDKConfiguration sdkConfiguration;

    Webhooks(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CreateSvixAppRequestBuilder createSvixApp() {
        return new CreateSvixAppRequestBuilder(this);
    }

    public CreateSvixAppResponse createSvixAppDirect() throws Exception {
        return this.createSvixApp(Optional.empty());
    }

    @Override
    public CreateSvixAppResponse createSvixApp(Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl();
        String _url = Utils.generateURL(_baseUrl, "/webhooks/svix");
        HTTPRequest _req = new HTTPRequest(_url, "POST");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = Optional.of(this.sdkConfiguration.securitySource());
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource().getSecurity());
        HTTPClient _client = this.sdkConfiguration.client();
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig().isPresent() ? this.sdkConfiguration.retryConfig().get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(this.sdkConfiguration, _baseUrl, "CreateSvixApp", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(this.sdkConfiguration, _baseUrl, "CreateSvixApp", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(this.sdkConfiguration, _baseUrl, "CreateSvixApp", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        CreateSvixAppResponse.Builder _resBuilder = CreateSvixAppResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        CreateSvixAppResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                SvixURL _out = (SvixURL)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<SvixURL>(){});
                _res.withSvixURL(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ClerkErrors _out = (ClerkErrors)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<ClerkErrors>(){});
                throw _out;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public DeleteSvixAppRequestBuilder deleteSvixApp() {
        return new DeleteSvixAppRequestBuilder(this);
    }

    public DeleteSvixAppResponse deleteSvixAppDirect() throws Exception {
        return this.deleteSvixApp(Optional.empty());
    }

    @Override
    public DeleteSvixAppResponse deleteSvixApp(Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl();
        String _url = Utils.generateURL(_baseUrl, "/webhooks/svix");
        HTTPRequest _req = new HTTPRequest(_url, "DELETE");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = Optional.of(this.sdkConfiguration.securitySource());
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource().getSecurity());
        HTTPClient _client = this.sdkConfiguration.client();
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig().isPresent() ? this.sdkConfiguration.retryConfig().get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(this.sdkConfiguration, _baseUrl, "DeleteSvixApp", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(this.sdkConfiguration, _baseUrl, "DeleteSvixApp", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(this.sdkConfiguration, _baseUrl, "DeleteSvixApp", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        DeleteSvixAppResponse.Builder _resBuilder = DeleteSvixAppResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        DeleteSvixAppResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "204")) {
            return _res;
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ClerkErrors _out = (ClerkErrors)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<ClerkErrors>(){});
                throw _out;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public GenerateSvixAuthURLRequestBuilder generateSvixAuthURL() {
        return new GenerateSvixAuthURLRequestBuilder(this);
    }

    public GenerateSvixAuthURLResponse generateSvixAuthURLDirect() throws Exception {
        return this.generateSvixAuthURL(Optional.empty());
    }

    @Override
    public GenerateSvixAuthURLResponse generateSvixAuthURL(Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl();
        String _url = Utils.generateURL(_baseUrl, "/webhooks/svix_url");
        HTTPRequest _req = new HTTPRequest(_url, "POST");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        Optional<SecuritySource> _hookSecuritySource = Optional.of(this.sdkConfiguration.securitySource());
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource().getSecurity());
        HTTPClient _client = this.sdkConfiguration.client();
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig().isPresent() ? this.sdkConfiguration.retryConfig().get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("5XX");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(this.sdkConfiguration, _baseUrl, "GenerateSvixAuthURL", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(this.sdkConfiguration, _baseUrl, "GenerateSvixAuthURL", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(this.sdkConfiguration, _baseUrl, "GenerateSvixAuthURL", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        GenerateSvixAuthURLResponse.Builder _resBuilder = GenerateSvixAuthURLResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        GenerateSvixAuthURLResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                SvixURL _out = (SvixURL)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<SvixURL>(){});
                _res.withSvixURL(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ClerkErrors _out = (ClerkErrors)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<ClerkErrors>(){});
                throw _out;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }
}

