/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.helpers.security.models;

import com.clerk.backend_api.helpers.security.models.AuthErrorReason;
import com.clerk.backend_api.helpers.security.models.AuthStatus;
import com.clerk.backend_api.helpers.security.models.ErrorReason;
import com.clerk.backend_api.helpers.security.models.TokenVerificationErrorReason;
import com.clerk.backend_api.helpers.security.models.TokenVerificationResponse;
import com.clerk.backend_api.utils.Utils;
import io.jsonwebtoken.Claims;
import java.util.Optional;

public final class RequestState {
    private final AuthStatus status;
    private final Optional<AuthErrorReason> authErrorReason;
    private final Optional<TokenVerificationErrorReason> tokenVerificationErrorReason;
    private final Optional<String> token;
    private final Optional<TokenVerificationResponse<?>> tokenVerificationResponse;

    public RequestState(AuthStatus status, Optional<AuthErrorReason> authErrorReason, Optional<TokenVerificationErrorReason> tokenVerificationErrorReason, Optional<String> token, Optional<TokenVerificationResponse<?>> tokenVerificationResponse) {
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(authErrorReason, "authErrorReason");
        Utils.checkNotNull(tokenVerificationErrorReason, "tokenVerificationErrorReason");
        Utils.checkNotNull(token, "token");
        if (authErrorReason.isPresent() && tokenVerificationErrorReason.isPresent()) {
            throw new IllegalArgumentException("Only one of authErrorReason or tokenVerificationErrorReason should be provided.");
        }
        this.status = status;
        this.authErrorReason = authErrorReason;
        this.tokenVerificationErrorReason = tokenVerificationErrorReason;
        this.token = token;
        this.tokenVerificationResponse = tokenVerificationResponse;
    }

    public static RequestState signedIn(String token, TokenVerificationResponse<?> tokenVerificationResponse) {
        return new RequestState(AuthStatus.SIGNED_IN, Optional.empty(), Optional.empty(), Optional.of(token), Optional.of(tokenVerificationResponse));
    }

    public static RequestState signedOut(AuthErrorReason reason) {
        return new RequestState(AuthStatus.SIGNED_OUT, Optional.of(reason), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static RequestState signedOut(TokenVerificationErrorReason reason) {
        return new RequestState(AuthStatus.SIGNED_OUT, Optional.empty(), Optional.of(reason), Optional.empty(), Optional.empty());
    }

    public AuthStatus status() {
        return this.status;
    }

    public boolean isSignedIn() {
        return this.status == AuthStatus.SIGNED_IN;
    }

    public boolean isSignedOut() {
        return this.status == AuthStatus.SIGNED_OUT;
    }

    public Optional<ErrorReason> reason() {
        if (this.authErrorReason.isPresent()) {
            return Optional.of((ErrorReason)this.authErrorReason.get());
        }
        if (this.tokenVerificationErrorReason.isPresent()) {
            return Optional.of((ErrorReason)this.tokenVerificationErrorReason.get());
        }
        return Optional.empty();
    }

    public Optional<String> token() {
        return this.token;
    }

    public Optional<Claims> claims() {
        TokenVerificationResponse<?> response;
        if (this.tokenVerificationResponse.isPresent() && (response = this.tokenVerificationResponse.get()).payload() instanceof Claims) {
            return Optional.of((Claims)response.payload());
        }
        return Optional.empty();
    }

    public Optional<TokenVerificationResponse<?>> tokenVerificationResponse() {
        return this.tokenVerificationResponse;
    }
}

