/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.helpers.security.token_verifiers.impl;

import com.clerk.backend_api.helpers.security.models.TokenVerificationErrorReason;
import com.clerk.backend_api.helpers.security.models.TokenVerificationException;
import com.clerk.backend_api.helpers.security.models.TokenVerificationResponse;
import com.clerk.backend_api.helpers.security.models.VerifyTokenOptions;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.Locator;
import io.jsonwebtoken.PrematureJwtException;
import io.jsonwebtoken.impl.DefaultClaims;
import io.jsonwebtoken.impl.security.ConstantKeyLocator;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.Key;
import java.security.KeyFactory;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JwtSessionTokenVerifier {
    public static TokenVerificationResponse<Claims> verify(String token, VerifyTokenOptions options) throws TokenVerificationException {
        Object orgObject;
        Claims payload;
        Key key;
        if (options.jwtKey().isPresent()) {
            key = JwtSessionTokenVerifier.getLocalJwtKey(options.jwtKey().get());
        } else if (options.secretKey().isPresent()) {
            key = JwtSessionTokenVerifier.getRemoteJwtKey(token, options);
        } else {
            throw new TokenVerificationException(TokenVerificationErrorReason.SECRET_KEY_MISSING);
        }
        JwtParserBuilder builder = Jwts.parser().clockSkewSeconds(options.clockSkewInMs() / 1000L).keyLocator((Locator)new ConstantKeyLocator(key, null));
        options.audience().ifPresent(arg_0 -> ((JwtParserBuilder)builder).requireAudience(arg_0));
        JwtParser parser = builder.build();
        try {
            payload = (Claims)parser.parseSignedClaims((CharSequence)token).getPayload();
        }
        catch (ExpiredJwtException e) {
            throw new TokenVerificationException(TokenVerificationErrorReason.TOKEN_EXPIRED, (Throwable)e);
        }
        catch (PrematureJwtException e) {
            throw new TokenVerificationException(TokenVerificationErrorReason.TOKEN_NOT_ACTIVE_YET, (Throwable)e);
        }
        catch (JwtException e) {
            throw new TokenVerificationException(TokenVerificationErrorReason.TOKEN_INVALID, (Throwable)e);
        }
        String azp = (String)payload.get((Object)"azp");
        if (azp != null && !options.authorizedParties().isEmpty() && !options.authorizedParties().contains(azp)) {
            throw new TokenVerificationException(TokenVerificationErrorReason.TOKEN_INVALID_AUTHORIZED_PARTIES);
        }
        Date iat = payload.getIssuedAt();
        Date now = new Date();
        if (iat != null && iat.getTime() > now.getTime() + options.clockSkewInMs()) {
            throw new TokenVerificationException(TokenVerificationErrorReason.TOKEN_IAT_IN_THE_FUTURE);
        }
        Claims claims = payload;
        HashMap updatedClaimsMap = new HashMap(claims);
        if ("2".equals(String.valueOf(claims.get((Object)"v"))) && (orgObject = claims.get((Object)"o")) instanceof Map) {
            Map orgClaims = (Map)orgObject;
            updatedClaimsMap.put("org_id", orgClaims.get("id"));
            updatedClaimsMap.put("org_slug", orgClaims.get("slg"));
            updatedClaimsMap.put("org_role", orgClaims.get("rol"));
            List<String> orgPermissions = JwtSessionTokenVerifier.computeOrgPermissions(claims);
            if (!orgPermissions.isEmpty()) {
                updatedClaimsMap.put("org_permissions", orgPermissions);
            }
        }
        DefaultClaims updatedClaims = new DefaultClaims(updatedClaimsMap);
        return new TokenVerificationResponse<DefaultClaims>(updatedClaims);
    }

    private static List<String> computeOrgPermissions(Claims claims) {
        String featuresStr = (String)claims.get((Object)"fea");
        if (featuresStr == null) {
            return new ArrayList<String>();
        }
        String permissionsStr = (String)((Map)claims.get((Object)"o")).get("per");
        String mappingsStr = (String)((Map)claims.get((Object)"o")).get("fpm");
        String[] features = featuresStr.split(",");
        String[] permissions = permissionsStr.split(",");
        String[] mappings = mappingsStr.split(",");
        ArrayList<String> orgPermissions = new ArrayList<String>();
        for (int idx = 0; idx < mappings.length; ++idx) {
            String mapping = mappings[idx];
            String[] featureParts = features[idx].split(":");
            if (featureParts.length != 2) continue;
            String scope = featureParts[0];
            String feature = featureParts[1];
            if (!scope.contains("o")) continue;
            String binary = Integer.toBinaryString(Integer.parseInt(mapping)).replaceAll("^0+", "");
            String reversedBinary = new StringBuilder(binary).reverse().toString();
            for (int i = 0; i < reversedBinary.length(); ++i) {
                if (reversedBinary.charAt(i) != '1' || i >= permissions.length) continue;
                orgPermissions.add("org:" + feature + ":" + permissions[i]);
            }
        }
        return orgPermissions;
    }

    private static Key getLocalJwtKey(String jwtKey) throws TokenVerificationException {
        String pemContent = jwtKey.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replaceAll("\\s", "");
        try {
            byte[] decodedKey = Base64.getDecoder().decode(pemContent);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(decodedKey);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new TokenVerificationException(TokenVerificationErrorReason.JWK_LOCAL_INVALID, (Throwable)e);
        }
    }

    private static Key getRemoteJwtKey(String token, VerifyTokenOptions options) throws TokenVerificationException {
        String kid = JwtSessionTokenVerifier.parseKid(token);
        for (JsonNode node : JwtSessionTokenVerifier.fetchJwks(options)) {
            if (!kid.equals(node.get("kid").asText())) continue;
            try {
                KeyFactory kf = KeyFactory.getInstance("RSA");
                BigInteger n = new BigInteger(1, Base64.getUrlDecoder().decode(node.get("n").asText()));
                BigInteger e = new BigInteger(1, Base64.getUrlDecoder().decode(node.get("e").asText()));
                return kf.generatePublic(new RSAPublicKeySpec(n, e));
            }
            catch (Exception e) {
                throw new TokenVerificationException(TokenVerificationErrorReason.JWK_FAILED_TO_RESOLVE, (Throwable)e);
            }
        }
        throw new TokenVerificationException(TokenVerificationErrorReason.JWK_KID_MISMATCH);
    }

    private static String parseKid(String token) throws TokenVerificationException {
        String kid;
        String[] parts = token.split("\\.");
        if (parts.length != 3) {
            throw new TokenVerificationException(TokenVerificationErrorReason.TOKEN_INVALID);
        }
        String header = new String(Base64.getUrlDecoder().decode(parts[0]));
        ObjectMapper mapper = new ObjectMapper();
        try {
            kid = mapper.readTree(header).get("kid").asText();
        }
        catch (IOException | NullPointerException e) {
            throw new TokenVerificationException(TokenVerificationErrorReason.TOKEN_INVALID, (Throwable)e);
        }
        return kid;
    }

    private static JsonNode fetchJwks(VerifyTokenOptions options) throws TokenVerificationException {
        if (options.secretKey().isEmpty()) {
            throw new TokenVerificationException(TokenVerificationErrorReason.SECRET_KEY_MISSING);
        }
        String jwksUrl = String.format("%s/%s/jwks", options.apiUrl(), options.apiVersion());
        String bearerAuth = String.format("Bearer %s", options.secretKey().get());
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(jwksUrl)).header("Accept", "application/json").header("Authorization", bearerAuth).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new TokenVerificationException(TokenVerificationErrorReason.JWK_FAILED_TO_LOAD);
            }
            ObjectMapper mapper = new ObjectMapper();
            JsonNode keysNode = mapper.readTree(response.body()).get("keys");
            if (keysNode.isArray()) {
                return keysNode;
            }
            throw new TokenVerificationException(TokenVerificationErrorReason.JWK_REMOTE_INVALID);
        }
        catch (IOException | InterruptedException e) {
            throw new TokenVerificationException(TokenVerificationErrorReason.JWK_FAILED_TO_LOAD, (Throwable)e);
        }
    }
}

