/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.helpers.security.token_verifiers.impl;

import com.clerk.backend_api.helpers.security.models.MachineAuthVerificationData;
import com.clerk.backend_api.helpers.security.models.TokenVerificationErrorReason;
import com.clerk.backend_api.helpers.security.models.TokenVerificationException;
import com.clerk.backend_api.helpers.security.models.TokenVerificationResponse;
import com.clerk.backend_api.helpers.security.models.VerifyTokenOptions;
import com.clerk.backend_api.helpers.security.token_verifiers.TokenVerifier;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.HashMap;

public class MachineTokenVerifier
implements TokenVerifier {
    private static final String MACHINE_TOKEN_VERIFICATION_URL = "/m2m_tokens/verify";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public TokenVerificationResponse<MachineAuthVerificationData> verify(String token, VerifyTokenOptions options) throws IOException, InterruptedException, TokenVerificationException {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("secret", token);
        String jsonPayload = objectMapper.writeValueAsString(payload);
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(options.apiUrl() + MACHINE_TOKEN_VERIFICATION_URL)).header("Content-Type", "application/json").header("Authorization", "Bearer " + options.secretKey().get()).timeout(Duration.ofSeconds(30L)).POST(HttpRequest.BodyPublishers.ofString(jsonPayload)).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() == 200) {
            try {
                return new TokenVerificationResponse<MachineAuthVerificationData>((MachineAuthVerificationData)objectMapper.readValue(response.body(), MachineAuthVerificationData.class));
            }
            catch (JsonProcessingException e) {
                throw new TokenVerificationException(TokenVerificationErrorReason.FAILED_TO_PROCESS_RESPONSE, (Throwable)e);
            }
        }
        throw new TokenVerificationException(TokenVerificationErrorReason.TOKEN_INVALID);
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

