/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.AccountlessApplicationObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class AccountlessApplication {
    @JsonProperty(value="object")
    private AccountlessApplicationObject object;
    @JsonProperty(value="publishable_key")
    private String publishableKey;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="secret_key")
    private Optional<String> secretKey;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="claim_url")
    private Optional<String> claimUrl;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="api_keys_url")
    private Optional<String> apiKeysUrl;

    @JsonCreator
    public AccountlessApplication(@JsonProperty(value="object") AccountlessApplicationObject object, @JsonProperty(value="publishable_key") String publishableKey, @JsonProperty(value="secret_key") Optional<String> secretKey, @JsonProperty(value="claim_url") Optional<String> claimUrl, @JsonProperty(value="api_keys_url") Optional<String> apiKeysUrl) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(publishableKey, "publishableKey");
        Utils.checkNotNull(secretKey, "secretKey");
        Utils.checkNotNull(claimUrl, "claimUrl");
        Utils.checkNotNull(apiKeysUrl, "apiKeysUrl");
        this.object = object;
        this.publishableKey = publishableKey;
        this.secretKey = secretKey;
        this.claimUrl = claimUrl;
        this.apiKeysUrl = apiKeysUrl;
    }

    public AccountlessApplication(AccountlessApplicationObject object, String publishableKey) {
        this(object, publishableKey, Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public AccountlessApplicationObject object() {
        return this.object;
    }

    @JsonIgnore
    public String publishableKey() {
        return this.publishableKey;
    }

    @JsonIgnore
    public Optional<String> secretKey() {
        return this.secretKey;
    }

    @JsonIgnore
    public Optional<String> claimUrl() {
        return this.claimUrl;
    }

    @JsonIgnore
    public Optional<String> apiKeysUrl() {
        return this.apiKeysUrl;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AccountlessApplication withObject(AccountlessApplicationObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public AccountlessApplication withPublishableKey(String publishableKey) {
        Utils.checkNotNull(publishableKey, "publishableKey");
        this.publishableKey = publishableKey;
        return this;
    }

    public AccountlessApplication withSecretKey(String secretKey) {
        Utils.checkNotNull(secretKey, "secretKey");
        this.secretKey = Optional.ofNullable(secretKey);
        return this;
    }

    public AccountlessApplication withSecretKey(Optional<String> secretKey) {
        Utils.checkNotNull(secretKey, "secretKey");
        this.secretKey = secretKey;
        return this;
    }

    public AccountlessApplication withClaimUrl(String claimUrl) {
        Utils.checkNotNull(claimUrl, "claimUrl");
        this.claimUrl = Optional.ofNullable(claimUrl);
        return this;
    }

    public AccountlessApplication withClaimUrl(Optional<String> claimUrl) {
        Utils.checkNotNull(claimUrl, "claimUrl");
        this.claimUrl = claimUrl;
        return this;
    }

    public AccountlessApplication withApiKeysUrl(String apiKeysUrl) {
        Utils.checkNotNull(apiKeysUrl, "apiKeysUrl");
        this.apiKeysUrl = Optional.ofNullable(apiKeysUrl);
        return this;
    }

    public AccountlessApplication withApiKeysUrl(Optional<String> apiKeysUrl) {
        Utils.checkNotNull(apiKeysUrl, "apiKeysUrl");
        this.apiKeysUrl = apiKeysUrl;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountlessApplication other = (AccountlessApplication)o;
        return Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.publishableKey, other.publishableKey) && Objects.deepEquals(this.secretKey, other.secretKey) && Objects.deepEquals(this.claimUrl, other.claimUrl) && Objects.deepEquals(this.apiKeysUrl, other.apiKeysUrl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.object, this.publishableKey, this.secretKey, this.claimUrl, this.apiKeysUrl});
    }

    public String toString() {
        return Utils.toString(AccountlessApplication.class, new Object[]{"object", this.object, "publishableKey", this.publishableKey, "secretKey", this.secretKey, "claimUrl", this.claimUrl, "apiKeysUrl", this.apiKeysUrl});
    }

    public static final class Builder {
        private AccountlessApplicationObject object;
        private String publishableKey;
        private Optional<String> secretKey = Optional.empty();
        private Optional<String> claimUrl = Optional.empty();
        private Optional<String> apiKeysUrl = Optional.empty();

        private Builder() {
        }

        public Builder object(AccountlessApplicationObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder publishableKey(String publishableKey) {
            Utils.checkNotNull(publishableKey, "publishableKey");
            this.publishableKey = publishableKey;
            return this;
        }

        public Builder secretKey(String secretKey) {
            Utils.checkNotNull(secretKey, "secretKey");
            this.secretKey = Optional.ofNullable(secretKey);
            return this;
        }

        public Builder secretKey(Optional<String> secretKey) {
            Utils.checkNotNull(secretKey, "secretKey");
            this.secretKey = secretKey;
            return this;
        }

        public Builder claimUrl(String claimUrl) {
            Utils.checkNotNull(claimUrl, "claimUrl");
            this.claimUrl = Optional.ofNullable(claimUrl);
            return this;
        }

        public Builder claimUrl(Optional<String> claimUrl) {
            Utils.checkNotNull(claimUrl, "claimUrl");
            this.claimUrl = claimUrl;
            return this;
        }

        public Builder apiKeysUrl(String apiKeysUrl) {
            Utils.checkNotNull(apiKeysUrl, "apiKeysUrl");
            this.apiKeysUrl = Optional.ofNullable(apiKeysUrl);
            return this;
        }

        public Builder apiKeysUrl(Optional<String> apiKeysUrl) {
            Utils.checkNotNull(apiKeysUrl, "apiKeysUrl");
            this.apiKeysUrl = apiKeysUrl;
            return this;
        }

        public AccountlessApplication build() {
            return new AccountlessApplication(this.object, this.publishableKey, this.secretKey, this.claimUrl, this.apiKeysUrl);
        }
    }
}

