/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.ActorTokenActor;
import com.clerk.backend_api.models.components.ActorTokenObject;
import com.clerk.backend_api.models.components.ActorTokenStatus;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class ActorToken {
    @JsonProperty(value="object")
    private ActorTokenObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="status")
    private ActorTokenStatus status;
    @JsonProperty(value="user_id")
    private String userId;
    @JsonProperty(value="actor")
    private ActorTokenActor actor;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="token")
    private Optional<String> token;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="url")
    private Optional<String> url;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    @JsonCreator
    public ActorToken(@JsonProperty(value="object") ActorTokenObject object, @JsonProperty(value="id") String id, @JsonProperty(value="status") ActorTokenStatus status, @JsonProperty(value="user_id") String userId, @JsonProperty(value="actor") ActorTokenActor actor, @JsonProperty(value="token") Optional<String> token, @JsonProperty(value="url") Optional<String> url, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(actor, "actor");
        Utils.checkNotNull(token, "token");
        Utils.checkNotNull(url, "url");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.object = object;
        this.id = id;
        this.status = status;
        this.userId = userId;
        this.actor = actor;
        this.token = token;
        this.url = url;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public ActorToken(ActorTokenObject object, String id, ActorTokenStatus status, String userId, ActorTokenActor actor, long createdAt, long updatedAt) {
        this(object, id, status, userId, actor, Optional.empty(), Optional.empty(), createdAt, updatedAt);
    }

    @JsonIgnore
    public ActorTokenObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public ActorTokenStatus status() {
        return this.status;
    }

    @JsonIgnore
    public String userId() {
        return this.userId;
    }

    @JsonIgnore
    public ActorTokenActor actor() {
        return this.actor;
    }

    @JsonIgnore
    public Optional<String> token() {
        return this.token;
    }

    @JsonIgnore
    public Optional<String> url() {
        return this.url;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public ActorToken withObject(ActorTokenObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public ActorToken withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public ActorToken withStatus(ActorTokenStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public ActorToken withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public ActorToken withActor(ActorTokenActor actor) {
        Utils.checkNotNull(actor, "actor");
        this.actor = actor;
        return this;
    }

    public ActorToken withToken(String token) {
        Utils.checkNotNull(token, "token");
        this.token = Optional.ofNullable(token);
        return this;
    }

    public ActorToken withToken(Optional<String> token) {
        Utils.checkNotNull(token, "token");
        this.token = token;
        return this;
    }

    public ActorToken withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = Optional.ofNullable(url);
        return this;
    }

    public ActorToken withUrl(Optional<String> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    public ActorToken withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public ActorToken withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActorToken other = (ActorToken)o;
        return Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.id, other.id) && Objects.deepEquals((Object)this.status, (Object)other.status) && Objects.deepEquals(this.userId, other.userId) && Objects.deepEquals(this.actor, other.actor) && Objects.deepEquals(this.token, other.token) && Objects.deepEquals(this.url, other.url) && Objects.deepEquals(this.createdAt, other.createdAt) && Objects.deepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.object, this.id, this.status, this.userId, this.actor, this.token, this.url, this.createdAt, this.updatedAt});
    }

    public String toString() {
        return Utils.toString(ActorToken.class, new Object[]{"object", this.object, "id", this.id, "status", this.status, "userId", this.userId, "actor", this.actor, "token", this.token, "url", this.url, "createdAt", this.createdAt, "updatedAt", this.updatedAt});
    }

    public static final class Builder {
        private ActorTokenObject object;
        private String id;
        private ActorTokenStatus status;
        private String userId;
        private ActorTokenActor actor;
        private Optional<String> token = Optional.empty();
        private Optional<String> url = Optional.empty();
        private Long createdAt;
        private Long updatedAt;

        private Builder() {
        }

        public Builder object(ActorTokenObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder status(ActorTokenStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder actor(ActorTokenActor actor) {
            Utils.checkNotNull(actor, "actor");
            this.actor = actor;
            return this;
        }

        public Builder token(String token) {
            Utils.checkNotNull(token, "token");
            this.token = Optional.ofNullable(token);
            return this;
        }

        public Builder token(Optional<String> token) {
            Utils.checkNotNull(token, "token");
            this.token = token;
            return this;
        }

        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = Optional.ofNullable(url);
            return this;
        }

        public Builder url(Optional<String> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public ActorToken build() {
            return new ActorToken(this.object, this.id, this.status, this.userId, this.actor, this.token, this.url, this.createdAt, this.updatedAt);
        }
    }
}

