/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class CNameTarget {
    @JsonProperty(value="host")
    private String host;
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="required")
    private boolean required;

    @JsonCreator
    public CNameTarget(@JsonProperty(value="host") String host, @JsonProperty(value="value") String value, @JsonProperty(value="required") boolean required) {
        Utils.checkNotNull(host, "host");
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(required, "required");
        this.host = host;
        this.value = value;
        this.required = required;
    }

    @JsonIgnore
    public String host() {
        return this.host;
    }

    @JsonIgnore
    public String value() {
        return this.value;
    }

    @JsonIgnore
    public boolean required() {
        return this.required;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public CNameTarget withHost(String host) {
        Utils.checkNotNull(host, "host");
        this.host = host;
        return this;
    }

    public CNameTarget withValue(String value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public CNameTarget withRequired(boolean required) {
        Utils.checkNotNull(required, "required");
        this.required = required;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CNameTarget other = (CNameTarget)o;
        return Objects.deepEquals(this.host, other.host) && Objects.deepEquals(this.value, other.value) && Objects.deepEquals(this.required, other.required);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.value, this.required);
    }

    public String toString() {
        return Utils.toString(CNameTarget.class, "host", this.host, "value", this.value, "required", this.required);
    }

    public static final class Builder {
        private String host;
        private String value;
        private Boolean required;

        private Builder() {
        }

        public Builder host(String host) {
            Utils.checkNotNull(host, "host");
            this.host = host;
            return this;
        }

        public Builder value(String value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder required(boolean required) {
            Utils.checkNotNull(required, "required");
            this.required = required;
            return this;
        }

        public CNameTarget build() {
            return new CNameTarget(this.host, this.value, this.required);
        }
    }
}

