/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.CookiesObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class Cookies {
    @JsonProperty(value="object")
    private CookiesObject object;
    @JsonProperty(value="cookies")
    private List<String> cookies;

    @JsonCreator
    public Cookies(@JsonProperty(value="object") CookiesObject object, @JsonProperty(value="cookies") List<String> cookies) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(cookies, "cookies");
        this.object = object;
        this.cookies = cookies;
    }

    @JsonIgnore
    public CookiesObject object() {
        return this.object;
    }

    @JsonIgnore
    public List<String> cookies() {
        return this.cookies;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Cookies withObject(CookiesObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public Cookies withCookies(List<String> cookies) {
        Utils.checkNotNull(cookies, "cookies");
        this.cookies = cookies;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cookies other = (Cookies)o;
        return Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.cookies, other.cookies);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.object, this.cookies});
    }

    public String toString() {
        return Utils.toString(Cookies.class, new Object[]{"object", this.object, "cookies", this.cookies});
    }

    public static final class Builder {
        private CookiesObject object;
        private List<String> cookies;

        private Builder() {
        }

        public Builder object(CookiesObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder cookies(List<String> cookies) {
            Utils.checkNotNull(cookies, "cookies");
            this.cookies = cookies;
            return this;
        }

        public Cookies build() {
            return new Cookies(this.object, this.cookies);
        }
    }
}

