/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.Error;
import com.clerk.backend_api.models.components.FromOAuthVerificationStatus;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class FromOAuth {
    @JsonProperty(value="status")
    private FromOAuthVerificationStatus status;
    @JsonProperty(value="strategy")
    private String strategy;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="error")
    private JsonNullable<? extends Error> error;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="expire_at")
    private Optional<Long> expireAt;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="attempts")
    private Optional<Long> attempts;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="verified_at_client")
    private JsonNullable<String> verifiedAtClient;

    @JsonCreator
    public FromOAuth(@JsonProperty(value="status") FromOAuthVerificationStatus status, @JsonProperty(value="strategy") String strategy, @JsonProperty(value="error") JsonNullable<? extends Error> error, @JsonProperty(value="expire_at") Optional<Long> expireAt, @JsonProperty(value="attempts") Optional<Long> attempts, @JsonProperty(value="verified_at_client") JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(strategy, "strategy");
        Utils.checkNotNull(error, "error");
        Utils.checkNotNull(expireAt, "expireAt");
        Utils.checkNotNull(attempts, "attempts");
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.status = status;
        this.strategy = strategy;
        this.error = error;
        this.expireAt = expireAt;
        this.attempts = attempts;
        this.verifiedAtClient = verifiedAtClient;
    }

    public FromOAuth(FromOAuthVerificationStatus status, String strategy) {
        this(status, strategy, (JsonNullable<? extends Error>)JsonNullable.undefined(), Optional.empty(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @JsonIgnore
    public FromOAuthVerificationStatus status() {
        return this.status;
    }

    @JsonIgnore
    public String strategy() {
        return this.strategy;
    }

    @JsonIgnore
    public JsonNullable<Error> error() {
        return this.error;
    }

    @JsonIgnore
    public Optional<Long> expireAt() {
        return this.expireAt;
    }

    @JsonIgnore
    public Optional<Long> attempts() {
        return this.attempts;
    }

    @JsonIgnore
    public JsonNullable<String> verifiedAtClient() {
        return this.verifiedAtClient;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public FromOAuth withStatus(FromOAuthVerificationStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public FromOAuth withStrategy(String strategy) {
        Utils.checkNotNull(strategy, "strategy");
        this.strategy = strategy;
        return this;
    }

    public FromOAuth withError(Error error) {
        Utils.checkNotNull(error, "error");
        this.error = JsonNullable.of((Object)error);
        return this;
    }

    public FromOAuth withError(JsonNullable<? extends Error> error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }

    public FromOAuth withExpireAt(long expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = Optional.ofNullable(expireAt);
        return this;
    }

    public FromOAuth withExpireAt(Optional<Long> expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = expireAt;
        return this;
    }

    public FromOAuth withAttempts(long attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = Optional.ofNullable(attempts);
        return this;
    }

    public FromOAuth withAttempts(Optional<Long> attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = attempts;
        return this;
    }

    public FromOAuth withVerifiedAtClient(String verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
        return this;
    }

    public FromOAuth withVerifiedAtClient(JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = verifiedAtClient;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FromOAuth other = (FromOAuth)o;
        return Objects.deepEquals((Object)this.status, (Object)other.status) && Objects.deepEquals(this.strategy, other.strategy) && Objects.deepEquals(this.error, other.error) && Objects.deepEquals(this.expireAt, other.expireAt) && Objects.deepEquals(this.attempts, other.attempts) && Objects.deepEquals(this.verifiedAtClient, other.verifiedAtClient);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.strategy, this.error, this.expireAt, this.attempts, this.verifiedAtClient});
    }

    public String toString() {
        return Utils.toString(FromOAuth.class, new Object[]{"status", this.status, "strategy", this.strategy, "error", this.error, "expireAt", this.expireAt, "attempts", this.attempts, "verifiedAtClient", this.verifiedAtClient});
    }

    public static final class Builder {
        private FromOAuthVerificationStatus status;
        private String strategy;
        private JsonNullable<? extends Error> error = JsonNullable.undefined();
        private Optional<Long> expireAt = Optional.empty();
        private Optional<Long> attempts = Optional.empty();
        private JsonNullable<String> verifiedAtClient = JsonNullable.undefined();

        private Builder() {
        }

        public Builder status(FromOAuthVerificationStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder strategy(String strategy) {
            Utils.checkNotNull(strategy, "strategy");
            this.strategy = strategy;
            return this;
        }

        public Builder error(Error error) {
            Utils.checkNotNull(error, "error");
            this.error = JsonNullable.of((Object)error);
            return this;
        }

        public Builder error(JsonNullable<? extends Error> error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }

        public Builder expireAt(long expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = Optional.ofNullable(expireAt);
            return this;
        }

        public Builder expireAt(Optional<Long> expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = expireAt;
            return this;
        }

        public Builder attempts(long attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = Optional.ofNullable(attempts);
            return this;
        }

        public Builder attempts(Optional<Long> attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = attempts;
            return this;
        }

        public Builder verifiedAtClient(String verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
            return this;
        }

        public Builder verifiedAtClient(JsonNullable<String> verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = verifiedAtClient;
            return this;
        }

        public FromOAuth build() {
            return new FromOAuth(this.status, this.strategy, this.error, this.expireAt, this.attempts, this.verifiedAtClient);
        }
    }
}

