/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.GoogleOneTapVerificationError;
import com.clerk.backend_api.models.components.GoogleOneTapVerificationStatus;
import com.clerk.backend_api.models.components.GoogleOneTapVerificationStrategy;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class GoogleOneTap {
    @JsonProperty(value="status")
    private GoogleOneTapVerificationStatus status;
    @JsonProperty(value="strategy")
    private GoogleOneTapVerificationStrategy strategy;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="expire_at")
    private Optional<Long> expireAt;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="attempts")
    private Optional<Long> attempts;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="verified_at_client")
    private JsonNullable<String> verifiedAtClient;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="error")
    private JsonNullable<? extends GoogleOneTapVerificationError> error;

    @JsonCreator
    public GoogleOneTap(@JsonProperty(value="status") GoogleOneTapVerificationStatus status, @JsonProperty(value="strategy") GoogleOneTapVerificationStrategy strategy, @JsonProperty(value="expire_at") Optional<Long> expireAt, @JsonProperty(value="attempts") Optional<Long> attempts, @JsonProperty(value="verified_at_client") JsonNullable<String> verifiedAtClient, @JsonProperty(value="error") JsonNullable<? extends GoogleOneTapVerificationError> error) {
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(strategy, "strategy");
        Utils.checkNotNull(expireAt, "expireAt");
        Utils.checkNotNull(attempts, "attempts");
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        Utils.checkNotNull(error, "error");
        this.status = status;
        this.strategy = strategy;
        this.expireAt = expireAt;
        this.attempts = attempts;
        this.verifiedAtClient = verifiedAtClient;
        this.error = error;
    }

    public GoogleOneTap(GoogleOneTapVerificationStatus status, GoogleOneTapVerificationStrategy strategy) {
        this(status, strategy, Optional.empty(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends GoogleOneTapVerificationError>)JsonNullable.undefined());
    }

    @JsonIgnore
    public GoogleOneTapVerificationStatus status() {
        return this.status;
    }

    @JsonIgnore
    public GoogleOneTapVerificationStrategy strategy() {
        return this.strategy;
    }

    @JsonIgnore
    public Optional<Long> expireAt() {
        return this.expireAt;
    }

    @JsonIgnore
    public Optional<Long> attempts() {
        return this.attempts;
    }

    @JsonIgnore
    public JsonNullable<String> verifiedAtClient() {
        return this.verifiedAtClient;
    }

    @JsonIgnore
    public JsonNullable<GoogleOneTapVerificationError> error() {
        return this.error;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GoogleOneTap withStatus(GoogleOneTapVerificationStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public GoogleOneTap withStrategy(GoogleOneTapVerificationStrategy strategy) {
        Utils.checkNotNull(strategy, "strategy");
        this.strategy = strategy;
        return this;
    }

    public GoogleOneTap withExpireAt(long expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = Optional.ofNullable(expireAt);
        return this;
    }

    public GoogleOneTap withExpireAt(Optional<Long> expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = expireAt;
        return this;
    }

    public GoogleOneTap withAttempts(long attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = Optional.ofNullable(attempts);
        return this;
    }

    public GoogleOneTap withAttempts(Optional<Long> attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = attempts;
        return this;
    }

    public GoogleOneTap withVerifiedAtClient(String verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
        return this;
    }

    public GoogleOneTap withVerifiedAtClient(JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = verifiedAtClient;
        return this;
    }

    public GoogleOneTap withError(GoogleOneTapVerificationError error) {
        Utils.checkNotNull(error, "error");
        this.error = JsonNullable.of((Object)error);
        return this;
    }

    public GoogleOneTap withError(JsonNullable<? extends GoogleOneTapVerificationError> error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoogleOneTap other = (GoogleOneTap)o;
        return Objects.deepEquals((Object)this.status, (Object)other.status) && Objects.deepEquals((Object)this.strategy, (Object)other.strategy) && Objects.deepEquals(this.expireAt, other.expireAt) && Objects.deepEquals(this.attempts, other.attempts) && Objects.deepEquals(this.verifiedAtClient, other.verifiedAtClient) && Objects.deepEquals(this.error, other.error);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.strategy, this.expireAt, this.attempts, this.verifiedAtClient, this.error});
    }

    public String toString() {
        return Utils.toString(GoogleOneTap.class, new Object[]{"status", this.status, "strategy", this.strategy, "expireAt", this.expireAt, "attempts", this.attempts, "verifiedAtClient", this.verifiedAtClient, "error", this.error});
    }

    public static final class Builder {
        private GoogleOneTapVerificationStatus status;
        private GoogleOneTapVerificationStrategy strategy;
        private Optional<Long> expireAt = Optional.empty();
        private Optional<Long> attempts = Optional.empty();
        private JsonNullable<String> verifiedAtClient = JsonNullable.undefined();
        private JsonNullable<? extends GoogleOneTapVerificationError> error = JsonNullable.undefined();

        private Builder() {
        }

        public Builder status(GoogleOneTapVerificationStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder strategy(GoogleOneTapVerificationStrategy strategy) {
            Utils.checkNotNull(strategy, "strategy");
            this.strategy = strategy;
            return this;
        }

        public Builder expireAt(long expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = Optional.ofNullable(expireAt);
            return this;
        }

        public Builder expireAt(Optional<Long> expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = expireAt;
            return this;
        }

        public Builder attempts(long attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = Optional.ofNullable(attempts);
            return this;
        }

        public Builder attempts(Optional<Long> attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = attempts;
            return this;
        }

        public Builder verifiedAtClient(String verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
            return this;
        }

        public Builder verifiedAtClient(JsonNullable<String> verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = verifiedAtClient;
            return this;
        }

        public Builder error(GoogleOneTapVerificationError error) {
            Utils.checkNotNull(error, "error");
            this.error = JsonNullable.of((Object)error);
            return this;
        }

        public Builder error(JsonNullable<? extends GoogleOneTapVerificationError> error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }

        public GoogleOneTap build() {
            return new GoogleOneTap(this.status, this.strategy, this.expireAt, this.attempts, this.verifiedAtClient, this.error);
        }
    }
}

