/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class IdentificationLink {
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="id")
    private String id;

    @JsonCreator
    public IdentificationLink(@JsonProperty(value="type") String type, @JsonProperty(value="id") String id) {
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(id, "id");
        this.type = type;
        this.id = id;
    }

    @JsonIgnore
    public String type() {
        return this.type;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public IdentificationLink withType(String type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    public IdentificationLink withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentificationLink other = (IdentificationLink)o;
        return Objects.deepEquals(this.type, other.type) && Objects.deepEquals(this.id, other.id);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id);
    }

    public String toString() {
        return Utils.toString(IdentificationLink.class, "type", this.type, "id", this.id);
    }

    public static final class Builder {
        private String type;
        private String id;

        private Builder() {
        }

        public Builder type(String type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public IdentificationLink build() {
            return new IdentificationLink(this.type, this.id);
        }
    }
}

