/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.InstanceObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Instance {
    @JsonProperty(value="object")
    private InstanceObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="environment_type")
    private String environmentType;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="allowed_origins")
    private Optional<? extends List<String>> allowedOrigins;

    @JsonCreator
    public Instance(@JsonProperty(value="object") InstanceObject object, @JsonProperty(value="id") String id, @JsonProperty(value="environment_type") String environmentType, @JsonProperty(value="allowed_origins") Optional<? extends List<String>> allowedOrigins) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(environmentType, "environmentType");
        Utils.checkNotNull(allowedOrigins, "allowedOrigins");
        this.object = object;
        this.id = id;
        this.environmentType = environmentType;
        this.allowedOrigins = allowedOrigins;
    }

    public Instance(InstanceObject object, String id, String environmentType) {
        this(object, id, environmentType, Optional.empty());
    }

    @JsonIgnore
    public InstanceObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String environmentType() {
        return this.environmentType;
    }

    @JsonIgnore
    public Optional<List<String>> allowedOrigins() {
        return this.allowedOrigins;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Instance withObject(InstanceObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public Instance withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public Instance withEnvironmentType(String environmentType) {
        Utils.checkNotNull(environmentType, "environmentType");
        this.environmentType = environmentType;
        return this;
    }

    public Instance withAllowedOrigins(List<String> allowedOrigins) {
        Utils.checkNotNull(allowedOrigins, "allowedOrigins");
        this.allowedOrigins = Optional.ofNullable(allowedOrigins);
        return this;
    }

    public Instance withAllowedOrigins(Optional<? extends List<String>> allowedOrigins) {
        Utils.checkNotNull(allowedOrigins, "allowedOrigins");
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Instance other = (Instance)o;
        return Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.environmentType, other.environmentType) && Objects.deepEquals(this.allowedOrigins, other.allowedOrigins);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.object, this.id, this.environmentType, this.allowedOrigins});
    }

    public String toString() {
        return Utils.toString(Instance.class, new Object[]{"object", this.object, "id", this.id, "environmentType", this.environmentType, "allowedOrigins", this.allowedOrigins});
    }

    public static final class Builder {
        private InstanceObject object;
        private String id;
        private String environmentType;
        private Optional<? extends List<String>> allowedOrigins = Optional.empty();

        private Builder() {
        }

        public Builder object(InstanceObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder environmentType(String environmentType) {
            Utils.checkNotNull(environmentType, "environmentType");
            this.environmentType = environmentType;
            return this;
        }

        public Builder allowedOrigins(List<String> allowedOrigins) {
            Utils.checkNotNull(allowedOrigins, "allowedOrigins");
            this.allowedOrigins = Optional.ofNullable(allowedOrigins);
            return this;
        }

        public Builder allowedOrigins(Optional<? extends List<String>> allowedOrigins) {
            Utils.checkNotNull(allowedOrigins, "allowedOrigins");
            this.allowedOrigins = allowedOrigins;
            return this;
        }

        public Instance build() {
            return new Instance(this.object, this.id, this.environmentType, this.allowedOrigins);
        }
    }
}

