/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.OAuthApplicationWithSecretObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class OAuthApplicationWithSecret {
    @JsonProperty(value="object")
    private OAuthApplicationWithSecretObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="instance_id")
    private String instanceId;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="client_id")
    private String clientId;
    @JsonProperty(value="public")
    private boolean public_;
    @JsonProperty(value="scopes")
    private String scopes;
    @JsonProperty(value="redirect_uris")
    private List<String> redirectUris;
    @JsonProperty(value="callback_url")
    @Deprecated
    private String callbackUrl;
    @JsonProperty(value="authorize_url")
    private String authorizeUrl;
    @JsonProperty(value="token_fetch_url")
    private String tokenFetchUrl;
    @JsonProperty(value="user_info_url")
    private String userInfoUrl;
    @JsonProperty(value="discovery_url")
    private String discoveryUrl;
    @JsonProperty(value="token_introspection_url")
    private String tokenIntrospectionUrl;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="client_secret")
    private Optional<String> clientSecret;

    @JsonCreator
    public OAuthApplicationWithSecret(@JsonProperty(value="object") OAuthApplicationWithSecretObject object, @JsonProperty(value="id") String id, @JsonProperty(value="instance_id") String instanceId, @JsonProperty(value="name") String name, @JsonProperty(value="client_id") String clientId, @JsonProperty(value="public") boolean public_, @JsonProperty(value="scopes") String scopes, @JsonProperty(value="redirect_uris") List<String> redirectUris, @JsonProperty(value="callback_url") String callbackUrl, @JsonProperty(value="authorize_url") String authorizeUrl, @JsonProperty(value="token_fetch_url") String tokenFetchUrl, @JsonProperty(value="user_info_url") String userInfoUrl, @JsonProperty(value="discovery_url") String discoveryUrl, @JsonProperty(value="token_introspection_url") String tokenIntrospectionUrl, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt, @JsonProperty(value="client_secret") Optional<String> clientSecret) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(instanceId, "instanceId");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(clientId, "clientId");
        Utils.checkNotNull(public_, "public_");
        Utils.checkNotNull(scopes, "scopes");
        Utils.checkNotNull(redirectUris, "redirectUris");
        Utils.checkNotNull(callbackUrl, "callbackUrl");
        Utils.checkNotNull(authorizeUrl, "authorizeUrl");
        Utils.checkNotNull(tokenFetchUrl, "tokenFetchUrl");
        Utils.checkNotNull(userInfoUrl, "userInfoUrl");
        Utils.checkNotNull(discoveryUrl, "discoveryUrl");
        Utils.checkNotNull(tokenIntrospectionUrl, "tokenIntrospectionUrl");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(clientSecret, "clientSecret");
        this.object = object;
        this.id = id;
        this.instanceId = instanceId;
        this.name = name;
        this.clientId = clientId;
        this.public_ = public_;
        this.scopes = scopes;
        this.redirectUris = redirectUris;
        this.callbackUrl = callbackUrl;
        this.authorizeUrl = authorizeUrl;
        this.tokenFetchUrl = tokenFetchUrl;
        this.userInfoUrl = userInfoUrl;
        this.discoveryUrl = discoveryUrl;
        this.tokenIntrospectionUrl = tokenIntrospectionUrl;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.clientSecret = clientSecret;
    }

    public OAuthApplicationWithSecret(OAuthApplicationWithSecretObject object, String id, String instanceId, String name, String clientId, boolean public_, String scopes, List<String> redirectUris, String callbackUrl, String authorizeUrl, String tokenFetchUrl, String userInfoUrl, String discoveryUrl, String tokenIntrospectionUrl, long createdAt, long updatedAt) {
        this(object, id, instanceId, name, clientId, public_, scopes, redirectUris, callbackUrl, authorizeUrl, tokenFetchUrl, userInfoUrl, discoveryUrl, tokenIntrospectionUrl, createdAt, updatedAt, Optional.empty());
    }

    @JsonIgnore
    public OAuthApplicationWithSecretObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String instanceId() {
        return this.instanceId;
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public String clientId() {
        return this.clientId;
    }

    @JsonIgnore
    public boolean public_() {
        return this.public_;
    }

    @JsonIgnore
    public String scopes() {
        return this.scopes;
    }

    @JsonIgnore
    public List<String> redirectUris() {
        return this.redirectUris;
    }

    @Deprecated
    @JsonIgnore
    public String callbackUrl() {
        return this.callbackUrl;
    }

    @JsonIgnore
    public String authorizeUrl() {
        return this.authorizeUrl;
    }

    @JsonIgnore
    public String tokenFetchUrl() {
        return this.tokenFetchUrl;
    }

    @JsonIgnore
    public String userInfoUrl() {
        return this.userInfoUrl;
    }

    @JsonIgnore
    public String discoveryUrl() {
        return this.discoveryUrl;
    }

    @JsonIgnore
    public String tokenIntrospectionUrl() {
        return this.tokenIntrospectionUrl;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    @JsonIgnore
    public Optional<String> clientSecret() {
        return this.clientSecret;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public OAuthApplicationWithSecret withObject(OAuthApplicationWithSecretObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public OAuthApplicationWithSecret withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public OAuthApplicationWithSecret withInstanceId(String instanceId) {
        Utils.checkNotNull(instanceId, "instanceId");
        this.instanceId = instanceId;
        return this;
    }

    public OAuthApplicationWithSecret withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public OAuthApplicationWithSecret withClientId(String clientId) {
        Utils.checkNotNull(clientId, "clientId");
        this.clientId = clientId;
        return this;
    }

    public OAuthApplicationWithSecret withPublic(boolean public_) {
        Utils.checkNotNull(public_, "public_");
        this.public_ = public_;
        return this;
    }

    public OAuthApplicationWithSecret withScopes(String scopes) {
        Utils.checkNotNull(scopes, "scopes");
        this.scopes = scopes;
        return this;
    }

    public OAuthApplicationWithSecret withRedirectUris(List<String> redirectUris) {
        Utils.checkNotNull(redirectUris, "redirectUris");
        this.redirectUris = redirectUris;
        return this;
    }

    @Deprecated
    public OAuthApplicationWithSecret withCallbackUrl(String callbackUrl) {
        Utils.checkNotNull(callbackUrl, "callbackUrl");
        this.callbackUrl = callbackUrl;
        return this;
    }

    public OAuthApplicationWithSecret withAuthorizeUrl(String authorizeUrl) {
        Utils.checkNotNull(authorizeUrl, "authorizeUrl");
        this.authorizeUrl = authorizeUrl;
        return this;
    }

    public OAuthApplicationWithSecret withTokenFetchUrl(String tokenFetchUrl) {
        Utils.checkNotNull(tokenFetchUrl, "tokenFetchUrl");
        this.tokenFetchUrl = tokenFetchUrl;
        return this;
    }

    public OAuthApplicationWithSecret withUserInfoUrl(String userInfoUrl) {
        Utils.checkNotNull(userInfoUrl, "userInfoUrl");
        this.userInfoUrl = userInfoUrl;
        return this;
    }

    public OAuthApplicationWithSecret withDiscoveryUrl(String discoveryUrl) {
        Utils.checkNotNull(discoveryUrl, "discoveryUrl");
        this.discoveryUrl = discoveryUrl;
        return this;
    }

    public OAuthApplicationWithSecret withTokenIntrospectionUrl(String tokenIntrospectionUrl) {
        Utils.checkNotNull(tokenIntrospectionUrl, "tokenIntrospectionUrl");
        this.tokenIntrospectionUrl = tokenIntrospectionUrl;
        return this;
    }

    public OAuthApplicationWithSecret withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public OAuthApplicationWithSecret withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public OAuthApplicationWithSecret withClientSecret(String clientSecret) {
        Utils.checkNotNull(clientSecret, "clientSecret");
        this.clientSecret = Optional.ofNullable(clientSecret);
        return this;
    }

    public OAuthApplicationWithSecret withClientSecret(Optional<String> clientSecret) {
        Utils.checkNotNull(clientSecret, "clientSecret");
        this.clientSecret = clientSecret;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthApplicationWithSecret other = (OAuthApplicationWithSecret)o;
        return Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.instanceId, other.instanceId) && Objects.deepEquals(this.name, other.name) && Objects.deepEquals(this.clientId, other.clientId) && Objects.deepEquals(this.public_, other.public_) && Objects.deepEquals(this.scopes, other.scopes) && Objects.deepEquals(this.redirectUris, other.redirectUris) && Objects.deepEquals(this.callbackUrl, other.callbackUrl) && Objects.deepEquals(this.authorizeUrl, other.authorizeUrl) && Objects.deepEquals(this.tokenFetchUrl, other.tokenFetchUrl) && Objects.deepEquals(this.userInfoUrl, other.userInfoUrl) && Objects.deepEquals(this.discoveryUrl, other.discoveryUrl) && Objects.deepEquals(this.tokenIntrospectionUrl, other.tokenIntrospectionUrl) && Objects.deepEquals(this.createdAt, other.createdAt) && Objects.deepEquals(this.updatedAt, other.updatedAt) && Objects.deepEquals(this.clientSecret, other.clientSecret);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.object, this.id, this.instanceId, this.name, this.clientId, this.public_, this.scopes, this.redirectUris, this.callbackUrl, this.authorizeUrl, this.tokenFetchUrl, this.userInfoUrl, this.discoveryUrl, this.tokenIntrospectionUrl, this.createdAt, this.updatedAt, this.clientSecret});
    }

    public String toString() {
        return Utils.toString(OAuthApplicationWithSecret.class, new Object[]{"object", this.object, "id", this.id, "instanceId", this.instanceId, "name", this.name, "clientId", this.clientId, "public_", this.public_, "scopes", this.scopes, "redirectUris", this.redirectUris, "callbackUrl", this.callbackUrl, "authorizeUrl", this.authorizeUrl, "tokenFetchUrl", this.tokenFetchUrl, "userInfoUrl", this.userInfoUrl, "discoveryUrl", this.discoveryUrl, "tokenIntrospectionUrl", this.tokenIntrospectionUrl, "createdAt", this.createdAt, "updatedAt", this.updatedAt, "clientSecret", this.clientSecret});
    }

    public static final class Builder {
        private OAuthApplicationWithSecretObject object;
        private String id;
        private String instanceId;
        private String name;
        private String clientId;
        private Boolean public_;
        private String scopes;
        private List<String> redirectUris;
        @Deprecated
        private String callbackUrl;
        private String authorizeUrl;
        private String tokenFetchUrl;
        private String userInfoUrl;
        private String discoveryUrl;
        private String tokenIntrospectionUrl;
        private Long createdAt;
        private Long updatedAt;
        private Optional<String> clientSecret = Optional.empty();

        private Builder() {
        }

        public Builder object(OAuthApplicationWithSecretObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder instanceId(String instanceId) {
            Utils.checkNotNull(instanceId, "instanceId");
            this.instanceId = instanceId;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder clientId(String clientId) {
            Utils.checkNotNull(clientId, "clientId");
            this.clientId = clientId;
            return this;
        }

        public Builder public_(boolean public_) {
            Utils.checkNotNull(public_, "public_");
            this.public_ = public_;
            return this;
        }

        public Builder scopes(String scopes) {
            Utils.checkNotNull(scopes, "scopes");
            this.scopes = scopes;
            return this;
        }

        public Builder redirectUris(List<String> redirectUris) {
            Utils.checkNotNull(redirectUris, "redirectUris");
            this.redirectUris = redirectUris;
            return this;
        }

        @Deprecated
        public Builder callbackUrl(String callbackUrl) {
            Utils.checkNotNull(callbackUrl, "callbackUrl");
            this.callbackUrl = callbackUrl;
            return this;
        }

        public Builder authorizeUrl(String authorizeUrl) {
            Utils.checkNotNull(authorizeUrl, "authorizeUrl");
            this.authorizeUrl = authorizeUrl;
            return this;
        }

        public Builder tokenFetchUrl(String tokenFetchUrl) {
            Utils.checkNotNull(tokenFetchUrl, "tokenFetchUrl");
            this.tokenFetchUrl = tokenFetchUrl;
            return this;
        }

        public Builder userInfoUrl(String userInfoUrl) {
            Utils.checkNotNull(userInfoUrl, "userInfoUrl");
            this.userInfoUrl = userInfoUrl;
            return this;
        }

        public Builder discoveryUrl(String discoveryUrl) {
            Utils.checkNotNull(discoveryUrl, "discoveryUrl");
            this.discoveryUrl = discoveryUrl;
            return this;
        }

        public Builder tokenIntrospectionUrl(String tokenIntrospectionUrl) {
            Utils.checkNotNull(tokenIntrospectionUrl, "tokenIntrospectionUrl");
            this.tokenIntrospectionUrl = tokenIntrospectionUrl;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            Utils.checkNotNull(clientSecret, "clientSecret");
            this.clientSecret = Optional.ofNullable(clientSecret);
            return this;
        }

        public Builder clientSecret(Optional<String> clientSecret) {
            Utils.checkNotNull(clientSecret, "clientSecret");
            this.clientSecret = clientSecret;
            return this;
        }

        public OAuthApplicationWithSecret build() {
            return new OAuthApplicationWithSecret(this.object, this.id, this.instanceId, this.name, this.clientId, this.public_, this.scopes, this.redirectUris, this.callbackUrl, this.authorizeUrl, this.tokenFetchUrl, this.userInfoUrl, this.discoveryUrl, this.tokenIntrospectionUrl, this.createdAt, this.updatedAt, this.clientSecret);
        }
    }
}

