/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class OauthVerificationStatus {
    public static final OauthVerificationStatus UNVERIFIED = new OauthVerificationStatus("unverified");
    public static final OauthVerificationStatus VERIFIED = new OauthVerificationStatus("verified");
    public static final OauthVerificationStatus FAILED = new OauthVerificationStatus("failed");
    public static final OauthVerificationStatus EXPIRED = new OauthVerificationStatus("expired");
    public static final OauthVerificationStatus TRANSFERABLE = new OauthVerificationStatus("transferable");
    private static final Map<String, OauthVerificationStatus> values = OauthVerificationStatus.createValuesMap();
    private static final Map<String, OauthVerificationStatusEnum> enums = OauthVerificationStatus.createEnumsMap();
    private final String value;

    private OauthVerificationStatus(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OauthVerificationStatus of(String value) {
        Class<OauthVerificationStatus> clazz = OauthVerificationStatus.class;
        synchronized (OauthVerificationStatus.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new OauthVerificationStatus((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<OauthVerificationStatusEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OauthVerificationStatus other = (OauthVerificationStatus)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "OauthVerificationStatus [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OauthVerificationStatus[] values() {
        Class<OauthVerificationStatus> clazz = OauthVerificationStatus.class;
        synchronized (OauthVerificationStatus.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new OauthVerificationStatus[0]);
        }
    }

    private static final Map<String, OauthVerificationStatus> createValuesMap() {
        LinkedHashMap<String, OauthVerificationStatus> map = new LinkedHashMap<String, OauthVerificationStatus>();
        map.put("unverified", UNVERIFIED);
        map.put("verified", VERIFIED);
        map.put("failed", FAILED);
        map.put("expired", EXPIRED);
        map.put("transferable", TRANSFERABLE);
        return map;
    }

    private static final Map<String, OauthVerificationStatusEnum> createEnumsMap() {
        HashMap<String, OauthVerificationStatusEnum> map = new HashMap<String, OauthVerificationStatusEnum>();
        map.put("unverified", OauthVerificationStatusEnum.UNVERIFIED);
        map.put("verified", OauthVerificationStatusEnum.VERIFIED);
        map.put("failed", OauthVerificationStatusEnum.FAILED);
        map.put("expired", OauthVerificationStatusEnum.EXPIRED);
        map.put("transferable", OauthVerificationStatusEnum.TRANSFERABLE);
        return map;
    }

    public static enum OauthVerificationStatusEnum {
        UNVERIFIED("unverified"),
        VERIFIED("verified"),
        FAILED("failed"),
        EXPIRED("expired"),
        TRANSFERABLE("transferable");

        private final String value;

        private OauthVerificationStatusEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<OauthVerificationStatus> {
        protected _Deserializer() {
            super(OauthVerificationStatus.class);
        }

        public OauthVerificationStatus deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return OauthVerificationStatus.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<OauthVerificationStatus> {
        protected _Serializer() {
            super(OauthVerificationStatus.class);
        }

        public void serialize(OauthVerificationStatus value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

