/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.OrganizationObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Organization {
    @JsonProperty(value="object")
    private OrganizationObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="slug")
    private String slug;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="members_count")
    private Optional<Long> membersCount;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="missing_member_with_elevated_permissions")
    private Optional<Boolean> missingMemberWithElevatedPermissions;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="pending_invitations_count")
    private Optional<Long> pendingInvitationsCount;
    @JsonProperty(value="max_allowed_memberships")
    private long maxAllowedMemberships;
    @JsonProperty(value="admin_delete_enabled")
    private boolean adminDeleteEnabled;
    @JsonProperty(value="public_metadata")
    private Map<String, Object> publicMetadata;
    @JsonProperty(value="private_metadata")
    private Map<String, Object> privateMetadata;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="created_by")
    private Optional<String> createdBy;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    @JsonCreator
    public Organization(@JsonProperty(value="object") OrganizationObject object, @JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="slug") String slug, @JsonProperty(value="members_count") Optional<Long> membersCount, @JsonProperty(value="missing_member_with_elevated_permissions") Optional<Boolean> missingMemberWithElevatedPermissions, @JsonProperty(value="pending_invitations_count") Optional<Long> pendingInvitationsCount, @JsonProperty(value="max_allowed_memberships") long maxAllowedMemberships, @JsonProperty(value="admin_delete_enabled") boolean adminDeleteEnabled, @JsonProperty(value="public_metadata") Map<String, Object> publicMetadata, @JsonProperty(value="private_metadata") Map<String, Object> privateMetadata, @JsonProperty(value="created_by") Optional<String> createdBy, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(slug, "slug");
        Utils.checkNotNull(membersCount, "membersCount");
        Utils.checkNotNull(missingMemberWithElevatedPermissions, "missingMemberWithElevatedPermissions");
        Utils.checkNotNull(pendingInvitationsCount, "pendingInvitationsCount");
        Utils.checkNotNull(maxAllowedMemberships, "maxAllowedMemberships");
        Utils.checkNotNull(adminDeleteEnabled, "adminDeleteEnabled");
        publicMetadata = Utils.emptyMapIfNull(publicMetadata);
        privateMetadata = Utils.emptyMapIfNull(privateMetadata);
        Utils.checkNotNull(createdBy, "createdBy");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.object = object;
        this.id = id;
        this.name = name;
        this.slug = slug;
        this.membersCount = membersCount;
        this.missingMemberWithElevatedPermissions = missingMemberWithElevatedPermissions;
        this.pendingInvitationsCount = pendingInvitationsCount;
        this.maxAllowedMemberships = maxAllowedMemberships;
        this.adminDeleteEnabled = adminDeleteEnabled;
        this.publicMetadata = publicMetadata;
        this.privateMetadata = privateMetadata;
        this.createdBy = createdBy;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public Organization(OrganizationObject object, String id, String name, String slug, long maxAllowedMemberships, boolean adminDeleteEnabled, Map<String, Object> publicMetadata, Map<String, Object> privateMetadata, long createdAt, long updatedAt) {
        this(object, id, name, slug, Optional.empty(), Optional.empty(), Optional.empty(), maxAllowedMemberships, adminDeleteEnabled, publicMetadata, privateMetadata, Optional.empty(), createdAt, updatedAt);
    }

    @JsonIgnore
    public OrganizationObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public String slug() {
        return this.slug;
    }

    @JsonIgnore
    public Optional<Long> membersCount() {
        return this.membersCount;
    }

    @JsonIgnore
    public Optional<Boolean> missingMemberWithElevatedPermissions() {
        return this.missingMemberWithElevatedPermissions;
    }

    @JsonIgnore
    public Optional<Long> pendingInvitationsCount() {
        return this.pendingInvitationsCount;
    }

    @JsonIgnore
    public long maxAllowedMemberships() {
        return this.maxAllowedMemberships;
    }

    @JsonIgnore
    public boolean adminDeleteEnabled() {
        return this.adminDeleteEnabled;
    }

    @JsonIgnore
    public Map<String, Object> publicMetadata() {
        return this.publicMetadata;
    }

    @JsonIgnore
    public Map<String, Object> privateMetadata() {
        return this.privateMetadata;
    }

    @JsonIgnore
    public Optional<String> createdBy() {
        return this.createdBy;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Organization withObject(OrganizationObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public Organization withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public Organization withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public Organization withSlug(String slug) {
        Utils.checkNotNull(slug, "slug");
        this.slug = slug;
        return this;
    }

    public Organization withMembersCount(long membersCount) {
        Utils.checkNotNull(membersCount, "membersCount");
        this.membersCount = Optional.ofNullable(membersCount);
        return this;
    }

    public Organization withMembersCount(Optional<Long> membersCount) {
        Utils.checkNotNull(membersCount, "membersCount");
        this.membersCount = membersCount;
        return this;
    }

    public Organization withMissingMemberWithElevatedPermissions(boolean missingMemberWithElevatedPermissions) {
        Utils.checkNotNull(missingMemberWithElevatedPermissions, "missingMemberWithElevatedPermissions");
        this.missingMemberWithElevatedPermissions = Optional.ofNullable(missingMemberWithElevatedPermissions);
        return this;
    }

    public Organization withMissingMemberWithElevatedPermissions(Optional<Boolean> missingMemberWithElevatedPermissions) {
        Utils.checkNotNull(missingMemberWithElevatedPermissions, "missingMemberWithElevatedPermissions");
        this.missingMemberWithElevatedPermissions = missingMemberWithElevatedPermissions;
        return this;
    }

    public Organization withPendingInvitationsCount(long pendingInvitationsCount) {
        Utils.checkNotNull(pendingInvitationsCount, "pendingInvitationsCount");
        this.pendingInvitationsCount = Optional.ofNullable(pendingInvitationsCount);
        return this;
    }

    public Organization withPendingInvitationsCount(Optional<Long> pendingInvitationsCount) {
        Utils.checkNotNull(pendingInvitationsCount, "pendingInvitationsCount");
        this.pendingInvitationsCount = pendingInvitationsCount;
        return this;
    }

    public Organization withMaxAllowedMemberships(long maxAllowedMemberships) {
        Utils.checkNotNull(maxAllowedMemberships, "maxAllowedMemberships");
        this.maxAllowedMemberships = maxAllowedMemberships;
        return this;
    }

    public Organization withAdminDeleteEnabled(boolean adminDeleteEnabled) {
        Utils.checkNotNull(adminDeleteEnabled, "adminDeleteEnabled");
        this.adminDeleteEnabled = adminDeleteEnabled;
        return this;
    }

    public Organization withPublicMetadata(Map<String, Object> publicMetadata) {
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        this.publicMetadata = publicMetadata;
        return this;
    }

    public Organization withPrivateMetadata(Map<String, Object> privateMetadata) {
        Utils.checkNotNull(privateMetadata, "privateMetadata");
        this.privateMetadata = privateMetadata;
        return this;
    }

    public Organization withCreatedBy(String createdBy) {
        Utils.checkNotNull(createdBy, "createdBy");
        this.createdBy = Optional.ofNullable(createdBy);
        return this;
    }

    public Organization withCreatedBy(Optional<String> createdBy) {
        Utils.checkNotNull(createdBy, "createdBy");
        this.createdBy = createdBy;
        return this;
    }

    public Organization withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public Organization withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Organization other = (Organization)o;
        return Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.name, other.name) && Objects.deepEquals(this.slug, other.slug) && Objects.deepEquals(this.membersCount, other.membersCount) && Objects.deepEquals(this.missingMemberWithElevatedPermissions, other.missingMemberWithElevatedPermissions) && Objects.deepEquals(this.pendingInvitationsCount, other.pendingInvitationsCount) && Objects.deepEquals(this.maxAllowedMemberships, other.maxAllowedMemberships) && Objects.deepEquals(this.adminDeleteEnabled, other.adminDeleteEnabled) && Objects.deepEquals(this.publicMetadata, other.publicMetadata) && Objects.deepEquals(this.privateMetadata, other.privateMetadata) && Objects.deepEquals(this.createdBy, other.createdBy) && Objects.deepEquals(this.createdAt, other.createdAt) && Objects.deepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.object, this.id, this.name, this.slug, this.membersCount, this.missingMemberWithElevatedPermissions, this.pendingInvitationsCount, this.maxAllowedMemberships, this.adminDeleteEnabled, this.publicMetadata, this.privateMetadata, this.createdBy, this.createdAt, this.updatedAt});
    }

    public String toString() {
        return Utils.toString(Organization.class, new Object[]{"object", this.object, "id", this.id, "name", this.name, "slug", this.slug, "membersCount", this.membersCount, "missingMemberWithElevatedPermissions", this.missingMemberWithElevatedPermissions, "pendingInvitationsCount", this.pendingInvitationsCount, "maxAllowedMemberships", this.maxAllowedMemberships, "adminDeleteEnabled", this.adminDeleteEnabled, "publicMetadata", this.publicMetadata, "privateMetadata", this.privateMetadata, "createdBy", this.createdBy, "createdAt", this.createdAt, "updatedAt", this.updatedAt});
    }

    public static final class Builder {
        private OrganizationObject object;
        private String id;
        private String name;
        private String slug;
        private Optional<Long> membersCount = Optional.empty();
        private Optional<Boolean> missingMemberWithElevatedPermissions = Optional.empty();
        private Optional<Long> pendingInvitationsCount = Optional.empty();
        private Long maxAllowedMemberships;
        private Boolean adminDeleteEnabled;
        private Map<String, Object> publicMetadata;
        private Map<String, Object> privateMetadata;
        private Optional<String> createdBy = Optional.empty();
        private Long createdAt;
        private Long updatedAt;

        private Builder() {
        }

        public Builder object(OrganizationObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder slug(String slug) {
            Utils.checkNotNull(slug, "slug");
            this.slug = slug;
            return this;
        }

        public Builder membersCount(long membersCount) {
            Utils.checkNotNull(membersCount, "membersCount");
            this.membersCount = Optional.ofNullable(membersCount);
            return this;
        }

        public Builder membersCount(Optional<Long> membersCount) {
            Utils.checkNotNull(membersCount, "membersCount");
            this.membersCount = membersCount;
            return this;
        }

        public Builder missingMemberWithElevatedPermissions(boolean missingMemberWithElevatedPermissions) {
            Utils.checkNotNull(missingMemberWithElevatedPermissions, "missingMemberWithElevatedPermissions");
            this.missingMemberWithElevatedPermissions = Optional.ofNullable(missingMemberWithElevatedPermissions);
            return this;
        }

        public Builder missingMemberWithElevatedPermissions(Optional<Boolean> missingMemberWithElevatedPermissions) {
            Utils.checkNotNull(missingMemberWithElevatedPermissions, "missingMemberWithElevatedPermissions");
            this.missingMemberWithElevatedPermissions = missingMemberWithElevatedPermissions;
            return this;
        }

        public Builder pendingInvitationsCount(long pendingInvitationsCount) {
            Utils.checkNotNull(pendingInvitationsCount, "pendingInvitationsCount");
            this.pendingInvitationsCount = Optional.ofNullable(pendingInvitationsCount);
            return this;
        }

        public Builder pendingInvitationsCount(Optional<Long> pendingInvitationsCount) {
            Utils.checkNotNull(pendingInvitationsCount, "pendingInvitationsCount");
            this.pendingInvitationsCount = pendingInvitationsCount;
            return this;
        }

        public Builder maxAllowedMemberships(long maxAllowedMemberships) {
            Utils.checkNotNull(maxAllowedMemberships, "maxAllowedMemberships");
            this.maxAllowedMemberships = maxAllowedMemberships;
            return this;
        }

        public Builder adminDeleteEnabled(boolean adminDeleteEnabled) {
            Utils.checkNotNull(adminDeleteEnabled, "adminDeleteEnabled");
            this.adminDeleteEnabled = adminDeleteEnabled;
            return this;
        }

        public Builder publicMetadata(Map<String, Object> publicMetadata) {
            Utils.checkNotNull(publicMetadata, "publicMetadata");
            this.publicMetadata = publicMetadata;
            return this;
        }

        public Builder privateMetadata(Map<String, Object> privateMetadata) {
            Utils.checkNotNull(privateMetadata, "privateMetadata");
            this.privateMetadata = privateMetadata;
            return this;
        }

        public Builder createdBy(String createdBy) {
            Utils.checkNotNull(createdBy, "createdBy");
            this.createdBy = Optional.ofNullable(createdBy);
            return this;
        }

        public Builder createdBy(Optional<String> createdBy) {
            Utils.checkNotNull(createdBy, "createdBy");
            this.createdBy = createdBy;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public Organization build() {
            return new Organization(this.object, this.id, this.name, this.slug, this.membersCount, this.missingMemberWithElevatedPermissions, this.pendingInvitationsCount, this.maxAllowedMemberships, this.adminDeleteEnabled, this.publicMetadata, this.privateMetadata, this.createdBy, this.createdAt, this.updatedAt);
        }
    }
}

