/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.EnrollmentMode;
import com.clerk.backend_api.models.components.OrganizationDomainObject;
import com.clerk.backend_api.models.components.OrganizationDomainVerification;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class OrganizationDomain {
    @JsonProperty(value="object")
    private OrganizationDomainObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="organization_id")
    private String organizationId;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="enrollment_mode")
    private EnrollmentMode enrollmentMode;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="affiliation_email_address")
    private Optional<String> affiliationEmailAddress;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="verification")
    private Optional<? extends OrganizationDomainVerification> verification;
    @JsonProperty(value="total_pending_invitations")
    private int totalPendingInvitations;
    @JsonProperty(value="total_pending_suggestions")
    private int totalPendingSuggestions;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    @JsonCreator
    public OrganizationDomain(@JsonProperty(value="object") OrganizationDomainObject object, @JsonProperty(value="id") String id, @JsonProperty(value="organization_id") String organizationId, @JsonProperty(value="name") String name, @JsonProperty(value="enrollment_mode") EnrollmentMode enrollmentMode, @JsonProperty(value="affiliation_email_address") Optional<String> affiliationEmailAddress, @JsonProperty(value="verification") Optional<? extends OrganizationDomainVerification> verification, @JsonProperty(value="total_pending_invitations") int totalPendingInvitations, @JsonProperty(value="total_pending_suggestions") int totalPendingSuggestions, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(enrollmentMode, "enrollmentMode");
        Utils.checkNotNull(affiliationEmailAddress, "affiliationEmailAddress");
        Utils.checkNotNull(verification, "verification");
        Utils.checkNotNull(totalPendingInvitations, "totalPendingInvitations");
        Utils.checkNotNull(totalPendingSuggestions, "totalPendingSuggestions");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.object = object;
        this.id = id;
        this.organizationId = organizationId;
        this.name = name;
        this.enrollmentMode = enrollmentMode;
        this.affiliationEmailAddress = affiliationEmailAddress;
        this.verification = verification;
        this.totalPendingInvitations = totalPendingInvitations;
        this.totalPendingSuggestions = totalPendingSuggestions;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public OrganizationDomain(OrganizationDomainObject object, String id, String organizationId, String name, EnrollmentMode enrollmentMode, int totalPendingInvitations, int totalPendingSuggestions, long createdAt, long updatedAt) {
        this(object, id, organizationId, name, enrollmentMode, Optional.empty(), Optional.empty(), totalPendingInvitations, totalPendingSuggestions, createdAt, updatedAt);
    }

    @JsonIgnore
    public OrganizationDomainObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String organizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public EnrollmentMode enrollmentMode() {
        return this.enrollmentMode;
    }

    @JsonIgnore
    public Optional<String> affiliationEmailAddress() {
        return this.affiliationEmailAddress;
    }

    @JsonIgnore
    public Optional<OrganizationDomainVerification> verification() {
        return this.verification;
    }

    @JsonIgnore
    public int totalPendingInvitations() {
        return this.totalPendingInvitations;
    }

    @JsonIgnore
    public int totalPendingSuggestions() {
        return this.totalPendingSuggestions;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public OrganizationDomain withObject(OrganizationDomainObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public OrganizationDomain withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public OrganizationDomain withOrganizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public OrganizationDomain withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public OrganizationDomain withEnrollmentMode(EnrollmentMode enrollmentMode) {
        Utils.checkNotNull(enrollmentMode, "enrollmentMode");
        this.enrollmentMode = enrollmentMode;
        return this;
    }

    public OrganizationDomain withAffiliationEmailAddress(String affiliationEmailAddress) {
        Utils.checkNotNull(affiliationEmailAddress, "affiliationEmailAddress");
        this.affiliationEmailAddress = Optional.ofNullable(affiliationEmailAddress);
        return this;
    }

    public OrganizationDomain withAffiliationEmailAddress(Optional<String> affiliationEmailAddress) {
        Utils.checkNotNull(affiliationEmailAddress, "affiliationEmailAddress");
        this.affiliationEmailAddress = affiliationEmailAddress;
        return this;
    }

    public OrganizationDomain withVerification(OrganizationDomainVerification verification) {
        Utils.checkNotNull(verification, "verification");
        this.verification = Optional.ofNullable(verification);
        return this;
    }

    public OrganizationDomain withVerification(Optional<? extends OrganizationDomainVerification> verification) {
        Utils.checkNotNull(verification, "verification");
        this.verification = verification;
        return this;
    }

    public OrganizationDomain withTotalPendingInvitations(int totalPendingInvitations) {
        Utils.checkNotNull(totalPendingInvitations, "totalPendingInvitations");
        this.totalPendingInvitations = totalPendingInvitations;
        return this;
    }

    public OrganizationDomain withTotalPendingSuggestions(int totalPendingSuggestions) {
        Utils.checkNotNull(totalPendingSuggestions, "totalPendingSuggestions");
        this.totalPendingSuggestions = totalPendingSuggestions;
        return this;
    }

    public OrganizationDomain withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public OrganizationDomain withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationDomain other = (OrganizationDomain)o;
        return Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.organizationId, other.organizationId) && Objects.deepEquals(this.name, other.name) && Objects.deepEquals((Object)this.enrollmentMode, (Object)other.enrollmentMode) && Objects.deepEquals(this.affiliationEmailAddress, other.affiliationEmailAddress) && Objects.deepEquals(this.verification, other.verification) && Objects.deepEquals(this.totalPendingInvitations, other.totalPendingInvitations) && Objects.deepEquals(this.totalPendingSuggestions, other.totalPendingSuggestions) && Objects.deepEquals(this.createdAt, other.createdAt) && Objects.deepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.object, this.id, this.organizationId, this.name, this.enrollmentMode, this.affiliationEmailAddress, this.verification, this.totalPendingInvitations, this.totalPendingSuggestions, this.createdAt, this.updatedAt});
    }

    public String toString() {
        return Utils.toString(OrganizationDomain.class, new Object[]{"object", this.object, "id", this.id, "organizationId", this.organizationId, "name", this.name, "enrollmentMode", this.enrollmentMode, "affiliationEmailAddress", this.affiliationEmailAddress, "verification", this.verification, "totalPendingInvitations", this.totalPendingInvitations, "totalPendingSuggestions", this.totalPendingSuggestions, "createdAt", this.createdAt, "updatedAt", this.updatedAt});
    }

    public static final class Builder {
        private OrganizationDomainObject object;
        private String id;
        private String organizationId;
        private String name;
        private EnrollmentMode enrollmentMode;
        private Optional<String> affiliationEmailAddress = Optional.empty();
        private Optional<? extends OrganizationDomainVerification> verification = Optional.empty();
        private Integer totalPendingInvitations;
        private Integer totalPendingSuggestions;
        private Long createdAt;
        private Long updatedAt;

        private Builder() {
        }

        public Builder object(OrganizationDomainObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder organizationId(String organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder enrollmentMode(EnrollmentMode enrollmentMode) {
            Utils.checkNotNull(enrollmentMode, "enrollmentMode");
            this.enrollmentMode = enrollmentMode;
            return this;
        }

        public Builder affiliationEmailAddress(String affiliationEmailAddress) {
            Utils.checkNotNull(affiliationEmailAddress, "affiliationEmailAddress");
            this.affiliationEmailAddress = Optional.ofNullable(affiliationEmailAddress);
            return this;
        }

        public Builder affiliationEmailAddress(Optional<String> affiliationEmailAddress) {
            Utils.checkNotNull(affiliationEmailAddress, "affiliationEmailAddress");
            this.affiliationEmailAddress = affiliationEmailAddress;
            return this;
        }

        public Builder verification(OrganizationDomainVerification verification) {
            Utils.checkNotNull(verification, "verification");
            this.verification = Optional.ofNullable(verification);
            return this;
        }

        public Builder verification(Optional<? extends OrganizationDomainVerification> verification) {
            Utils.checkNotNull(verification, "verification");
            this.verification = verification;
            return this;
        }

        public Builder totalPendingInvitations(int totalPendingInvitations) {
            Utils.checkNotNull(totalPendingInvitations, "totalPendingInvitations");
            this.totalPendingInvitations = totalPendingInvitations;
            return this;
        }

        public Builder totalPendingSuggestions(int totalPendingSuggestions) {
            Utils.checkNotNull(totalPendingSuggestions, "totalPendingSuggestions");
            this.totalPendingSuggestions = totalPendingSuggestions;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public OrganizationDomain build() {
            return new OrganizationDomain(this.object, this.id, this.organizationId, this.name, this.enrollmentMode, this.affiliationEmailAddress, this.verification, this.totalPendingInvitations, this.totalPendingSuggestions, this.createdAt, this.updatedAt);
        }
    }
}

