/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.OrganizationDomainStatus;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class OrganizationDomainVerification {
    @JsonProperty(value="status")
    private OrganizationDomainStatus status;
    @JsonProperty(value="strategy")
    private String strategy;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="attempts")
    private Optional<Long> attempts;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="expire_at")
    private Optional<Long> expireAt;

    @JsonCreator
    public OrganizationDomainVerification(@JsonProperty(value="status") OrganizationDomainStatus status, @JsonProperty(value="strategy") String strategy, @JsonProperty(value="attempts") Optional<Long> attempts, @JsonProperty(value="expire_at") Optional<Long> expireAt) {
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(strategy, "strategy");
        Utils.checkNotNull(attempts, "attempts");
        Utils.checkNotNull(expireAt, "expireAt");
        this.status = status;
        this.strategy = strategy;
        this.attempts = attempts;
        this.expireAt = expireAt;
    }

    public OrganizationDomainVerification(OrganizationDomainStatus status, String strategy) {
        this(status, strategy, Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public OrganizationDomainStatus status() {
        return this.status;
    }

    @JsonIgnore
    public String strategy() {
        return this.strategy;
    }

    @JsonIgnore
    public Optional<Long> attempts() {
        return this.attempts;
    }

    @JsonIgnore
    public Optional<Long> expireAt() {
        return this.expireAt;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public OrganizationDomainVerification withStatus(OrganizationDomainStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public OrganizationDomainVerification withStrategy(String strategy) {
        Utils.checkNotNull(strategy, "strategy");
        this.strategy = strategy;
        return this;
    }

    public OrganizationDomainVerification withAttempts(long attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = Optional.ofNullable(attempts);
        return this;
    }

    public OrganizationDomainVerification withAttempts(Optional<Long> attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = attempts;
        return this;
    }

    public OrganizationDomainVerification withExpireAt(long expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = Optional.ofNullable(expireAt);
        return this;
    }

    public OrganizationDomainVerification withExpireAt(Optional<Long> expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = expireAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationDomainVerification other = (OrganizationDomainVerification)o;
        return Objects.deepEquals((Object)this.status, (Object)other.status) && Objects.deepEquals(this.strategy, other.strategy) && Objects.deepEquals(this.attempts, other.attempts) && Objects.deepEquals(this.expireAt, other.expireAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.strategy, this.attempts, this.expireAt});
    }

    public String toString() {
        return Utils.toString(OrganizationDomainVerification.class, new Object[]{"status", this.status, "strategy", this.strategy, "attempts", this.attempts, "expireAt", this.expireAt});
    }

    public static final class Builder {
        private OrganizationDomainStatus status;
        private String strategy;
        private Optional<Long> attempts = Optional.empty();
        private Optional<Long> expireAt = Optional.empty();

        private Builder() {
        }

        public Builder status(OrganizationDomainStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder strategy(String strategy) {
            Utils.checkNotNull(strategy, "strategy");
            this.strategy = strategy;
            return this;
        }

        public Builder attempts(long attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = Optional.ofNullable(attempts);
            return this;
        }

        public Builder attempts(Optional<Long> attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = attempts;
            return this;
        }

        public Builder expireAt(long expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = Optional.ofNullable(expireAt);
            return this;
        }

        public Builder expireAt(Optional<Long> expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = expireAt;
            return this;
        }

        public OrganizationDomainVerification build() {
            return new OrganizationDomainVerification(this.status, this.strategy, this.attempts, this.expireAt);
        }
    }
}

