/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.OrganizationInvitation;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class OrganizationInvitations {
    @JsonProperty(value="data")
    private List<OrganizationInvitation> data;
    @JsonProperty(value="total_count")
    private long totalCount;

    @JsonCreator
    public OrganizationInvitations(@JsonProperty(value="data") List<OrganizationInvitation> data, @JsonProperty(value="total_count") long totalCount) {
        Utils.checkNotNull(data, "data");
        Utils.checkNotNull(totalCount, "totalCount");
        this.data = data;
        this.totalCount = totalCount;
    }

    @JsonIgnore
    public List<OrganizationInvitation> data() {
        return this.data;
    }

    @JsonIgnore
    public long totalCount() {
        return this.totalCount;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public OrganizationInvitations withData(List<OrganizationInvitation> data) {
        Utils.checkNotNull(data, "data");
        this.data = data;
        return this;
    }

    public OrganizationInvitations withTotalCount(long totalCount) {
        Utils.checkNotNull(totalCount, "totalCount");
        this.totalCount = totalCount;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationInvitations other = (OrganizationInvitations)o;
        return Objects.deepEquals(this.data, other.data) && Objects.deepEquals(this.totalCount, other.totalCount);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.totalCount);
    }

    public String toString() {
        return Utils.toString(OrganizationInvitations.class, "data", this.data, "totalCount", this.totalCount);
    }

    public static final class Builder {
        private List<OrganizationInvitation> data;
        private Long totalCount;

        private Builder() {
        }

        public Builder data(List<OrganizationInvitation> data) {
            Utils.checkNotNull(data, "data");
            this.data = data;
            return this;
        }

        public Builder totalCount(long totalCount) {
            Utils.checkNotNull(totalCount, "totalCount");
            this.totalCount = totalCount;
            return this;
        }

        public OrganizationInvitations build() {
            return new OrganizationInvitations(this.data, this.totalCount);
        }
    }
}

