/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.OrganizationMembershipObject;
import com.clerk.backend_api.models.components.OrganizationMembershipOrganization;
import com.clerk.backend_api.models.components.OrganizationMembershipPublicUserData;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class OrganizationMembership {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="object")
    private OrganizationMembershipObject object;
    @JsonProperty(value="role")
    private String role;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="role_name")
    private Optional<String> roleName;
    @JsonProperty(value="permissions")
    private List<String> permissions;
    @JsonProperty(value="public_metadata")
    private Map<String, Object> publicMetadata;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="private_metadata")
    private Optional<? extends Map<String, Object>> privateMetadata;
    @JsonProperty(value="organization")
    private OrganizationMembershipOrganization organization;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="public_user_data")
    private Optional<? extends OrganizationMembershipPublicUserData> publicUserData;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    @JsonCreator
    public OrganizationMembership(@JsonProperty(value="id") String id, @JsonProperty(value="object") OrganizationMembershipObject object, @JsonProperty(value="role") String role, @JsonProperty(value="role_name") Optional<String> roleName, @JsonProperty(value="permissions") List<String> permissions, @JsonProperty(value="public_metadata") Map<String, Object> publicMetadata, @JsonProperty(value="private_metadata") Optional<? extends Map<String, Object>> privateMetadata, @JsonProperty(value="organization") OrganizationMembershipOrganization organization, @JsonProperty(value="public_user_data") Optional<? extends OrganizationMembershipPublicUserData> publicUserData, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(role, "role");
        Utils.checkNotNull(roleName, "roleName");
        Utils.checkNotNull(permissions, "permissions");
        publicMetadata = Utils.emptyMapIfNull(publicMetadata);
        Utils.checkNotNull(privateMetadata, "privateMetadata");
        Utils.checkNotNull(organization, "organization");
        Utils.checkNotNull(publicUserData, "publicUserData");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.object = object;
        this.role = role;
        this.roleName = roleName;
        this.permissions = permissions;
        this.publicMetadata = publicMetadata;
        this.privateMetadata = privateMetadata;
        this.organization = organization;
        this.publicUserData = publicUserData;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public OrganizationMembership(String id, OrganizationMembershipObject object, String role, List<String> permissions, Map<String, Object> publicMetadata, OrganizationMembershipOrganization organization, long createdAt, long updatedAt) {
        this(id, object, role, Optional.empty(), permissions, publicMetadata, Optional.empty(), organization, Optional.empty(), createdAt, updatedAt);
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public OrganizationMembershipObject object() {
        return this.object;
    }

    @JsonIgnore
    public String role() {
        return this.role;
    }

    @JsonIgnore
    public Optional<String> roleName() {
        return this.roleName;
    }

    @JsonIgnore
    public List<String> permissions() {
        return this.permissions;
    }

    @JsonIgnore
    public Map<String, Object> publicMetadata() {
        return this.publicMetadata;
    }

    @JsonIgnore
    public Optional<Map<String, Object>> privateMetadata() {
        return this.privateMetadata;
    }

    @JsonIgnore
    public OrganizationMembershipOrganization organization() {
        return this.organization;
    }

    @JsonIgnore
    public Optional<OrganizationMembershipPublicUserData> publicUserData() {
        return this.publicUserData;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public OrganizationMembership withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public OrganizationMembership withObject(OrganizationMembershipObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public OrganizationMembership withRole(String role) {
        Utils.checkNotNull(role, "role");
        this.role = role;
        return this;
    }

    public OrganizationMembership withRoleName(String roleName) {
        Utils.checkNotNull(roleName, "roleName");
        this.roleName = Optional.ofNullable(roleName);
        return this;
    }

    public OrganizationMembership withRoleName(Optional<String> roleName) {
        Utils.checkNotNull(roleName, "roleName");
        this.roleName = roleName;
        return this;
    }

    public OrganizationMembership withPermissions(List<String> permissions) {
        Utils.checkNotNull(permissions, "permissions");
        this.permissions = permissions;
        return this;
    }

    public OrganizationMembership withPublicMetadata(Map<String, Object> publicMetadata) {
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        this.publicMetadata = publicMetadata;
        return this;
    }

    public OrganizationMembership withPrivateMetadata(Map<String, Object> privateMetadata) {
        Utils.checkNotNull(privateMetadata, "privateMetadata");
        this.privateMetadata = Optional.ofNullable(privateMetadata);
        return this;
    }

    public OrganizationMembership withPrivateMetadata(Optional<? extends Map<String, Object>> privateMetadata) {
        Utils.checkNotNull(privateMetadata, "privateMetadata");
        this.privateMetadata = privateMetadata;
        return this;
    }

    public OrganizationMembership withOrganization(OrganizationMembershipOrganization organization) {
        Utils.checkNotNull(organization, "organization");
        this.organization = organization;
        return this;
    }

    public OrganizationMembership withPublicUserData(OrganizationMembershipPublicUserData publicUserData) {
        Utils.checkNotNull(publicUserData, "publicUserData");
        this.publicUserData = Optional.ofNullable(publicUserData);
        return this;
    }

    public OrganizationMembership withPublicUserData(Optional<? extends OrganizationMembershipPublicUserData> publicUserData) {
        Utils.checkNotNull(publicUserData, "publicUserData");
        this.publicUserData = publicUserData;
        return this;
    }

    public OrganizationMembership withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public OrganizationMembership withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationMembership other = (OrganizationMembership)o;
        return Objects.deepEquals(this.id, other.id) && Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.role, other.role) && Objects.deepEquals(this.roleName, other.roleName) && Objects.deepEquals(this.permissions, other.permissions) && Objects.deepEquals(this.publicMetadata, other.publicMetadata) && Objects.deepEquals(this.privateMetadata, other.privateMetadata) && Objects.deepEquals(this.organization, other.organization) && Objects.deepEquals(this.publicUserData, other.publicUserData) && Objects.deepEquals(this.createdAt, other.createdAt) && Objects.deepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.object, this.role, this.roleName, this.permissions, this.publicMetadata, this.privateMetadata, this.organization, this.publicUserData, this.createdAt, this.updatedAt});
    }

    public String toString() {
        return Utils.toString(OrganizationMembership.class, new Object[]{"id", this.id, "object", this.object, "role", this.role, "roleName", this.roleName, "permissions", this.permissions, "publicMetadata", this.publicMetadata, "privateMetadata", this.privateMetadata, "organization", this.organization, "publicUserData", this.publicUserData, "createdAt", this.createdAt, "updatedAt", this.updatedAt});
    }

    public static final class Builder {
        private String id;
        private OrganizationMembershipObject object;
        private String role;
        private Optional<String> roleName = Optional.empty();
        private List<String> permissions;
        private Map<String, Object> publicMetadata;
        private Optional<? extends Map<String, Object>> privateMetadata = Optional.empty();
        private OrganizationMembershipOrganization organization;
        private Optional<? extends OrganizationMembershipPublicUserData> publicUserData = Optional.empty();
        private Long createdAt;
        private Long updatedAt;

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder object(OrganizationMembershipObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder role(String role) {
            Utils.checkNotNull(role, "role");
            this.role = role;
            return this;
        }

        public Builder roleName(String roleName) {
            Utils.checkNotNull(roleName, "roleName");
            this.roleName = Optional.ofNullable(roleName);
            return this;
        }

        public Builder roleName(Optional<String> roleName) {
            Utils.checkNotNull(roleName, "roleName");
            this.roleName = roleName;
            return this;
        }

        public Builder permissions(List<String> permissions) {
            Utils.checkNotNull(permissions, "permissions");
            this.permissions = permissions;
            return this;
        }

        public Builder publicMetadata(Map<String, Object> publicMetadata) {
            Utils.checkNotNull(publicMetadata, "publicMetadata");
            this.publicMetadata = publicMetadata;
            return this;
        }

        public Builder privateMetadata(Map<String, Object> privateMetadata) {
            Utils.checkNotNull(privateMetadata, "privateMetadata");
            this.privateMetadata = Optional.ofNullable(privateMetadata);
            return this;
        }

        public Builder privateMetadata(Optional<? extends Map<String, Object>> privateMetadata) {
            Utils.checkNotNull(privateMetadata, "privateMetadata");
            this.privateMetadata = privateMetadata;
            return this;
        }

        public Builder organization(OrganizationMembershipOrganization organization) {
            Utils.checkNotNull(organization, "organization");
            this.organization = organization;
            return this;
        }

        public Builder publicUserData(OrganizationMembershipPublicUserData publicUserData) {
            Utils.checkNotNull(publicUserData, "publicUserData");
            this.publicUserData = Optional.ofNullable(publicUserData);
            return this;
        }

        public Builder publicUserData(Optional<? extends OrganizationMembershipPublicUserData> publicUserData) {
            Utils.checkNotNull(publicUserData, "publicUserData");
            this.publicUserData = publicUserData;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public OrganizationMembership build() {
            return new OrganizationMembership(this.id, this.object, this.role, this.roleName, this.permissions, this.publicMetadata, this.privateMetadata, this.organization, this.publicUserData, this.createdAt, this.updatedAt);
        }
    }
}

