/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class OrganizationMembershipPublicUserData {
    @JsonProperty(value="user_id")
    private String userId;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="first_name")
    private Optional<String> firstName;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="last_name")
    private Optional<String> lastName;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="profile_image_url")
    @Deprecated
    private Optional<String> profileImageUrl;
    @JsonProperty(value="image_url")
    private String imageUrl;
    @JsonProperty(value="has_image")
    private boolean hasImage;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="identifier")
    private JsonNullable<String> identifier;

    @JsonCreator
    public OrganizationMembershipPublicUserData(@JsonProperty(value="user_id") String userId, @JsonProperty(value="first_name") Optional<String> firstName, @JsonProperty(value="last_name") Optional<String> lastName, @JsonProperty(value="profile_image_url") Optional<String> profileImageUrl, @JsonProperty(value="image_url") String imageUrl, @JsonProperty(value="has_image") boolean hasImage, @JsonProperty(value="identifier") JsonNullable<String> identifier) {
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(firstName, "firstName");
        Utils.checkNotNull(lastName, "lastName");
        Utils.checkNotNull(profileImageUrl, "profileImageUrl");
        Utils.checkNotNull(imageUrl, "imageUrl");
        Utils.checkNotNull(hasImage, "hasImage");
        Utils.checkNotNull(identifier, "identifier");
        this.userId = userId;
        this.firstName = firstName;
        this.lastName = lastName;
        this.profileImageUrl = profileImageUrl;
        this.imageUrl = imageUrl;
        this.hasImage = hasImage;
        this.identifier = identifier;
    }

    public OrganizationMembershipPublicUserData(String userId, String imageUrl, boolean hasImage) {
        this(userId, Optional.empty(), Optional.empty(), Optional.empty(), imageUrl, hasImage, (JsonNullable<String>)JsonNullable.undefined());
    }

    @JsonIgnore
    public String userId() {
        return this.userId;
    }

    @JsonIgnore
    public Optional<String> firstName() {
        return this.firstName;
    }

    @JsonIgnore
    public Optional<String> lastName() {
        return this.lastName;
    }

    @Deprecated
    @JsonIgnore
    public Optional<String> profileImageUrl() {
        return this.profileImageUrl;
    }

    @JsonIgnore
    public String imageUrl() {
        return this.imageUrl;
    }

    @JsonIgnore
    public boolean hasImage() {
        return this.hasImage;
    }

    @JsonIgnore
    public JsonNullable<String> identifier() {
        return this.identifier;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public OrganizationMembershipPublicUserData withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public OrganizationMembershipPublicUserData withFirstName(String firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = Optional.ofNullable(firstName);
        return this;
    }

    public OrganizationMembershipPublicUserData withFirstName(Optional<String> firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = firstName;
        return this;
    }

    public OrganizationMembershipPublicUserData withLastName(String lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = Optional.ofNullable(lastName);
        return this;
    }

    public OrganizationMembershipPublicUserData withLastName(Optional<String> lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = lastName;
        return this;
    }

    @Deprecated
    public OrganizationMembershipPublicUserData withProfileImageUrl(String profileImageUrl) {
        Utils.checkNotNull(profileImageUrl, "profileImageUrl");
        this.profileImageUrl = Optional.ofNullable(profileImageUrl);
        return this;
    }

    @Deprecated
    public OrganizationMembershipPublicUserData withProfileImageUrl(Optional<String> profileImageUrl) {
        Utils.checkNotNull(profileImageUrl, "profileImageUrl");
        this.profileImageUrl = profileImageUrl;
        return this;
    }

    public OrganizationMembershipPublicUserData withImageUrl(String imageUrl) {
        Utils.checkNotNull(imageUrl, "imageUrl");
        this.imageUrl = imageUrl;
        return this;
    }

    public OrganizationMembershipPublicUserData withHasImage(boolean hasImage) {
        Utils.checkNotNull(hasImage, "hasImage");
        this.hasImage = hasImage;
        return this;
    }

    public OrganizationMembershipPublicUserData withIdentifier(String identifier) {
        Utils.checkNotNull(identifier, "identifier");
        this.identifier = JsonNullable.of((Object)identifier);
        return this;
    }

    public OrganizationMembershipPublicUserData withIdentifier(JsonNullable<String> identifier) {
        Utils.checkNotNull(identifier, "identifier");
        this.identifier = identifier;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationMembershipPublicUserData other = (OrganizationMembershipPublicUserData)o;
        return Objects.deepEquals(this.userId, other.userId) && Objects.deepEquals(this.firstName, other.firstName) && Objects.deepEquals(this.lastName, other.lastName) && Objects.deepEquals(this.profileImageUrl, other.profileImageUrl) && Objects.deepEquals(this.imageUrl, other.imageUrl) && Objects.deepEquals(this.hasImage, other.hasImage) && Objects.deepEquals(this.identifier, other.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.firstName, this.lastName, this.profileImageUrl, this.imageUrl, this.hasImage, this.identifier);
    }

    public String toString() {
        return Utils.toString(OrganizationMembershipPublicUserData.class, "userId", this.userId, "firstName", this.firstName, "lastName", this.lastName, "profileImageUrl", this.profileImageUrl, "imageUrl", this.imageUrl, "hasImage", this.hasImage, "identifier", this.identifier);
    }

    public static final class Builder {
        private String userId;
        private Optional<String> firstName = Optional.empty();
        private Optional<String> lastName = Optional.empty();
        @Deprecated
        private Optional<String> profileImageUrl = Optional.empty();
        private String imageUrl;
        private Boolean hasImage;
        private JsonNullable<String> identifier = JsonNullable.undefined();

        private Builder() {
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder firstName(String firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = Optional.ofNullable(firstName);
            return this;
        }

        public Builder firstName(Optional<String> firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = Optional.ofNullable(lastName);
            return this;
        }

        public Builder lastName(Optional<String> lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = lastName;
            return this;
        }

        @Deprecated
        public Builder profileImageUrl(String profileImageUrl) {
            Utils.checkNotNull(profileImageUrl, "profileImageUrl");
            this.profileImageUrl = Optional.ofNullable(profileImageUrl);
            return this;
        }

        @Deprecated
        public Builder profileImageUrl(Optional<String> profileImageUrl) {
            Utils.checkNotNull(profileImageUrl, "profileImageUrl");
            this.profileImageUrl = profileImageUrl;
            return this;
        }

        public Builder imageUrl(String imageUrl) {
            Utils.checkNotNull(imageUrl, "imageUrl");
            this.imageUrl = imageUrl;
            return this;
        }

        public Builder hasImage(boolean hasImage) {
            Utils.checkNotNull(hasImage, "hasImage");
            this.hasImage = hasImage;
            return this;
        }

        public Builder identifier(String identifier) {
            Utils.checkNotNull(identifier, "identifier");
            this.identifier = JsonNullable.of((Object)identifier);
            return this;
        }

        public Builder identifier(JsonNullable<String> identifier) {
            Utils.checkNotNull(identifier, "identifier");
            this.identifier = identifier;
            return this;
        }

        public OrganizationMembershipPublicUserData build() {
            return new OrganizationMembershipPublicUserData(this.userId, this.firstName, this.lastName, this.profileImageUrl, this.imageUrl, this.hasImage, this.identifier);
        }
    }
}

