/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.DomainsEnrollmentModes;
import com.clerk.backend_api.models.components.OrganizationSettingsObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class OrganizationSettings {
    @JsonProperty(value="object")
    private OrganizationSettingsObject object;
    @JsonProperty(value="enabled")
    private boolean enabled;
    @JsonProperty(value="max_allowed_memberships")
    private long maxAllowedMemberships;
    @JsonProperty(value="max_allowed_roles")
    private long maxAllowedRoles;
    @JsonProperty(value="max_allowed_permissions")
    private long maxAllowedPermissions;
    @JsonProperty(value="creator_role")
    private String creatorRole;
    @JsonProperty(value="admin_delete_enabled")
    private boolean adminDeleteEnabled;
    @JsonProperty(value="domains_enabled")
    private boolean domainsEnabled;
    @JsonProperty(value="domains_enrollment_modes")
    private List<DomainsEnrollmentModes> domainsEnrollmentModes;
    @JsonProperty(value="domains_default_role")
    private String domainsDefaultRole;

    @JsonCreator
    public OrganizationSettings(@JsonProperty(value="object") OrganizationSettingsObject object, @JsonProperty(value="enabled") boolean enabled, @JsonProperty(value="max_allowed_memberships") long maxAllowedMemberships, @JsonProperty(value="max_allowed_roles") long maxAllowedRoles, @JsonProperty(value="max_allowed_permissions") long maxAllowedPermissions, @JsonProperty(value="creator_role") String creatorRole, @JsonProperty(value="admin_delete_enabled") boolean adminDeleteEnabled, @JsonProperty(value="domains_enabled") boolean domainsEnabled, @JsonProperty(value="domains_enrollment_modes") List<DomainsEnrollmentModes> domainsEnrollmentModes, @JsonProperty(value="domains_default_role") String domainsDefaultRole) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(enabled, "enabled");
        Utils.checkNotNull(maxAllowedMemberships, "maxAllowedMemberships");
        Utils.checkNotNull(maxAllowedRoles, "maxAllowedRoles");
        Utils.checkNotNull(maxAllowedPermissions, "maxAllowedPermissions");
        Utils.checkNotNull(creatorRole, "creatorRole");
        Utils.checkNotNull(adminDeleteEnabled, "adminDeleteEnabled");
        Utils.checkNotNull(domainsEnabled, "domainsEnabled");
        Utils.checkNotNull(domainsEnrollmentModes, "domainsEnrollmentModes");
        Utils.checkNotNull(domainsDefaultRole, "domainsDefaultRole");
        this.object = object;
        this.enabled = enabled;
        this.maxAllowedMemberships = maxAllowedMemberships;
        this.maxAllowedRoles = maxAllowedRoles;
        this.maxAllowedPermissions = maxAllowedPermissions;
        this.creatorRole = creatorRole;
        this.adminDeleteEnabled = adminDeleteEnabled;
        this.domainsEnabled = domainsEnabled;
        this.domainsEnrollmentModes = domainsEnrollmentModes;
        this.domainsDefaultRole = domainsDefaultRole;
    }

    @JsonIgnore
    public OrganizationSettingsObject object() {
        return this.object;
    }

    @JsonIgnore
    public boolean enabled() {
        return this.enabled;
    }

    @JsonIgnore
    public long maxAllowedMemberships() {
        return this.maxAllowedMemberships;
    }

    @JsonIgnore
    public long maxAllowedRoles() {
        return this.maxAllowedRoles;
    }

    @JsonIgnore
    public long maxAllowedPermissions() {
        return this.maxAllowedPermissions;
    }

    @JsonIgnore
    public String creatorRole() {
        return this.creatorRole;
    }

    @JsonIgnore
    public boolean adminDeleteEnabled() {
        return this.adminDeleteEnabled;
    }

    @JsonIgnore
    public boolean domainsEnabled() {
        return this.domainsEnabled;
    }

    @JsonIgnore
    public List<DomainsEnrollmentModes> domainsEnrollmentModes() {
        return this.domainsEnrollmentModes;
    }

    @JsonIgnore
    public String domainsDefaultRole() {
        return this.domainsDefaultRole;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public OrganizationSettings withObject(OrganizationSettingsObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public OrganizationSettings withEnabled(boolean enabled) {
        Utils.checkNotNull(enabled, "enabled");
        this.enabled = enabled;
        return this;
    }

    public OrganizationSettings withMaxAllowedMemberships(long maxAllowedMemberships) {
        Utils.checkNotNull(maxAllowedMemberships, "maxAllowedMemberships");
        this.maxAllowedMemberships = maxAllowedMemberships;
        return this;
    }

    public OrganizationSettings withMaxAllowedRoles(long maxAllowedRoles) {
        Utils.checkNotNull(maxAllowedRoles, "maxAllowedRoles");
        this.maxAllowedRoles = maxAllowedRoles;
        return this;
    }

    public OrganizationSettings withMaxAllowedPermissions(long maxAllowedPermissions) {
        Utils.checkNotNull(maxAllowedPermissions, "maxAllowedPermissions");
        this.maxAllowedPermissions = maxAllowedPermissions;
        return this;
    }

    public OrganizationSettings withCreatorRole(String creatorRole) {
        Utils.checkNotNull(creatorRole, "creatorRole");
        this.creatorRole = creatorRole;
        return this;
    }

    public OrganizationSettings withAdminDeleteEnabled(boolean adminDeleteEnabled) {
        Utils.checkNotNull(adminDeleteEnabled, "adminDeleteEnabled");
        this.adminDeleteEnabled = adminDeleteEnabled;
        return this;
    }

    public OrganizationSettings withDomainsEnabled(boolean domainsEnabled) {
        Utils.checkNotNull(domainsEnabled, "domainsEnabled");
        this.domainsEnabled = domainsEnabled;
        return this;
    }

    public OrganizationSettings withDomainsEnrollmentModes(List<DomainsEnrollmentModes> domainsEnrollmentModes) {
        Utils.checkNotNull(domainsEnrollmentModes, "domainsEnrollmentModes");
        this.domainsEnrollmentModes = domainsEnrollmentModes;
        return this;
    }

    public OrganizationSettings withDomainsDefaultRole(String domainsDefaultRole) {
        Utils.checkNotNull(domainsDefaultRole, "domainsDefaultRole");
        this.domainsDefaultRole = domainsDefaultRole;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationSettings other = (OrganizationSettings)o;
        return Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.enabled, other.enabled) && Objects.deepEquals(this.maxAllowedMemberships, other.maxAllowedMemberships) && Objects.deepEquals(this.maxAllowedRoles, other.maxAllowedRoles) && Objects.deepEquals(this.maxAllowedPermissions, other.maxAllowedPermissions) && Objects.deepEquals(this.creatorRole, other.creatorRole) && Objects.deepEquals(this.adminDeleteEnabled, other.adminDeleteEnabled) && Objects.deepEquals(this.domainsEnabled, other.domainsEnabled) && Objects.deepEquals(this.domainsEnrollmentModes, other.domainsEnrollmentModes) && Objects.deepEquals(this.domainsDefaultRole, other.domainsDefaultRole);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.object, this.enabled, this.maxAllowedMemberships, this.maxAllowedRoles, this.maxAllowedPermissions, this.creatorRole, this.adminDeleteEnabled, this.domainsEnabled, this.domainsEnrollmentModes, this.domainsDefaultRole});
    }

    public String toString() {
        return Utils.toString(OrganizationSettings.class, new Object[]{"object", this.object, "enabled", this.enabled, "maxAllowedMemberships", this.maxAllowedMemberships, "maxAllowedRoles", this.maxAllowedRoles, "maxAllowedPermissions", this.maxAllowedPermissions, "creatorRole", this.creatorRole, "adminDeleteEnabled", this.adminDeleteEnabled, "domainsEnabled", this.domainsEnabled, "domainsEnrollmentModes", this.domainsEnrollmentModes, "domainsDefaultRole", this.domainsDefaultRole});
    }

    public static final class Builder {
        private OrganizationSettingsObject object;
        private Boolean enabled;
        private Long maxAllowedMemberships;
        private Long maxAllowedRoles;
        private Long maxAllowedPermissions;
        private String creatorRole;
        private Boolean adminDeleteEnabled;
        private Boolean domainsEnabled;
        private List<DomainsEnrollmentModes> domainsEnrollmentModes;
        private String domainsDefaultRole;

        private Builder() {
        }

        public Builder object(OrganizationSettingsObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder enabled(boolean enabled) {
            Utils.checkNotNull(enabled, "enabled");
            this.enabled = enabled;
            return this;
        }

        public Builder maxAllowedMemberships(long maxAllowedMemberships) {
            Utils.checkNotNull(maxAllowedMemberships, "maxAllowedMemberships");
            this.maxAllowedMemberships = maxAllowedMemberships;
            return this;
        }

        public Builder maxAllowedRoles(long maxAllowedRoles) {
            Utils.checkNotNull(maxAllowedRoles, "maxAllowedRoles");
            this.maxAllowedRoles = maxAllowedRoles;
            return this;
        }

        public Builder maxAllowedPermissions(long maxAllowedPermissions) {
            Utils.checkNotNull(maxAllowedPermissions, "maxAllowedPermissions");
            this.maxAllowedPermissions = maxAllowedPermissions;
            return this;
        }

        public Builder creatorRole(String creatorRole) {
            Utils.checkNotNull(creatorRole, "creatorRole");
            this.creatorRole = creatorRole;
            return this;
        }

        public Builder adminDeleteEnabled(boolean adminDeleteEnabled) {
            Utils.checkNotNull(adminDeleteEnabled, "adminDeleteEnabled");
            this.adminDeleteEnabled = adminDeleteEnabled;
            return this;
        }

        public Builder domainsEnabled(boolean domainsEnabled) {
            Utils.checkNotNull(domainsEnabled, "domainsEnabled");
            this.domainsEnabled = domainsEnabled;
            return this;
        }

        public Builder domainsEnrollmentModes(List<DomainsEnrollmentModes> domainsEnrollmentModes) {
            Utils.checkNotNull(domainsEnrollmentModes, "domainsEnrollmentModes");
            this.domainsEnrollmentModes = domainsEnrollmentModes;
            return this;
        }

        public Builder domainsDefaultRole(String domainsDefaultRole) {
            Utils.checkNotNull(domainsDefaultRole, "domainsDefaultRole");
            this.domainsDefaultRole = domainsDefaultRole;
            return this;
        }

        public OrganizationSettings build() {
            return new OrganizationSettings(this.object, this.enabled, this.maxAllowedMemberships, this.maxAllowedRoles, this.maxAllowedPermissions, this.creatorRole, this.adminDeleteEnabled, this.domainsEnabled, this.domainsEnrollmentModes, this.domainsDefaultRole);
        }
    }
}

