/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.OrganizationWithLogoObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class OrganizationWithLogo {
    @JsonProperty(value="object")
    private OrganizationWithLogoObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="slug")
    private String slug;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="members_count")
    private Optional<Long> membersCount;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="missing_member_with_elevated_permissions")
    private Optional<Boolean> missingMemberWithElevatedPermissions;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="pending_invitations_count")
    private Optional<Long> pendingInvitationsCount;
    @JsonProperty(value="max_allowed_memberships")
    private long maxAllowedMemberships;
    @JsonProperty(value="admin_delete_enabled")
    private boolean adminDeleteEnabled;
    @JsonProperty(value="public_metadata")
    private Map<String, Object> publicMetadata;
    @JsonProperty(value="private_metadata")
    private Map<String, Object> privateMetadata;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="created_by")
    private Optional<String> createdBy;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="logo_url")
    @Deprecated
    private Optional<String> logoUrl;
    @JsonProperty(value="image_url")
    private String imageUrl;
    @JsonProperty(value="has_image")
    private boolean hasImage;

    @JsonCreator
    public OrganizationWithLogo(@JsonProperty(value="object") OrganizationWithLogoObject object, @JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="slug") String slug, @JsonProperty(value="members_count") Optional<Long> membersCount, @JsonProperty(value="missing_member_with_elevated_permissions") Optional<Boolean> missingMemberWithElevatedPermissions, @JsonProperty(value="pending_invitations_count") Optional<Long> pendingInvitationsCount, @JsonProperty(value="max_allowed_memberships") long maxAllowedMemberships, @JsonProperty(value="admin_delete_enabled") boolean adminDeleteEnabled, @JsonProperty(value="public_metadata") Map<String, Object> publicMetadata, @JsonProperty(value="private_metadata") Map<String, Object> privateMetadata, @JsonProperty(value="created_by") Optional<String> createdBy, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt, @JsonProperty(value="logo_url") Optional<String> logoUrl, @JsonProperty(value="image_url") String imageUrl, @JsonProperty(value="has_image") boolean hasImage) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(slug, "slug");
        Utils.checkNotNull(membersCount, "membersCount");
        Utils.checkNotNull(missingMemberWithElevatedPermissions, "missingMemberWithElevatedPermissions");
        Utils.checkNotNull(pendingInvitationsCount, "pendingInvitationsCount");
        Utils.checkNotNull(maxAllowedMemberships, "maxAllowedMemberships");
        Utils.checkNotNull(adminDeleteEnabled, "adminDeleteEnabled");
        publicMetadata = Utils.emptyMapIfNull(publicMetadata);
        privateMetadata = Utils.emptyMapIfNull(privateMetadata);
        Utils.checkNotNull(createdBy, "createdBy");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(logoUrl, "logoUrl");
        Utils.checkNotNull(imageUrl, "imageUrl");
        Utils.checkNotNull(hasImage, "hasImage");
        this.object = object;
        this.id = id;
        this.name = name;
        this.slug = slug;
        this.membersCount = membersCount;
        this.missingMemberWithElevatedPermissions = missingMemberWithElevatedPermissions;
        this.pendingInvitationsCount = pendingInvitationsCount;
        this.maxAllowedMemberships = maxAllowedMemberships;
        this.adminDeleteEnabled = adminDeleteEnabled;
        this.publicMetadata = publicMetadata;
        this.privateMetadata = privateMetadata;
        this.createdBy = createdBy;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.logoUrl = logoUrl;
        this.imageUrl = imageUrl;
        this.hasImage = hasImage;
    }

    public OrganizationWithLogo(OrganizationWithLogoObject object, String id, String name, String slug, long maxAllowedMemberships, boolean adminDeleteEnabled, Map<String, Object> publicMetadata, Map<String, Object> privateMetadata, long createdAt, long updatedAt, String imageUrl, boolean hasImage) {
        this(object, id, name, slug, Optional.empty(), Optional.empty(), Optional.empty(), maxAllowedMemberships, adminDeleteEnabled, publicMetadata, privateMetadata, Optional.empty(), createdAt, updatedAt, Optional.empty(), imageUrl, hasImage);
    }

    @JsonIgnore
    public OrganizationWithLogoObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public String slug() {
        return this.slug;
    }

    @JsonIgnore
    public Optional<Long> membersCount() {
        return this.membersCount;
    }

    @JsonIgnore
    public Optional<Boolean> missingMemberWithElevatedPermissions() {
        return this.missingMemberWithElevatedPermissions;
    }

    @JsonIgnore
    public Optional<Long> pendingInvitationsCount() {
        return this.pendingInvitationsCount;
    }

    @JsonIgnore
    public long maxAllowedMemberships() {
        return this.maxAllowedMemberships;
    }

    @JsonIgnore
    public boolean adminDeleteEnabled() {
        return this.adminDeleteEnabled;
    }

    @JsonIgnore
    public Map<String, Object> publicMetadata() {
        return this.publicMetadata;
    }

    @JsonIgnore
    public Map<String, Object> privateMetadata() {
        return this.privateMetadata;
    }

    @JsonIgnore
    public Optional<String> createdBy() {
        return this.createdBy;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    @Deprecated
    @JsonIgnore
    public Optional<String> logoUrl() {
        return this.logoUrl;
    }

    @JsonIgnore
    public String imageUrl() {
        return this.imageUrl;
    }

    @JsonIgnore
    public boolean hasImage() {
        return this.hasImage;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public OrganizationWithLogo withObject(OrganizationWithLogoObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public OrganizationWithLogo withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public OrganizationWithLogo withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public OrganizationWithLogo withSlug(String slug) {
        Utils.checkNotNull(slug, "slug");
        this.slug = slug;
        return this;
    }

    public OrganizationWithLogo withMembersCount(long membersCount) {
        Utils.checkNotNull(membersCount, "membersCount");
        this.membersCount = Optional.ofNullable(membersCount);
        return this;
    }

    public OrganizationWithLogo withMembersCount(Optional<Long> membersCount) {
        Utils.checkNotNull(membersCount, "membersCount");
        this.membersCount = membersCount;
        return this;
    }

    public OrganizationWithLogo withMissingMemberWithElevatedPermissions(boolean missingMemberWithElevatedPermissions) {
        Utils.checkNotNull(missingMemberWithElevatedPermissions, "missingMemberWithElevatedPermissions");
        this.missingMemberWithElevatedPermissions = Optional.ofNullable(missingMemberWithElevatedPermissions);
        return this;
    }

    public OrganizationWithLogo withMissingMemberWithElevatedPermissions(Optional<Boolean> missingMemberWithElevatedPermissions) {
        Utils.checkNotNull(missingMemberWithElevatedPermissions, "missingMemberWithElevatedPermissions");
        this.missingMemberWithElevatedPermissions = missingMemberWithElevatedPermissions;
        return this;
    }

    public OrganizationWithLogo withPendingInvitationsCount(long pendingInvitationsCount) {
        Utils.checkNotNull(pendingInvitationsCount, "pendingInvitationsCount");
        this.pendingInvitationsCount = Optional.ofNullable(pendingInvitationsCount);
        return this;
    }

    public OrganizationWithLogo withPendingInvitationsCount(Optional<Long> pendingInvitationsCount) {
        Utils.checkNotNull(pendingInvitationsCount, "pendingInvitationsCount");
        this.pendingInvitationsCount = pendingInvitationsCount;
        return this;
    }

    public OrganizationWithLogo withMaxAllowedMemberships(long maxAllowedMemberships) {
        Utils.checkNotNull(maxAllowedMemberships, "maxAllowedMemberships");
        this.maxAllowedMemberships = maxAllowedMemberships;
        return this;
    }

    public OrganizationWithLogo withAdminDeleteEnabled(boolean adminDeleteEnabled) {
        Utils.checkNotNull(adminDeleteEnabled, "adminDeleteEnabled");
        this.adminDeleteEnabled = adminDeleteEnabled;
        return this;
    }

    public OrganizationWithLogo withPublicMetadata(Map<String, Object> publicMetadata) {
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        this.publicMetadata = publicMetadata;
        return this;
    }

    public OrganizationWithLogo withPrivateMetadata(Map<String, Object> privateMetadata) {
        Utils.checkNotNull(privateMetadata, "privateMetadata");
        this.privateMetadata = privateMetadata;
        return this;
    }

    public OrganizationWithLogo withCreatedBy(String createdBy) {
        Utils.checkNotNull(createdBy, "createdBy");
        this.createdBy = Optional.ofNullable(createdBy);
        return this;
    }

    public OrganizationWithLogo withCreatedBy(Optional<String> createdBy) {
        Utils.checkNotNull(createdBy, "createdBy");
        this.createdBy = createdBy;
        return this;
    }

    public OrganizationWithLogo withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public OrganizationWithLogo withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    @Deprecated
    public OrganizationWithLogo withLogoUrl(String logoUrl) {
        Utils.checkNotNull(logoUrl, "logoUrl");
        this.logoUrl = Optional.ofNullable(logoUrl);
        return this;
    }

    @Deprecated
    public OrganizationWithLogo withLogoUrl(Optional<String> logoUrl) {
        Utils.checkNotNull(logoUrl, "logoUrl");
        this.logoUrl = logoUrl;
        return this;
    }

    public OrganizationWithLogo withImageUrl(String imageUrl) {
        Utils.checkNotNull(imageUrl, "imageUrl");
        this.imageUrl = imageUrl;
        return this;
    }

    public OrganizationWithLogo withHasImage(boolean hasImage) {
        Utils.checkNotNull(hasImage, "hasImage");
        this.hasImage = hasImage;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationWithLogo other = (OrganizationWithLogo)o;
        return Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.name, other.name) && Objects.deepEquals(this.slug, other.slug) && Objects.deepEquals(this.membersCount, other.membersCount) && Objects.deepEquals(this.missingMemberWithElevatedPermissions, other.missingMemberWithElevatedPermissions) && Objects.deepEquals(this.pendingInvitationsCount, other.pendingInvitationsCount) && Objects.deepEquals(this.maxAllowedMemberships, other.maxAllowedMemberships) && Objects.deepEquals(this.adminDeleteEnabled, other.adminDeleteEnabled) && Objects.deepEquals(this.publicMetadata, other.publicMetadata) && Objects.deepEquals(this.privateMetadata, other.privateMetadata) && Objects.deepEquals(this.createdBy, other.createdBy) && Objects.deepEquals(this.createdAt, other.createdAt) && Objects.deepEquals(this.updatedAt, other.updatedAt) && Objects.deepEquals(this.logoUrl, other.logoUrl) && Objects.deepEquals(this.imageUrl, other.imageUrl) && Objects.deepEquals(this.hasImage, other.hasImage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.object, this.id, this.name, this.slug, this.membersCount, this.missingMemberWithElevatedPermissions, this.pendingInvitationsCount, this.maxAllowedMemberships, this.adminDeleteEnabled, this.publicMetadata, this.privateMetadata, this.createdBy, this.createdAt, this.updatedAt, this.logoUrl, this.imageUrl, this.hasImage});
    }

    public String toString() {
        return Utils.toString(OrganizationWithLogo.class, new Object[]{"object", this.object, "id", this.id, "name", this.name, "slug", this.slug, "membersCount", this.membersCount, "missingMemberWithElevatedPermissions", this.missingMemberWithElevatedPermissions, "pendingInvitationsCount", this.pendingInvitationsCount, "maxAllowedMemberships", this.maxAllowedMemberships, "adminDeleteEnabled", this.adminDeleteEnabled, "publicMetadata", this.publicMetadata, "privateMetadata", this.privateMetadata, "createdBy", this.createdBy, "createdAt", this.createdAt, "updatedAt", this.updatedAt, "logoUrl", this.logoUrl, "imageUrl", this.imageUrl, "hasImage", this.hasImage});
    }

    public static final class Builder {
        private OrganizationWithLogoObject object;
        private String id;
        private String name;
        private String slug;
        private Optional<Long> membersCount = Optional.empty();
        private Optional<Boolean> missingMemberWithElevatedPermissions = Optional.empty();
        private Optional<Long> pendingInvitationsCount = Optional.empty();
        private Long maxAllowedMemberships;
        private Boolean adminDeleteEnabled;
        private Map<String, Object> publicMetadata;
        private Map<String, Object> privateMetadata;
        private Optional<String> createdBy = Optional.empty();
        private Long createdAt;
        private Long updatedAt;
        @Deprecated
        private Optional<String> logoUrl = Optional.empty();
        private String imageUrl;
        private Boolean hasImage;

        private Builder() {
        }

        public Builder object(OrganizationWithLogoObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder slug(String slug) {
            Utils.checkNotNull(slug, "slug");
            this.slug = slug;
            return this;
        }

        public Builder membersCount(long membersCount) {
            Utils.checkNotNull(membersCount, "membersCount");
            this.membersCount = Optional.ofNullable(membersCount);
            return this;
        }

        public Builder membersCount(Optional<Long> membersCount) {
            Utils.checkNotNull(membersCount, "membersCount");
            this.membersCount = membersCount;
            return this;
        }

        public Builder missingMemberWithElevatedPermissions(boolean missingMemberWithElevatedPermissions) {
            Utils.checkNotNull(missingMemberWithElevatedPermissions, "missingMemberWithElevatedPermissions");
            this.missingMemberWithElevatedPermissions = Optional.ofNullable(missingMemberWithElevatedPermissions);
            return this;
        }

        public Builder missingMemberWithElevatedPermissions(Optional<Boolean> missingMemberWithElevatedPermissions) {
            Utils.checkNotNull(missingMemberWithElevatedPermissions, "missingMemberWithElevatedPermissions");
            this.missingMemberWithElevatedPermissions = missingMemberWithElevatedPermissions;
            return this;
        }

        public Builder pendingInvitationsCount(long pendingInvitationsCount) {
            Utils.checkNotNull(pendingInvitationsCount, "pendingInvitationsCount");
            this.pendingInvitationsCount = Optional.ofNullable(pendingInvitationsCount);
            return this;
        }

        public Builder pendingInvitationsCount(Optional<Long> pendingInvitationsCount) {
            Utils.checkNotNull(pendingInvitationsCount, "pendingInvitationsCount");
            this.pendingInvitationsCount = pendingInvitationsCount;
            return this;
        }

        public Builder maxAllowedMemberships(long maxAllowedMemberships) {
            Utils.checkNotNull(maxAllowedMemberships, "maxAllowedMemberships");
            this.maxAllowedMemberships = maxAllowedMemberships;
            return this;
        }

        public Builder adminDeleteEnabled(boolean adminDeleteEnabled) {
            Utils.checkNotNull(adminDeleteEnabled, "adminDeleteEnabled");
            this.adminDeleteEnabled = adminDeleteEnabled;
            return this;
        }

        public Builder publicMetadata(Map<String, Object> publicMetadata) {
            Utils.checkNotNull(publicMetadata, "publicMetadata");
            this.publicMetadata = publicMetadata;
            return this;
        }

        public Builder privateMetadata(Map<String, Object> privateMetadata) {
            Utils.checkNotNull(privateMetadata, "privateMetadata");
            this.privateMetadata = privateMetadata;
            return this;
        }

        public Builder createdBy(String createdBy) {
            Utils.checkNotNull(createdBy, "createdBy");
            this.createdBy = Optional.ofNullable(createdBy);
            return this;
        }

        public Builder createdBy(Optional<String> createdBy) {
            Utils.checkNotNull(createdBy, "createdBy");
            this.createdBy = createdBy;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        @Deprecated
        public Builder logoUrl(String logoUrl) {
            Utils.checkNotNull(logoUrl, "logoUrl");
            this.logoUrl = Optional.ofNullable(logoUrl);
            return this;
        }

        @Deprecated
        public Builder logoUrl(Optional<String> logoUrl) {
            Utils.checkNotNull(logoUrl, "logoUrl");
            this.logoUrl = logoUrl;
            return this;
        }

        public Builder imageUrl(String imageUrl) {
            Utils.checkNotNull(imageUrl, "imageUrl");
            this.imageUrl = imageUrl;
            return this;
        }

        public Builder hasImage(boolean hasImage) {
            Utils.checkNotNull(hasImage, "hasImage");
            this.hasImage = hasImage;
            return this;
        }

        public OrganizationWithLogo build() {
            return new OrganizationWithLogo(this.object, this.id, this.name, this.slug, this.membersCount, this.missingMemberWithElevatedPermissions, this.pendingInvitationsCount, this.maxAllowedMemberships, this.adminDeleteEnabled, this.publicMetadata, this.privateMetadata, this.createdBy, this.createdAt, this.updatedAt, this.logoUrl, this.imageUrl, this.hasImage);
        }
    }
}

