/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.Organization;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class Organizations {
    @JsonProperty(value="data")
    private List<Organization> data;
    @JsonProperty(value="total_count")
    private long totalCount;

    @JsonCreator
    public Organizations(@JsonProperty(value="data") List<Organization> data, @JsonProperty(value="total_count") long totalCount) {
        Utils.checkNotNull(data, "data");
        Utils.checkNotNull(totalCount, "totalCount");
        this.data = data;
        this.totalCount = totalCount;
    }

    @JsonIgnore
    public List<Organization> data() {
        return this.data;
    }

    @JsonIgnore
    public long totalCount() {
        return this.totalCount;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Organizations withData(List<Organization> data) {
        Utils.checkNotNull(data, "data");
        this.data = data;
        return this;
    }

    public Organizations withTotalCount(long totalCount) {
        Utils.checkNotNull(totalCount, "totalCount");
        this.totalCount = totalCount;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Organizations other = (Organizations)o;
        return Objects.deepEquals(this.data, other.data) && Objects.deepEquals(this.totalCount, other.totalCount);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.totalCount);
    }

    public String toString() {
        return Utils.toString(Organizations.class, "data", this.data, "totalCount", this.totalCount);
    }

    public static final class Builder {
        private List<Organization> data;
        private Long totalCount;

        private Builder() {
        }

        public Builder data(List<Organization> data) {
            Utils.checkNotNull(data, "data");
            this.data = data;
            return this;
        }

        public Builder totalCount(long totalCount) {
            Utils.checkNotNull(totalCount, "totalCount");
            this.totalCount = totalCount;
            return this;
        }

        public Organizations build() {
            return new Organizations(this.data, this.totalCount);
        }
    }
}

