/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.IdentificationLink;
import com.clerk.backend_api.models.components.PhoneNumberObject;
import com.clerk.backend_api.models.components.PhoneNumberVerification;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class PhoneNumber {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private Optional<String> id;
    @JsonProperty(value="object")
    private PhoneNumberObject object;
    @JsonProperty(value="phone_number")
    private String phoneNumber;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="reserved_for_second_factor")
    private Optional<Boolean> reservedForSecondFactor;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="default_second_factor")
    private Optional<Boolean> defaultSecondFactor;
    @JsonProperty(value="reserved")
    private boolean reserved;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="verification")
    private Optional<? extends PhoneNumberVerification> verification;
    @JsonProperty(value="linked_to")
    private List<IdentificationLink> linkedTo;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="backup_codes")
    private JsonNullable<? extends List<String>> backupCodes;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    @JsonCreator
    public PhoneNumber(@JsonProperty(value="id") Optional<String> id, @JsonProperty(value="object") PhoneNumberObject object, @JsonProperty(value="phone_number") String phoneNumber, @JsonProperty(value="reserved_for_second_factor") Optional<Boolean> reservedForSecondFactor, @JsonProperty(value="default_second_factor") Optional<Boolean> defaultSecondFactor, @JsonProperty(value="reserved") boolean reserved, @JsonProperty(value="verification") Optional<? extends PhoneNumberVerification> verification, @JsonProperty(value="linked_to") List<IdentificationLink> linkedTo, @JsonProperty(value="backup_codes") JsonNullable<? extends List<String>> backupCodes, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        Utils.checkNotNull(reservedForSecondFactor, "reservedForSecondFactor");
        Utils.checkNotNull(defaultSecondFactor, "defaultSecondFactor");
        Utils.checkNotNull(reserved, "reserved");
        Utils.checkNotNull(verification, "verification");
        Utils.checkNotNull(linkedTo, "linkedTo");
        Utils.checkNotNull(backupCodes, "backupCodes");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.object = object;
        this.phoneNumber = phoneNumber;
        this.reservedForSecondFactor = reservedForSecondFactor;
        this.defaultSecondFactor = defaultSecondFactor;
        this.reserved = reserved;
        this.verification = verification;
        this.linkedTo = linkedTo;
        this.backupCodes = backupCodes;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public PhoneNumber(PhoneNumberObject object, String phoneNumber, boolean reserved, List<IdentificationLink> linkedTo, long createdAt, long updatedAt) {
        this(Optional.empty(), object, phoneNumber, Optional.empty(), Optional.empty(), reserved, Optional.empty(), linkedTo, (JsonNullable<? extends List<String>>)JsonNullable.undefined(), createdAt, updatedAt);
    }

    @JsonIgnore
    public Optional<String> id() {
        return this.id;
    }

    @JsonIgnore
    public PhoneNumberObject object() {
        return this.object;
    }

    @JsonIgnore
    public String phoneNumber() {
        return this.phoneNumber;
    }

    @JsonIgnore
    public Optional<Boolean> reservedForSecondFactor() {
        return this.reservedForSecondFactor;
    }

    @JsonIgnore
    public Optional<Boolean> defaultSecondFactor() {
        return this.defaultSecondFactor;
    }

    @JsonIgnore
    public boolean reserved() {
        return this.reserved;
    }

    @JsonIgnore
    public Optional<PhoneNumberVerification> verification() {
        return this.verification;
    }

    @JsonIgnore
    public List<IdentificationLink> linkedTo() {
        return this.linkedTo;
    }

    @JsonIgnore
    public JsonNullable<List<String>> backupCodes() {
        return this.backupCodes;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public PhoneNumber withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = Optional.ofNullable(id);
        return this;
    }

    public PhoneNumber withId(Optional<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public PhoneNumber withObject(PhoneNumberObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public PhoneNumber withPhoneNumber(String phoneNumber) {
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        this.phoneNumber = phoneNumber;
        return this;
    }

    public PhoneNumber withReservedForSecondFactor(boolean reservedForSecondFactor) {
        Utils.checkNotNull(reservedForSecondFactor, "reservedForSecondFactor");
        this.reservedForSecondFactor = Optional.ofNullable(reservedForSecondFactor);
        return this;
    }

    public PhoneNumber withReservedForSecondFactor(Optional<Boolean> reservedForSecondFactor) {
        Utils.checkNotNull(reservedForSecondFactor, "reservedForSecondFactor");
        this.reservedForSecondFactor = reservedForSecondFactor;
        return this;
    }

    public PhoneNumber withDefaultSecondFactor(boolean defaultSecondFactor) {
        Utils.checkNotNull(defaultSecondFactor, "defaultSecondFactor");
        this.defaultSecondFactor = Optional.ofNullable(defaultSecondFactor);
        return this;
    }

    public PhoneNumber withDefaultSecondFactor(Optional<Boolean> defaultSecondFactor) {
        Utils.checkNotNull(defaultSecondFactor, "defaultSecondFactor");
        this.defaultSecondFactor = defaultSecondFactor;
        return this;
    }

    public PhoneNumber withReserved(boolean reserved) {
        Utils.checkNotNull(reserved, "reserved");
        this.reserved = reserved;
        return this;
    }

    public PhoneNumber withVerification(PhoneNumberVerification verification) {
        Utils.checkNotNull(verification, "verification");
        this.verification = Optional.ofNullable(verification);
        return this;
    }

    public PhoneNumber withVerification(Optional<? extends PhoneNumberVerification> verification) {
        Utils.checkNotNull(verification, "verification");
        this.verification = verification;
        return this;
    }

    public PhoneNumber withLinkedTo(List<IdentificationLink> linkedTo) {
        Utils.checkNotNull(linkedTo, "linkedTo");
        this.linkedTo = linkedTo;
        return this;
    }

    public PhoneNumber withBackupCodes(List<String> backupCodes) {
        Utils.checkNotNull(backupCodes, "backupCodes");
        this.backupCodes = JsonNullable.of(backupCodes);
        return this;
    }

    public PhoneNumber withBackupCodes(JsonNullable<? extends List<String>> backupCodes) {
        Utils.checkNotNull(backupCodes, "backupCodes");
        this.backupCodes = backupCodes;
        return this;
    }

    public PhoneNumber withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public PhoneNumber withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneNumber other = (PhoneNumber)o;
        return Objects.deepEquals(this.id, other.id) && Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.phoneNumber, other.phoneNumber) && Objects.deepEquals(this.reservedForSecondFactor, other.reservedForSecondFactor) && Objects.deepEquals(this.defaultSecondFactor, other.defaultSecondFactor) && Objects.deepEquals(this.reserved, other.reserved) && Objects.deepEquals(this.verification, other.verification) && Objects.deepEquals(this.linkedTo, other.linkedTo) && Objects.deepEquals(this.backupCodes, other.backupCodes) && Objects.deepEquals(this.createdAt, other.createdAt) && Objects.deepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.object, this.phoneNumber, this.reservedForSecondFactor, this.defaultSecondFactor, this.reserved, this.verification, this.linkedTo, this.backupCodes, this.createdAt, this.updatedAt});
    }

    public String toString() {
        return Utils.toString(PhoneNumber.class, new Object[]{"id", this.id, "object", this.object, "phoneNumber", this.phoneNumber, "reservedForSecondFactor", this.reservedForSecondFactor, "defaultSecondFactor", this.defaultSecondFactor, "reserved", this.reserved, "verification", this.verification, "linkedTo", this.linkedTo, "backupCodes", this.backupCodes, "createdAt", this.createdAt, "updatedAt", this.updatedAt});
    }

    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private PhoneNumberObject object;
        private String phoneNumber;
        private Optional<Boolean> reservedForSecondFactor = Optional.empty();
        private Optional<Boolean> defaultSecondFactor = Optional.empty();
        private Boolean reserved;
        private Optional<? extends PhoneNumberVerification> verification = Optional.empty();
        private List<IdentificationLink> linkedTo;
        private JsonNullable<? extends List<String>> backupCodes = JsonNullable.undefined();
        private Long createdAt;
        private Long updatedAt;

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = Optional.ofNullable(id);
            return this;
        }

        public Builder id(Optional<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder object(PhoneNumberObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            Utils.checkNotNull(phoneNumber, "phoneNumber");
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder reservedForSecondFactor(boolean reservedForSecondFactor) {
            Utils.checkNotNull(reservedForSecondFactor, "reservedForSecondFactor");
            this.reservedForSecondFactor = Optional.ofNullable(reservedForSecondFactor);
            return this;
        }

        public Builder reservedForSecondFactor(Optional<Boolean> reservedForSecondFactor) {
            Utils.checkNotNull(reservedForSecondFactor, "reservedForSecondFactor");
            this.reservedForSecondFactor = reservedForSecondFactor;
            return this;
        }

        public Builder defaultSecondFactor(boolean defaultSecondFactor) {
            Utils.checkNotNull(defaultSecondFactor, "defaultSecondFactor");
            this.defaultSecondFactor = Optional.ofNullable(defaultSecondFactor);
            return this;
        }

        public Builder defaultSecondFactor(Optional<Boolean> defaultSecondFactor) {
            Utils.checkNotNull(defaultSecondFactor, "defaultSecondFactor");
            this.defaultSecondFactor = defaultSecondFactor;
            return this;
        }

        public Builder reserved(boolean reserved) {
            Utils.checkNotNull(reserved, "reserved");
            this.reserved = reserved;
            return this;
        }

        public Builder verification(PhoneNumberVerification verification) {
            Utils.checkNotNull(verification, "verification");
            this.verification = Optional.ofNullable(verification);
            return this;
        }

        public Builder verification(Optional<? extends PhoneNumberVerification> verification) {
            Utils.checkNotNull(verification, "verification");
            this.verification = verification;
            return this;
        }

        public Builder linkedTo(List<IdentificationLink> linkedTo) {
            Utils.checkNotNull(linkedTo, "linkedTo");
            this.linkedTo = linkedTo;
            return this;
        }

        public Builder backupCodes(List<String> backupCodes) {
            Utils.checkNotNull(backupCodes, "backupCodes");
            this.backupCodes = JsonNullable.of(backupCodes);
            return this;
        }

        public Builder backupCodes(JsonNullable<? extends List<String>> backupCodes) {
            Utils.checkNotNull(backupCodes, "backupCodes");
            this.backupCodes = backupCodes;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public PhoneNumber build() {
            return new PhoneNumber(this.id, this.object, this.phoneNumber, this.reservedForSecondFactor, this.defaultSecondFactor, this.reserved, this.verification, this.linkedTo, this.backupCodes, this.createdAt, this.updatedAt);
        }
    }
}

