/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.Saml;
import com.clerk.backend_api.models.components.VerificationTicket;
import com.clerk.backend_api.utils.OneOfDeserializer;
import com.clerk.backend_api.utils.TypedObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(using=_Deserializer.class)
public class SAMLAccountVerification {
    @JsonValue
    private TypedObject value;

    private SAMLAccountVerification(TypedObject value) {
        this.value = value;
    }

    public static SAMLAccountVerification of(Saml value) {
        Utils.checkNotNull(value, "value");
        return new SAMLAccountVerification(TypedObject.of(value, Utils.JsonShape.DEFAULT, new TypeReference<Saml>(){}));
    }

    public static SAMLAccountVerification of(VerificationTicket value) {
        Utils.checkNotNull(value, "value");
        return new SAMLAccountVerification(TypedObject.of(value, Utils.JsonShape.DEFAULT, new TypeReference<VerificationTicket>(){}));
    }

    public Object value() {
        return this.value.value();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAMLAccountVerification other = (SAMLAccountVerification)o;
        return Objects.deepEquals(this.value.value(), other.value.value());
    }

    public int hashCode() {
        return Objects.hash(this.value.value());
    }

    public String toString() {
        return Utils.toString(SAMLAccountVerification.class, "value", this.value);
    }

    public static final class _Deserializer
    extends OneOfDeserializer<SAMLAccountVerification> {
        public _Deserializer() {
            super(SAMLAccountVerification.class, false, Utils.TypeReferenceWithShape.of(new TypeReference<Saml>(){}, Utils.JsonShape.DEFAULT), Utils.TypeReferenceWithShape.of(new TypeReference<VerificationTicket>(){}, Utils.JsonShape.DEFAULT));
        }
    }
}

