/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class SAMLConnectionSAMLConnection {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="domain")
    private String domain;
    @JsonProperty(value="active")
    private boolean active;
    @JsonProperty(value="provider")
    private String provider;
    @JsonProperty(value="sync_user_attributes")
    private boolean syncUserAttributes;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="allow_subdomains")
    private Optional<Boolean> allowSubdomains;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="allow_idp_initiated")
    private Optional<Boolean> allowIdpInitiated;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="disable_additional_identifications")
    private Optional<Boolean> disableAdditionalIdentifications;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    @JsonCreator
    public SAMLConnectionSAMLConnection(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="domain") String domain, @JsonProperty(value="active") boolean active, @JsonProperty(value="provider") String provider, @JsonProperty(value="sync_user_attributes") boolean syncUserAttributes, @JsonProperty(value="allow_subdomains") Optional<Boolean> allowSubdomains, @JsonProperty(value="allow_idp_initiated") Optional<Boolean> allowIdpInitiated, @JsonProperty(value="disable_additional_identifications") Optional<Boolean> disableAdditionalIdentifications, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(domain, "domain");
        Utils.checkNotNull(active, "active");
        Utils.checkNotNull(provider, "provider");
        Utils.checkNotNull(syncUserAttributes, "syncUserAttributes");
        Utils.checkNotNull(allowSubdomains, "allowSubdomains");
        Utils.checkNotNull(allowIdpInitiated, "allowIdpInitiated");
        Utils.checkNotNull(disableAdditionalIdentifications, "disableAdditionalIdentifications");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.name = name;
        this.domain = domain;
        this.active = active;
        this.provider = provider;
        this.syncUserAttributes = syncUserAttributes;
        this.allowSubdomains = allowSubdomains;
        this.allowIdpInitiated = allowIdpInitiated;
        this.disableAdditionalIdentifications = disableAdditionalIdentifications;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public SAMLConnectionSAMLConnection(String id, String name, String domain, boolean active, String provider, boolean syncUserAttributes, long createdAt, long updatedAt) {
        this(id, name, domain, active, provider, syncUserAttributes, Optional.empty(), Optional.empty(), Optional.empty(), createdAt, updatedAt);
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public String domain() {
        return this.domain;
    }

    @JsonIgnore
    public boolean active() {
        return this.active;
    }

    @JsonIgnore
    public String provider() {
        return this.provider;
    }

    @JsonIgnore
    public boolean syncUserAttributes() {
        return this.syncUserAttributes;
    }

    @JsonIgnore
    public Optional<Boolean> allowSubdomains() {
        return this.allowSubdomains;
    }

    @JsonIgnore
    public Optional<Boolean> allowIdpInitiated() {
        return this.allowIdpInitiated;
    }

    @JsonIgnore
    public Optional<Boolean> disableAdditionalIdentifications() {
        return this.disableAdditionalIdentifications;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public SAMLConnectionSAMLConnection withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public SAMLConnectionSAMLConnection withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public SAMLConnectionSAMLConnection withDomain(String domain) {
        Utils.checkNotNull(domain, "domain");
        this.domain = domain;
        return this;
    }

    public SAMLConnectionSAMLConnection withActive(boolean active) {
        Utils.checkNotNull(active, "active");
        this.active = active;
        return this;
    }

    public SAMLConnectionSAMLConnection withProvider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    public SAMLConnectionSAMLConnection withSyncUserAttributes(boolean syncUserAttributes) {
        Utils.checkNotNull(syncUserAttributes, "syncUserAttributes");
        this.syncUserAttributes = syncUserAttributes;
        return this;
    }

    public SAMLConnectionSAMLConnection withAllowSubdomains(boolean allowSubdomains) {
        Utils.checkNotNull(allowSubdomains, "allowSubdomains");
        this.allowSubdomains = Optional.ofNullable(allowSubdomains);
        return this;
    }

    public SAMLConnectionSAMLConnection withAllowSubdomains(Optional<Boolean> allowSubdomains) {
        Utils.checkNotNull(allowSubdomains, "allowSubdomains");
        this.allowSubdomains = allowSubdomains;
        return this;
    }

    public SAMLConnectionSAMLConnection withAllowIdpInitiated(boolean allowIdpInitiated) {
        Utils.checkNotNull(allowIdpInitiated, "allowIdpInitiated");
        this.allowIdpInitiated = Optional.ofNullable(allowIdpInitiated);
        return this;
    }

    public SAMLConnectionSAMLConnection withAllowIdpInitiated(Optional<Boolean> allowIdpInitiated) {
        Utils.checkNotNull(allowIdpInitiated, "allowIdpInitiated");
        this.allowIdpInitiated = allowIdpInitiated;
        return this;
    }

    public SAMLConnectionSAMLConnection withDisableAdditionalIdentifications(boolean disableAdditionalIdentifications) {
        Utils.checkNotNull(disableAdditionalIdentifications, "disableAdditionalIdentifications");
        this.disableAdditionalIdentifications = Optional.ofNullable(disableAdditionalIdentifications);
        return this;
    }

    public SAMLConnectionSAMLConnection withDisableAdditionalIdentifications(Optional<Boolean> disableAdditionalIdentifications) {
        Utils.checkNotNull(disableAdditionalIdentifications, "disableAdditionalIdentifications");
        this.disableAdditionalIdentifications = disableAdditionalIdentifications;
        return this;
    }

    public SAMLConnectionSAMLConnection withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public SAMLConnectionSAMLConnection withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAMLConnectionSAMLConnection other = (SAMLConnectionSAMLConnection)o;
        return Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.name, other.name) && Objects.deepEquals(this.domain, other.domain) && Objects.deepEquals(this.active, other.active) && Objects.deepEquals(this.provider, other.provider) && Objects.deepEquals(this.syncUserAttributes, other.syncUserAttributes) && Objects.deepEquals(this.allowSubdomains, other.allowSubdomains) && Objects.deepEquals(this.allowIdpInitiated, other.allowIdpInitiated) && Objects.deepEquals(this.disableAdditionalIdentifications, other.disableAdditionalIdentifications) && Objects.deepEquals(this.createdAt, other.createdAt) && Objects.deepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.domain, this.active, this.provider, this.syncUserAttributes, this.allowSubdomains, this.allowIdpInitiated, this.disableAdditionalIdentifications, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return Utils.toString(SAMLConnectionSAMLConnection.class, "id", this.id, "name", this.name, "domain", this.domain, "active", this.active, "provider", this.provider, "syncUserAttributes", this.syncUserAttributes, "allowSubdomains", this.allowSubdomains, "allowIdpInitiated", this.allowIdpInitiated, "disableAdditionalIdentifications", this.disableAdditionalIdentifications, "createdAt", this.createdAt, "updatedAt", this.updatedAt);
    }

    public static final class Builder {
        private String id;
        private String name;
        private String domain;
        private Boolean active;
        private String provider;
        private Boolean syncUserAttributes;
        private Optional<Boolean> allowSubdomains = Optional.empty();
        private Optional<Boolean> allowIdpInitiated = Optional.empty();
        private Optional<Boolean> disableAdditionalIdentifications = Optional.empty();
        private Long createdAt;
        private Long updatedAt;

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder domain(String domain) {
            Utils.checkNotNull(domain, "domain");
            this.domain = domain;
            return this;
        }

        public Builder active(boolean active) {
            Utils.checkNotNull(active, "active");
            this.active = active;
            return this;
        }

        public Builder provider(String provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = provider;
            return this;
        }

        public Builder syncUserAttributes(boolean syncUserAttributes) {
            Utils.checkNotNull(syncUserAttributes, "syncUserAttributes");
            this.syncUserAttributes = syncUserAttributes;
            return this;
        }

        public Builder allowSubdomains(boolean allowSubdomains) {
            Utils.checkNotNull(allowSubdomains, "allowSubdomains");
            this.allowSubdomains = Optional.ofNullable(allowSubdomains);
            return this;
        }

        public Builder allowSubdomains(Optional<Boolean> allowSubdomains) {
            Utils.checkNotNull(allowSubdomains, "allowSubdomains");
            this.allowSubdomains = allowSubdomains;
            return this;
        }

        public Builder allowIdpInitiated(boolean allowIdpInitiated) {
            Utils.checkNotNull(allowIdpInitiated, "allowIdpInitiated");
            this.allowIdpInitiated = Optional.ofNullable(allowIdpInitiated);
            return this;
        }

        public Builder allowIdpInitiated(Optional<Boolean> allowIdpInitiated) {
            Utils.checkNotNull(allowIdpInitiated, "allowIdpInitiated");
            this.allowIdpInitiated = allowIdpInitiated;
            return this;
        }

        public Builder disableAdditionalIdentifications(boolean disableAdditionalIdentifications) {
            Utils.checkNotNull(disableAdditionalIdentifications, "disableAdditionalIdentifications");
            this.disableAdditionalIdentifications = Optional.ofNullable(disableAdditionalIdentifications);
            return this;
        }

        public Builder disableAdditionalIdentifications(Optional<Boolean> disableAdditionalIdentifications) {
            Utils.checkNotNull(disableAdditionalIdentifications, "disableAdditionalIdentifications");
            this.disableAdditionalIdentifications = disableAdditionalIdentifications;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public SAMLConnectionSAMLConnection build() {
            return new SAMLConnectionSAMLConnection(this.id, this.name, this.domain, this.active, this.provider, this.syncUserAttributes, this.allowSubdomains, this.allowIdpInitiated, this.disableAdditionalIdentifications, this.createdAt, this.updatedAt);
        }
    }
}

