/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.SchemasPasskeyObject;
import com.clerk.backend_api.models.components.SchemasPasskeyVerification;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class SchemasPasskey {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private Optional<String> id;
    @JsonProperty(value="object")
    private SchemasPasskeyObject object;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="last_used_at")
    private long lastUsedAt;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="verification")
    private Optional<? extends SchemasPasskeyVerification> verification;

    @JsonCreator
    public SchemasPasskey(@JsonProperty(value="id") Optional<String> id, @JsonProperty(value="object") SchemasPasskeyObject object, @JsonProperty(value="name") String name, @JsonProperty(value="last_used_at") long lastUsedAt, @JsonProperty(value="verification") Optional<? extends SchemasPasskeyVerification> verification) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(lastUsedAt, "lastUsedAt");
        Utils.checkNotNull(verification, "verification");
        this.id = id;
        this.object = object;
        this.name = name;
        this.lastUsedAt = lastUsedAt;
        this.verification = verification;
    }

    public SchemasPasskey(SchemasPasskeyObject object, String name, long lastUsedAt) {
        this(Optional.empty(), object, name, lastUsedAt, Optional.empty());
    }

    @JsonIgnore
    public Optional<String> id() {
        return this.id;
    }

    @JsonIgnore
    public SchemasPasskeyObject object() {
        return this.object;
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public long lastUsedAt() {
        return this.lastUsedAt;
    }

    @JsonIgnore
    public Optional<SchemasPasskeyVerification> verification() {
        return this.verification;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public SchemasPasskey withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = Optional.ofNullable(id);
        return this;
    }

    public SchemasPasskey withId(Optional<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public SchemasPasskey withObject(SchemasPasskeyObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public SchemasPasskey withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public SchemasPasskey withLastUsedAt(long lastUsedAt) {
        Utils.checkNotNull(lastUsedAt, "lastUsedAt");
        this.lastUsedAt = lastUsedAt;
        return this;
    }

    public SchemasPasskey withVerification(SchemasPasskeyVerification verification) {
        Utils.checkNotNull(verification, "verification");
        this.verification = Optional.ofNullable(verification);
        return this;
    }

    public SchemasPasskey withVerification(Optional<? extends SchemasPasskeyVerification> verification) {
        Utils.checkNotNull(verification, "verification");
        this.verification = verification;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemasPasskey other = (SchemasPasskey)o;
        return Objects.deepEquals(this.id, other.id) && Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.name, other.name) && Objects.deepEquals(this.lastUsedAt, other.lastUsedAt) && Objects.deepEquals(this.verification, other.verification);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.object, this.name, this.lastUsedAt, this.verification});
    }

    public String toString() {
        return Utils.toString(SchemasPasskey.class, new Object[]{"id", this.id, "object", this.object, "name", this.name, "lastUsedAt", this.lastUsedAt, "verification", this.verification});
    }

    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private SchemasPasskeyObject object;
        private String name;
        private Long lastUsedAt;
        private Optional<? extends SchemasPasskeyVerification> verification = Optional.empty();

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = Optional.ofNullable(id);
            return this;
        }

        public Builder id(Optional<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder object(SchemasPasskeyObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder lastUsedAt(long lastUsedAt) {
            Utils.checkNotNull(lastUsedAt, "lastUsedAt");
            this.lastUsedAt = lastUsedAt;
            return this;
        }

        public Builder verification(SchemasPasskeyVerification verification) {
            Utils.checkNotNull(verification, "verification");
            this.verification = Optional.ofNullable(verification);
            return this;
        }

        public Builder verification(Optional<? extends SchemasPasskeyVerification> verification) {
            Utils.checkNotNull(verification, "verification");
            this.verification = verification;
            return this;
        }

        public SchemasPasskey build() {
            return new SchemasPasskey(this.id, this.object, this.name, this.lastUsedAt, this.verification);
        }
    }
}

