/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.SAMLConnectionAttributeMapping;
import com.clerk.backend_api.models.components.SchemasSAMLConnectionObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class SchemasSAMLConnection {
    @JsonProperty(value="object")
    private SchemasSAMLConnectionObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="domain")
    private String domain;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="idp_entity_id")
    private Optional<String> idpEntityId;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="idp_sso_url")
    private Optional<String> idpSsoUrl;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="idp_certificate")
    private Optional<String> idpCertificate;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="idp_metadata_url")
    private JsonNullable<String> idpMetadataUrl;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="idp_metadata")
    private JsonNullable<String> idpMetadata;
    @JsonProperty(value="acs_url")
    private String acsUrl;
    @JsonProperty(value="sp_entity_id")
    private String spEntityId;
    @JsonProperty(value="sp_metadata_url")
    private String spMetadataUrl;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="organization_id")
    private JsonNullable<String> organizationId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="attribute_mapping")
    private Optional<? extends SAMLConnectionAttributeMapping> attributeMapping;
    @JsonProperty(value="active")
    private boolean active;
    @JsonProperty(value="provider")
    private String provider;
    @JsonProperty(value="user_count")
    private long userCount;
    @JsonProperty(value="sync_user_attributes")
    private boolean syncUserAttributes;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="allow_subdomains")
    private Optional<Boolean> allowSubdomains;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="allow_idp_initiated")
    private Optional<Boolean> allowIdpInitiated;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="disable_additional_identifications")
    private Optional<Boolean> disableAdditionalIdentifications;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    @JsonCreator
    public SchemasSAMLConnection(@JsonProperty(value="object") SchemasSAMLConnectionObject object, @JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="domain") String domain, @JsonProperty(value="idp_entity_id") Optional<String> idpEntityId, @JsonProperty(value="idp_sso_url") Optional<String> idpSsoUrl, @JsonProperty(value="idp_certificate") Optional<String> idpCertificate, @JsonProperty(value="idp_metadata_url") JsonNullable<String> idpMetadataUrl, @JsonProperty(value="idp_metadata") JsonNullable<String> idpMetadata, @JsonProperty(value="acs_url") String acsUrl, @JsonProperty(value="sp_entity_id") String spEntityId, @JsonProperty(value="sp_metadata_url") String spMetadataUrl, @JsonProperty(value="organization_id") JsonNullable<String> organizationId, @JsonProperty(value="attribute_mapping") Optional<? extends SAMLConnectionAttributeMapping> attributeMapping, @JsonProperty(value="active") boolean active, @JsonProperty(value="provider") String provider, @JsonProperty(value="user_count") long userCount, @JsonProperty(value="sync_user_attributes") boolean syncUserAttributes, @JsonProperty(value="allow_subdomains") Optional<Boolean> allowSubdomains, @JsonProperty(value="allow_idp_initiated") Optional<Boolean> allowIdpInitiated, @JsonProperty(value="disable_additional_identifications") Optional<Boolean> disableAdditionalIdentifications, @JsonProperty(value="created_at") long createdAt, @JsonProperty(value="updated_at") long updatedAt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(domain, "domain");
        Utils.checkNotNull(idpEntityId, "idpEntityId");
        Utils.checkNotNull(idpSsoUrl, "idpSsoUrl");
        Utils.checkNotNull(idpCertificate, "idpCertificate");
        Utils.checkNotNull(idpMetadataUrl, "idpMetadataUrl");
        Utils.checkNotNull(idpMetadata, "idpMetadata");
        Utils.checkNotNull(acsUrl, "acsUrl");
        Utils.checkNotNull(spEntityId, "spEntityId");
        Utils.checkNotNull(spMetadataUrl, "spMetadataUrl");
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(attributeMapping, "attributeMapping");
        Utils.checkNotNull(active, "active");
        Utils.checkNotNull(provider, "provider");
        Utils.checkNotNull(userCount, "userCount");
        Utils.checkNotNull(syncUserAttributes, "syncUserAttributes");
        Utils.checkNotNull(allowSubdomains, "allowSubdomains");
        Utils.checkNotNull(allowIdpInitiated, "allowIdpInitiated");
        Utils.checkNotNull(disableAdditionalIdentifications, "disableAdditionalIdentifications");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.object = object;
        this.id = id;
        this.name = name;
        this.domain = domain;
        this.idpEntityId = idpEntityId;
        this.idpSsoUrl = idpSsoUrl;
        this.idpCertificate = idpCertificate;
        this.idpMetadataUrl = idpMetadataUrl;
        this.idpMetadata = idpMetadata;
        this.acsUrl = acsUrl;
        this.spEntityId = spEntityId;
        this.spMetadataUrl = spMetadataUrl;
        this.organizationId = organizationId;
        this.attributeMapping = attributeMapping;
        this.active = active;
        this.provider = provider;
        this.userCount = userCount;
        this.syncUserAttributes = syncUserAttributes;
        this.allowSubdomains = allowSubdomains;
        this.allowIdpInitiated = allowIdpInitiated;
        this.disableAdditionalIdentifications = disableAdditionalIdentifications;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public SchemasSAMLConnection(SchemasSAMLConnectionObject object, String id, String name, String domain, String acsUrl, String spEntityId, String spMetadataUrl, boolean active, String provider, long userCount, boolean syncUserAttributes, long createdAt, long updatedAt) {
        this(object, id, name, domain, Optional.empty(), Optional.empty(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), acsUrl, spEntityId, spMetadataUrl, (JsonNullable<String>)JsonNullable.undefined(), Optional.empty(), active, provider, userCount, syncUserAttributes, Optional.empty(), Optional.empty(), Optional.empty(), createdAt, updatedAt);
    }

    @JsonIgnore
    public SchemasSAMLConnectionObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public String domain() {
        return this.domain;
    }

    @JsonIgnore
    public Optional<String> idpEntityId() {
        return this.idpEntityId;
    }

    @JsonIgnore
    public Optional<String> idpSsoUrl() {
        return this.idpSsoUrl;
    }

    @JsonIgnore
    public Optional<String> idpCertificate() {
        return this.idpCertificate;
    }

    @JsonIgnore
    public JsonNullable<String> idpMetadataUrl() {
        return this.idpMetadataUrl;
    }

    @JsonIgnore
    public JsonNullable<String> idpMetadata() {
        return this.idpMetadata;
    }

    @JsonIgnore
    public String acsUrl() {
        return this.acsUrl;
    }

    @JsonIgnore
    public String spEntityId() {
        return this.spEntityId;
    }

    @JsonIgnore
    public String spMetadataUrl() {
        return this.spMetadataUrl;
    }

    @JsonIgnore
    public JsonNullable<String> organizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public Optional<SAMLConnectionAttributeMapping> attributeMapping() {
        return this.attributeMapping;
    }

    @JsonIgnore
    public boolean active() {
        return this.active;
    }

    @JsonIgnore
    public String provider() {
        return this.provider;
    }

    @JsonIgnore
    public long userCount() {
        return this.userCount;
    }

    @JsonIgnore
    public boolean syncUserAttributes() {
        return this.syncUserAttributes;
    }

    @JsonIgnore
    public Optional<Boolean> allowSubdomains() {
        return this.allowSubdomains;
    }

    @JsonIgnore
    public Optional<Boolean> allowIdpInitiated() {
        return this.allowIdpInitiated;
    }

    @JsonIgnore
    public Optional<Boolean> disableAdditionalIdentifications() {
        return this.disableAdditionalIdentifications;
    }

    @JsonIgnore
    public long createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public long updatedAt() {
        return this.updatedAt;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public SchemasSAMLConnection withObject(SchemasSAMLConnectionObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public SchemasSAMLConnection withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public SchemasSAMLConnection withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public SchemasSAMLConnection withDomain(String domain) {
        Utils.checkNotNull(domain, "domain");
        this.domain = domain;
        return this;
    }

    public SchemasSAMLConnection withIdpEntityId(String idpEntityId) {
        Utils.checkNotNull(idpEntityId, "idpEntityId");
        this.idpEntityId = Optional.ofNullable(idpEntityId);
        return this;
    }

    public SchemasSAMLConnection withIdpEntityId(Optional<String> idpEntityId) {
        Utils.checkNotNull(idpEntityId, "idpEntityId");
        this.idpEntityId = idpEntityId;
        return this;
    }

    public SchemasSAMLConnection withIdpSsoUrl(String idpSsoUrl) {
        Utils.checkNotNull(idpSsoUrl, "idpSsoUrl");
        this.idpSsoUrl = Optional.ofNullable(idpSsoUrl);
        return this;
    }

    public SchemasSAMLConnection withIdpSsoUrl(Optional<String> idpSsoUrl) {
        Utils.checkNotNull(idpSsoUrl, "idpSsoUrl");
        this.idpSsoUrl = idpSsoUrl;
        return this;
    }

    public SchemasSAMLConnection withIdpCertificate(String idpCertificate) {
        Utils.checkNotNull(idpCertificate, "idpCertificate");
        this.idpCertificate = Optional.ofNullable(idpCertificate);
        return this;
    }

    public SchemasSAMLConnection withIdpCertificate(Optional<String> idpCertificate) {
        Utils.checkNotNull(idpCertificate, "idpCertificate");
        this.idpCertificate = idpCertificate;
        return this;
    }

    public SchemasSAMLConnection withIdpMetadataUrl(String idpMetadataUrl) {
        Utils.checkNotNull(idpMetadataUrl, "idpMetadataUrl");
        this.idpMetadataUrl = JsonNullable.of((Object)idpMetadataUrl);
        return this;
    }

    public SchemasSAMLConnection withIdpMetadataUrl(JsonNullable<String> idpMetadataUrl) {
        Utils.checkNotNull(idpMetadataUrl, "idpMetadataUrl");
        this.idpMetadataUrl = idpMetadataUrl;
        return this;
    }

    public SchemasSAMLConnection withIdpMetadata(String idpMetadata) {
        Utils.checkNotNull(idpMetadata, "idpMetadata");
        this.idpMetadata = JsonNullable.of((Object)idpMetadata);
        return this;
    }

    public SchemasSAMLConnection withIdpMetadata(JsonNullable<String> idpMetadata) {
        Utils.checkNotNull(idpMetadata, "idpMetadata");
        this.idpMetadata = idpMetadata;
        return this;
    }

    public SchemasSAMLConnection withAcsUrl(String acsUrl) {
        Utils.checkNotNull(acsUrl, "acsUrl");
        this.acsUrl = acsUrl;
        return this;
    }

    public SchemasSAMLConnection withSpEntityId(String spEntityId) {
        Utils.checkNotNull(spEntityId, "spEntityId");
        this.spEntityId = spEntityId;
        return this;
    }

    public SchemasSAMLConnection withSpMetadataUrl(String spMetadataUrl) {
        Utils.checkNotNull(spMetadataUrl, "spMetadataUrl");
        this.spMetadataUrl = spMetadataUrl;
        return this;
    }

    public SchemasSAMLConnection withOrganizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = JsonNullable.of((Object)organizationId);
        return this;
    }

    public SchemasSAMLConnection withOrganizationId(JsonNullable<String> organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public SchemasSAMLConnection withAttributeMapping(SAMLConnectionAttributeMapping attributeMapping) {
        Utils.checkNotNull(attributeMapping, "attributeMapping");
        this.attributeMapping = Optional.ofNullable(attributeMapping);
        return this;
    }

    public SchemasSAMLConnection withAttributeMapping(Optional<? extends SAMLConnectionAttributeMapping> attributeMapping) {
        Utils.checkNotNull(attributeMapping, "attributeMapping");
        this.attributeMapping = attributeMapping;
        return this;
    }

    public SchemasSAMLConnection withActive(boolean active) {
        Utils.checkNotNull(active, "active");
        this.active = active;
        return this;
    }

    public SchemasSAMLConnection withProvider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    public SchemasSAMLConnection withUserCount(long userCount) {
        Utils.checkNotNull(userCount, "userCount");
        this.userCount = userCount;
        return this;
    }

    public SchemasSAMLConnection withSyncUserAttributes(boolean syncUserAttributes) {
        Utils.checkNotNull(syncUserAttributes, "syncUserAttributes");
        this.syncUserAttributes = syncUserAttributes;
        return this;
    }

    public SchemasSAMLConnection withAllowSubdomains(boolean allowSubdomains) {
        Utils.checkNotNull(allowSubdomains, "allowSubdomains");
        this.allowSubdomains = Optional.ofNullable(allowSubdomains);
        return this;
    }

    public SchemasSAMLConnection withAllowSubdomains(Optional<Boolean> allowSubdomains) {
        Utils.checkNotNull(allowSubdomains, "allowSubdomains");
        this.allowSubdomains = allowSubdomains;
        return this;
    }

    public SchemasSAMLConnection withAllowIdpInitiated(boolean allowIdpInitiated) {
        Utils.checkNotNull(allowIdpInitiated, "allowIdpInitiated");
        this.allowIdpInitiated = Optional.ofNullable(allowIdpInitiated);
        return this;
    }

    public SchemasSAMLConnection withAllowIdpInitiated(Optional<Boolean> allowIdpInitiated) {
        Utils.checkNotNull(allowIdpInitiated, "allowIdpInitiated");
        this.allowIdpInitiated = allowIdpInitiated;
        return this;
    }

    public SchemasSAMLConnection withDisableAdditionalIdentifications(boolean disableAdditionalIdentifications) {
        Utils.checkNotNull(disableAdditionalIdentifications, "disableAdditionalIdentifications");
        this.disableAdditionalIdentifications = Optional.ofNullable(disableAdditionalIdentifications);
        return this;
    }

    public SchemasSAMLConnection withDisableAdditionalIdentifications(Optional<Boolean> disableAdditionalIdentifications) {
        Utils.checkNotNull(disableAdditionalIdentifications, "disableAdditionalIdentifications");
        this.disableAdditionalIdentifications = disableAdditionalIdentifications;
        return this;
    }

    public SchemasSAMLConnection withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public SchemasSAMLConnection withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemasSAMLConnection other = (SchemasSAMLConnection)o;
        return Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.name, other.name) && Objects.deepEquals(this.domain, other.domain) && Objects.deepEquals(this.idpEntityId, other.idpEntityId) && Objects.deepEquals(this.idpSsoUrl, other.idpSsoUrl) && Objects.deepEquals(this.idpCertificate, other.idpCertificate) && Objects.deepEquals(this.idpMetadataUrl, other.idpMetadataUrl) && Objects.deepEquals(this.idpMetadata, other.idpMetadata) && Objects.deepEquals(this.acsUrl, other.acsUrl) && Objects.deepEquals(this.spEntityId, other.spEntityId) && Objects.deepEquals(this.spMetadataUrl, other.spMetadataUrl) && Objects.deepEquals(this.organizationId, other.organizationId) && Objects.deepEquals(this.attributeMapping, other.attributeMapping) && Objects.deepEquals(this.active, other.active) && Objects.deepEquals(this.provider, other.provider) && Objects.deepEquals(this.userCount, other.userCount) && Objects.deepEquals(this.syncUserAttributes, other.syncUserAttributes) && Objects.deepEquals(this.allowSubdomains, other.allowSubdomains) && Objects.deepEquals(this.allowIdpInitiated, other.allowIdpInitiated) && Objects.deepEquals(this.disableAdditionalIdentifications, other.disableAdditionalIdentifications) && Objects.deepEquals(this.createdAt, other.createdAt) && Objects.deepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.object, this.id, this.name, this.domain, this.idpEntityId, this.idpSsoUrl, this.idpCertificate, this.idpMetadataUrl, this.idpMetadata, this.acsUrl, this.spEntityId, this.spMetadataUrl, this.organizationId, this.attributeMapping, this.active, this.provider, this.userCount, this.syncUserAttributes, this.allowSubdomains, this.allowIdpInitiated, this.disableAdditionalIdentifications, this.createdAt, this.updatedAt});
    }

    public String toString() {
        return Utils.toString(SchemasSAMLConnection.class, new Object[]{"object", this.object, "id", this.id, "name", this.name, "domain", this.domain, "idpEntityId", this.idpEntityId, "idpSsoUrl", this.idpSsoUrl, "idpCertificate", this.idpCertificate, "idpMetadataUrl", this.idpMetadataUrl, "idpMetadata", this.idpMetadata, "acsUrl", this.acsUrl, "spEntityId", this.spEntityId, "spMetadataUrl", this.spMetadataUrl, "organizationId", this.organizationId, "attributeMapping", this.attributeMapping, "active", this.active, "provider", this.provider, "userCount", this.userCount, "syncUserAttributes", this.syncUserAttributes, "allowSubdomains", this.allowSubdomains, "allowIdpInitiated", this.allowIdpInitiated, "disableAdditionalIdentifications", this.disableAdditionalIdentifications, "createdAt", this.createdAt, "updatedAt", this.updatedAt});
    }

    public static final class Builder {
        private SchemasSAMLConnectionObject object;
        private String id;
        private String name;
        private String domain;
        private Optional<String> idpEntityId = Optional.empty();
        private Optional<String> idpSsoUrl = Optional.empty();
        private Optional<String> idpCertificate = Optional.empty();
        private JsonNullable<String> idpMetadataUrl = JsonNullable.undefined();
        private JsonNullable<String> idpMetadata = JsonNullable.undefined();
        private String acsUrl;
        private String spEntityId;
        private String spMetadataUrl;
        private JsonNullable<String> organizationId = JsonNullable.undefined();
        private Optional<? extends SAMLConnectionAttributeMapping> attributeMapping = Optional.empty();
        private Boolean active;
        private String provider;
        private Long userCount;
        private Boolean syncUserAttributes;
        private Optional<Boolean> allowSubdomains = Optional.empty();
        private Optional<Boolean> allowIdpInitiated = Optional.empty();
        private Optional<Boolean> disableAdditionalIdentifications = Optional.empty();
        private Long createdAt;
        private Long updatedAt;

        private Builder() {
        }

        public Builder object(SchemasSAMLConnectionObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder domain(String domain) {
            Utils.checkNotNull(domain, "domain");
            this.domain = domain;
            return this;
        }

        public Builder idpEntityId(String idpEntityId) {
            Utils.checkNotNull(idpEntityId, "idpEntityId");
            this.idpEntityId = Optional.ofNullable(idpEntityId);
            return this;
        }

        public Builder idpEntityId(Optional<String> idpEntityId) {
            Utils.checkNotNull(idpEntityId, "idpEntityId");
            this.idpEntityId = idpEntityId;
            return this;
        }

        public Builder idpSsoUrl(String idpSsoUrl) {
            Utils.checkNotNull(idpSsoUrl, "idpSsoUrl");
            this.idpSsoUrl = Optional.ofNullable(idpSsoUrl);
            return this;
        }

        public Builder idpSsoUrl(Optional<String> idpSsoUrl) {
            Utils.checkNotNull(idpSsoUrl, "idpSsoUrl");
            this.idpSsoUrl = idpSsoUrl;
            return this;
        }

        public Builder idpCertificate(String idpCertificate) {
            Utils.checkNotNull(idpCertificate, "idpCertificate");
            this.idpCertificate = Optional.ofNullable(idpCertificate);
            return this;
        }

        public Builder idpCertificate(Optional<String> idpCertificate) {
            Utils.checkNotNull(idpCertificate, "idpCertificate");
            this.idpCertificate = idpCertificate;
            return this;
        }

        public Builder idpMetadataUrl(String idpMetadataUrl) {
            Utils.checkNotNull(idpMetadataUrl, "idpMetadataUrl");
            this.idpMetadataUrl = JsonNullable.of((Object)idpMetadataUrl);
            return this;
        }

        public Builder idpMetadataUrl(JsonNullable<String> idpMetadataUrl) {
            Utils.checkNotNull(idpMetadataUrl, "idpMetadataUrl");
            this.idpMetadataUrl = idpMetadataUrl;
            return this;
        }

        public Builder idpMetadata(String idpMetadata) {
            Utils.checkNotNull(idpMetadata, "idpMetadata");
            this.idpMetadata = JsonNullable.of((Object)idpMetadata);
            return this;
        }

        public Builder idpMetadata(JsonNullable<String> idpMetadata) {
            Utils.checkNotNull(idpMetadata, "idpMetadata");
            this.idpMetadata = idpMetadata;
            return this;
        }

        public Builder acsUrl(String acsUrl) {
            Utils.checkNotNull(acsUrl, "acsUrl");
            this.acsUrl = acsUrl;
            return this;
        }

        public Builder spEntityId(String spEntityId) {
            Utils.checkNotNull(spEntityId, "spEntityId");
            this.spEntityId = spEntityId;
            return this;
        }

        public Builder spMetadataUrl(String spMetadataUrl) {
            Utils.checkNotNull(spMetadataUrl, "spMetadataUrl");
            this.spMetadataUrl = spMetadataUrl;
            return this;
        }

        public Builder organizationId(String organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = JsonNullable.of((Object)organizationId);
            return this;
        }

        public Builder organizationId(JsonNullable<String> organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder attributeMapping(SAMLConnectionAttributeMapping attributeMapping) {
            Utils.checkNotNull(attributeMapping, "attributeMapping");
            this.attributeMapping = Optional.ofNullable(attributeMapping);
            return this;
        }

        public Builder attributeMapping(Optional<? extends SAMLConnectionAttributeMapping> attributeMapping) {
            Utils.checkNotNull(attributeMapping, "attributeMapping");
            this.attributeMapping = attributeMapping;
            return this;
        }

        public Builder active(boolean active) {
            Utils.checkNotNull(active, "active");
            this.active = active;
            return this;
        }

        public Builder provider(String provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = provider;
            return this;
        }

        public Builder userCount(long userCount) {
            Utils.checkNotNull(userCount, "userCount");
            this.userCount = userCount;
            return this;
        }

        public Builder syncUserAttributes(boolean syncUserAttributes) {
            Utils.checkNotNull(syncUserAttributes, "syncUserAttributes");
            this.syncUserAttributes = syncUserAttributes;
            return this;
        }

        public Builder allowSubdomains(boolean allowSubdomains) {
            Utils.checkNotNull(allowSubdomains, "allowSubdomains");
            this.allowSubdomains = Optional.ofNullable(allowSubdomains);
            return this;
        }

        public Builder allowSubdomains(Optional<Boolean> allowSubdomains) {
            Utils.checkNotNull(allowSubdomains, "allowSubdomains");
            this.allowSubdomains = allowSubdomains;
            return this;
        }

        public Builder allowIdpInitiated(boolean allowIdpInitiated) {
            Utils.checkNotNull(allowIdpInitiated, "allowIdpInitiated");
            this.allowIdpInitiated = Optional.ofNullable(allowIdpInitiated);
            return this;
        }

        public Builder allowIdpInitiated(Optional<Boolean> allowIdpInitiated) {
            Utils.checkNotNull(allowIdpInitiated, "allowIdpInitiated");
            this.allowIdpInitiated = allowIdpInitiated;
            return this;
        }

        public Builder disableAdditionalIdentifications(boolean disableAdditionalIdentifications) {
            Utils.checkNotNull(disableAdditionalIdentifications, "disableAdditionalIdentifications");
            this.disableAdditionalIdentifications = Optional.ofNullable(disableAdditionalIdentifications);
            return this;
        }

        public Builder disableAdditionalIdentifications(Optional<Boolean> disableAdditionalIdentifications) {
            Utils.checkNotNull(disableAdditionalIdentifications, "disableAdditionalIdentifications");
            this.disableAdditionalIdentifications = disableAdditionalIdentifications;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public SchemasSAMLConnection build() {
            return new SchemasSAMLConnection(this.object, this.id, this.name, this.domain, this.idpEntityId, this.idpSsoUrl, this.idpCertificate, this.idpMetadataUrl, this.idpMetadata, this.acsUrl, this.spEntityId, this.spMetadataUrl, this.organizationId, this.attributeMapping, this.active, this.provider, this.userCount, this.syncUserAttributes, this.allowSubdomains, this.allowIdpInitiated, this.disableAdditionalIdentifications, this.createdAt, this.updatedAt);
        }
    }
}

