/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.SignUpExternalAccount;
import com.clerk.backend_api.models.components.SignUpObject;
import com.clerk.backend_api.models.components.SignUpStatus;
import com.clerk.backend_api.models.components.SignUpVerifications;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SignUp {
    @JsonProperty(value="object")
    private SignUpObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="status")
    private SignUpStatus status;
    @JsonProperty(value="required_fields")
    private List<String> requiredFields;
    @JsonProperty(value="optional_fields")
    private List<String> optionalFields;
    @JsonProperty(value="missing_fields")
    private List<String> missingFields;
    @JsonProperty(value="unverified_fields")
    private List<String> unverifiedFields;
    @JsonProperty(value="verifications")
    private SignUpVerifications verifications;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="username")
    private Optional<String> username;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="email_address")
    private Optional<String> emailAddress;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="phone_number")
    private Optional<String> phoneNumber;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="web3_wallet")
    private Optional<String> web3Wallet;
    @JsonProperty(value="password_enabled")
    private boolean passwordEnabled;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="first_name")
    private Optional<String> firstName;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="last_name")
    private Optional<String> lastName;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="unsafe_metadata")
    private Optional<? extends Map<String, Object>> unsafeMetadata;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="public_metadata")
    private Optional<? extends Map<String, Object>> publicMetadata;
    @JsonProperty(value="custom_action")
    private boolean customAction;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="external_id")
    private Optional<String> externalId;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="created_session_id")
    private Optional<String> createdSessionId;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="created_user_id")
    private Optional<String> createdUserId;
    @JsonProperty(value="abandon_at")
    private long abandonAt;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="legal_accepted_at")
    private Optional<Long> legalAcceptedAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="external_account")
    @Deprecated
    private Optional<? extends SignUpExternalAccount> externalAccount;

    @JsonCreator
    public SignUp(@JsonProperty(value="object") SignUpObject object, @JsonProperty(value="id") String id, @JsonProperty(value="status") SignUpStatus status, @JsonProperty(value="required_fields") List<String> requiredFields, @JsonProperty(value="optional_fields") List<String> optionalFields, @JsonProperty(value="missing_fields") List<String> missingFields, @JsonProperty(value="unverified_fields") List<String> unverifiedFields, @JsonProperty(value="verifications") SignUpVerifications verifications, @JsonProperty(value="username") Optional<String> username, @JsonProperty(value="email_address") Optional<String> emailAddress, @JsonProperty(value="phone_number") Optional<String> phoneNumber, @JsonProperty(value="web3_wallet") Optional<String> web3Wallet, @JsonProperty(value="password_enabled") boolean passwordEnabled, @JsonProperty(value="first_name") Optional<String> firstName, @JsonProperty(value="last_name") Optional<String> lastName, @JsonProperty(value="unsafe_metadata") Optional<? extends Map<String, Object>> unsafeMetadata, @JsonProperty(value="public_metadata") Optional<? extends Map<String, Object>> publicMetadata, @JsonProperty(value="custom_action") boolean customAction, @JsonProperty(value="external_id") Optional<String> externalId, @JsonProperty(value="created_session_id") Optional<String> createdSessionId, @JsonProperty(value="created_user_id") Optional<String> createdUserId, @JsonProperty(value="abandon_at") long abandonAt, @JsonProperty(value="legal_accepted_at") Optional<Long> legalAcceptedAt, @JsonProperty(value="external_account") Optional<? extends SignUpExternalAccount> externalAccount) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(requiredFields, "requiredFields");
        Utils.checkNotNull(optionalFields, "optionalFields");
        Utils.checkNotNull(missingFields, "missingFields");
        Utils.checkNotNull(unverifiedFields, "unverifiedFields");
        Utils.checkNotNull(verifications, "verifications");
        Utils.checkNotNull(username, "username");
        Utils.checkNotNull(emailAddress, "emailAddress");
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        Utils.checkNotNull(web3Wallet, "web3Wallet");
        Utils.checkNotNull(passwordEnabled, "passwordEnabled");
        Utils.checkNotNull(firstName, "firstName");
        Utils.checkNotNull(lastName, "lastName");
        Utils.checkNotNull(unsafeMetadata, "unsafeMetadata");
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        Utils.checkNotNull(customAction, "customAction");
        Utils.checkNotNull(externalId, "externalId");
        Utils.checkNotNull(createdSessionId, "createdSessionId");
        Utils.checkNotNull(createdUserId, "createdUserId");
        Utils.checkNotNull(abandonAt, "abandonAt");
        Utils.checkNotNull(legalAcceptedAt, "legalAcceptedAt");
        Utils.checkNotNull(externalAccount, "externalAccount");
        this.object = object;
        this.id = id;
        this.status = status;
        this.requiredFields = requiredFields;
        this.optionalFields = optionalFields;
        this.missingFields = missingFields;
        this.unverifiedFields = unverifiedFields;
        this.verifications = verifications;
        this.username = username;
        this.emailAddress = emailAddress;
        this.phoneNumber = phoneNumber;
        this.web3Wallet = web3Wallet;
        this.passwordEnabled = passwordEnabled;
        this.firstName = firstName;
        this.lastName = lastName;
        this.unsafeMetadata = unsafeMetadata;
        this.publicMetadata = publicMetadata;
        this.customAction = customAction;
        this.externalId = externalId;
        this.createdSessionId = createdSessionId;
        this.createdUserId = createdUserId;
        this.abandonAt = abandonAt;
        this.legalAcceptedAt = legalAcceptedAt;
        this.externalAccount = externalAccount;
    }

    public SignUp(SignUpObject object, String id, SignUpStatus status, List<String> requiredFields, List<String> optionalFields, List<String> missingFields, List<String> unverifiedFields, SignUpVerifications verifications, boolean passwordEnabled, boolean customAction, long abandonAt) {
        this(object, id, status, requiredFields, optionalFields, missingFields, unverifiedFields, verifications, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), passwordEnabled, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), customAction, Optional.empty(), Optional.empty(), Optional.empty(), abandonAt, Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public SignUpObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public SignUpStatus status() {
        return this.status;
    }

    @JsonIgnore
    public List<String> requiredFields() {
        return this.requiredFields;
    }

    @JsonIgnore
    public List<String> optionalFields() {
        return this.optionalFields;
    }

    @JsonIgnore
    public List<String> missingFields() {
        return this.missingFields;
    }

    @JsonIgnore
    public List<String> unverifiedFields() {
        return this.unverifiedFields;
    }

    @JsonIgnore
    public SignUpVerifications verifications() {
        return this.verifications;
    }

    @JsonIgnore
    public Optional<String> username() {
        return this.username;
    }

    @JsonIgnore
    public Optional<String> emailAddress() {
        return this.emailAddress;
    }

    @JsonIgnore
    public Optional<String> phoneNumber() {
        return this.phoneNumber;
    }

    @JsonIgnore
    public Optional<String> web3Wallet() {
        return this.web3Wallet;
    }

    @JsonIgnore
    public boolean passwordEnabled() {
        return this.passwordEnabled;
    }

    @JsonIgnore
    public Optional<String> firstName() {
        return this.firstName;
    }

    @JsonIgnore
    public Optional<String> lastName() {
        return this.lastName;
    }

    @JsonIgnore
    public Optional<Map<String, Object>> unsafeMetadata() {
        return this.unsafeMetadata;
    }

    @JsonIgnore
    public Optional<Map<String, Object>> publicMetadata() {
        return this.publicMetadata;
    }

    @JsonIgnore
    public boolean customAction() {
        return this.customAction;
    }

    @JsonIgnore
    public Optional<String> externalId() {
        return this.externalId;
    }

    @JsonIgnore
    public Optional<String> createdSessionId() {
        return this.createdSessionId;
    }

    @JsonIgnore
    public Optional<String> createdUserId() {
        return this.createdUserId;
    }

    @JsonIgnore
    public long abandonAt() {
        return this.abandonAt;
    }

    @JsonIgnore
    public Optional<Long> legalAcceptedAt() {
        return this.legalAcceptedAt;
    }

    @Deprecated
    @JsonIgnore
    public Optional<SignUpExternalAccount> externalAccount() {
        return this.externalAccount;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public SignUp withObject(SignUpObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public SignUp withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public SignUp withStatus(SignUpStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public SignUp withRequiredFields(List<String> requiredFields) {
        Utils.checkNotNull(requiredFields, "requiredFields");
        this.requiredFields = requiredFields;
        return this;
    }

    public SignUp withOptionalFields(List<String> optionalFields) {
        Utils.checkNotNull(optionalFields, "optionalFields");
        this.optionalFields = optionalFields;
        return this;
    }

    public SignUp withMissingFields(List<String> missingFields) {
        Utils.checkNotNull(missingFields, "missingFields");
        this.missingFields = missingFields;
        return this;
    }

    public SignUp withUnverifiedFields(List<String> unverifiedFields) {
        Utils.checkNotNull(unverifiedFields, "unverifiedFields");
        this.unverifiedFields = unverifiedFields;
        return this;
    }

    public SignUp withVerifications(SignUpVerifications verifications) {
        Utils.checkNotNull(verifications, "verifications");
        this.verifications = verifications;
        return this;
    }

    public SignUp withUsername(String username) {
        Utils.checkNotNull(username, "username");
        this.username = Optional.ofNullable(username);
        return this;
    }

    public SignUp withUsername(Optional<String> username) {
        Utils.checkNotNull(username, "username");
        this.username = username;
        return this;
    }

    public SignUp withEmailAddress(String emailAddress) {
        Utils.checkNotNull(emailAddress, "emailAddress");
        this.emailAddress = Optional.ofNullable(emailAddress);
        return this;
    }

    public SignUp withEmailAddress(Optional<String> emailAddress) {
        Utils.checkNotNull(emailAddress, "emailAddress");
        this.emailAddress = emailAddress;
        return this;
    }

    public SignUp withPhoneNumber(String phoneNumber) {
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        this.phoneNumber = Optional.ofNullable(phoneNumber);
        return this;
    }

    public SignUp withPhoneNumber(Optional<String> phoneNumber) {
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        this.phoneNumber = phoneNumber;
        return this;
    }

    public SignUp withWeb3Wallet(String web3Wallet) {
        Utils.checkNotNull(web3Wallet, "web3Wallet");
        this.web3Wallet = Optional.ofNullable(web3Wallet);
        return this;
    }

    public SignUp withWeb3Wallet(Optional<String> web3Wallet) {
        Utils.checkNotNull(web3Wallet, "web3Wallet");
        this.web3Wallet = web3Wallet;
        return this;
    }

    public SignUp withPasswordEnabled(boolean passwordEnabled) {
        Utils.checkNotNull(passwordEnabled, "passwordEnabled");
        this.passwordEnabled = passwordEnabled;
        return this;
    }

    public SignUp withFirstName(String firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = Optional.ofNullable(firstName);
        return this;
    }

    public SignUp withFirstName(Optional<String> firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = firstName;
        return this;
    }

    public SignUp withLastName(String lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = Optional.ofNullable(lastName);
        return this;
    }

    public SignUp withLastName(Optional<String> lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = lastName;
        return this;
    }

    public SignUp withUnsafeMetadata(Map<String, Object> unsafeMetadata) {
        Utils.checkNotNull(unsafeMetadata, "unsafeMetadata");
        this.unsafeMetadata = Optional.ofNullable(unsafeMetadata);
        return this;
    }

    public SignUp withUnsafeMetadata(Optional<? extends Map<String, Object>> unsafeMetadata) {
        Utils.checkNotNull(unsafeMetadata, "unsafeMetadata");
        this.unsafeMetadata = unsafeMetadata;
        return this;
    }

    public SignUp withPublicMetadata(Map<String, Object> publicMetadata) {
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        this.publicMetadata = Optional.ofNullable(publicMetadata);
        return this;
    }

    public SignUp withPublicMetadata(Optional<? extends Map<String, Object>> publicMetadata) {
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        this.publicMetadata = publicMetadata;
        return this;
    }

    public SignUp withCustomAction(boolean customAction) {
        Utils.checkNotNull(customAction, "customAction");
        this.customAction = customAction;
        return this;
    }

    public SignUp withExternalId(String externalId) {
        Utils.checkNotNull(externalId, "externalId");
        this.externalId = Optional.ofNullable(externalId);
        return this;
    }

    public SignUp withExternalId(Optional<String> externalId) {
        Utils.checkNotNull(externalId, "externalId");
        this.externalId = externalId;
        return this;
    }

    public SignUp withCreatedSessionId(String createdSessionId) {
        Utils.checkNotNull(createdSessionId, "createdSessionId");
        this.createdSessionId = Optional.ofNullable(createdSessionId);
        return this;
    }

    public SignUp withCreatedSessionId(Optional<String> createdSessionId) {
        Utils.checkNotNull(createdSessionId, "createdSessionId");
        this.createdSessionId = createdSessionId;
        return this;
    }

    public SignUp withCreatedUserId(String createdUserId) {
        Utils.checkNotNull(createdUserId, "createdUserId");
        this.createdUserId = Optional.ofNullable(createdUserId);
        return this;
    }

    public SignUp withCreatedUserId(Optional<String> createdUserId) {
        Utils.checkNotNull(createdUserId, "createdUserId");
        this.createdUserId = createdUserId;
        return this;
    }

    public SignUp withAbandonAt(long abandonAt) {
        Utils.checkNotNull(abandonAt, "abandonAt");
        this.abandonAt = abandonAt;
        return this;
    }

    public SignUp withLegalAcceptedAt(long legalAcceptedAt) {
        Utils.checkNotNull(legalAcceptedAt, "legalAcceptedAt");
        this.legalAcceptedAt = Optional.ofNullable(legalAcceptedAt);
        return this;
    }

    public SignUp withLegalAcceptedAt(Optional<Long> legalAcceptedAt) {
        Utils.checkNotNull(legalAcceptedAt, "legalAcceptedAt");
        this.legalAcceptedAt = legalAcceptedAt;
        return this;
    }

    @Deprecated
    public SignUp withExternalAccount(SignUpExternalAccount externalAccount) {
        Utils.checkNotNull(externalAccount, "externalAccount");
        this.externalAccount = Optional.ofNullable(externalAccount);
        return this;
    }

    @Deprecated
    public SignUp withExternalAccount(Optional<? extends SignUpExternalAccount> externalAccount) {
        Utils.checkNotNull(externalAccount, "externalAccount");
        this.externalAccount = externalAccount;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignUp other = (SignUp)o;
        return Objects.deepEquals((Object)this.object, (Object)other.object) && Objects.deepEquals(this.id, other.id) && Objects.deepEquals((Object)this.status, (Object)other.status) && Objects.deepEquals(this.requiredFields, other.requiredFields) && Objects.deepEquals(this.optionalFields, other.optionalFields) && Objects.deepEquals(this.missingFields, other.missingFields) && Objects.deepEquals(this.unverifiedFields, other.unverifiedFields) && Objects.deepEquals(this.verifications, other.verifications) && Objects.deepEquals(this.username, other.username) && Objects.deepEquals(this.emailAddress, other.emailAddress) && Objects.deepEquals(this.phoneNumber, other.phoneNumber) && Objects.deepEquals(this.web3Wallet, other.web3Wallet) && Objects.deepEquals(this.passwordEnabled, other.passwordEnabled) && Objects.deepEquals(this.firstName, other.firstName) && Objects.deepEquals(this.lastName, other.lastName) && Objects.deepEquals(this.unsafeMetadata, other.unsafeMetadata) && Objects.deepEquals(this.publicMetadata, other.publicMetadata) && Objects.deepEquals(this.customAction, other.customAction) && Objects.deepEquals(this.externalId, other.externalId) && Objects.deepEquals(this.createdSessionId, other.createdSessionId) && Objects.deepEquals(this.createdUserId, other.createdUserId) && Objects.deepEquals(this.abandonAt, other.abandonAt) && Objects.deepEquals(this.legalAcceptedAt, other.legalAcceptedAt) && Objects.deepEquals(this.externalAccount, other.externalAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.object, this.id, this.status, this.requiredFields, this.optionalFields, this.missingFields, this.unverifiedFields, this.verifications, this.username, this.emailAddress, this.phoneNumber, this.web3Wallet, this.passwordEnabled, this.firstName, this.lastName, this.unsafeMetadata, this.publicMetadata, this.customAction, this.externalId, this.createdSessionId, this.createdUserId, this.abandonAt, this.legalAcceptedAt, this.externalAccount});
    }

    public String toString() {
        return Utils.toString(SignUp.class, new Object[]{"object", this.object, "id", this.id, "status", this.status, "requiredFields", this.requiredFields, "optionalFields", this.optionalFields, "missingFields", this.missingFields, "unverifiedFields", this.unverifiedFields, "verifications", this.verifications, "username", this.username, "emailAddress", this.emailAddress, "phoneNumber", this.phoneNumber, "web3Wallet", this.web3Wallet, "passwordEnabled", this.passwordEnabled, "firstName", this.firstName, "lastName", this.lastName, "unsafeMetadata", this.unsafeMetadata, "publicMetadata", this.publicMetadata, "customAction", this.customAction, "externalId", this.externalId, "createdSessionId", this.createdSessionId, "createdUserId", this.createdUserId, "abandonAt", this.abandonAt, "legalAcceptedAt", this.legalAcceptedAt, "externalAccount", this.externalAccount});
    }

    public static final class Builder {
        private SignUpObject object;
        private String id;
        private SignUpStatus status;
        private List<String> requiredFields;
        private List<String> optionalFields;
        private List<String> missingFields;
        private List<String> unverifiedFields;
        private SignUpVerifications verifications;
        private Optional<String> username = Optional.empty();
        private Optional<String> emailAddress = Optional.empty();
        private Optional<String> phoneNumber = Optional.empty();
        private Optional<String> web3Wallet = Optional.empty();
        private Boolean passwordEnabled;
        private Optional<String> firstName = Optional.empty();
        private Optional<String> lastName = Optional.empty();
        private Optional<? extends Map<String, Object>> unsafeMetadata = Optional.empty();
        private Optional<? extends Map<String, Object>> publicMetadata = Optional.empty();
        private Boolean customAction;
        private Optional<String> externalId = Optional.empty();
        private Optional<String> createdSessionId = Optional.empty();
        private Optional<String> createdUserId = Optional.empty();
        private Long abandonAt;
        private Optional<Long> legalAcceptedAt = Optional.empty();
        @Deprecated
        private Optional<? extends SignUpExternalAccount> externalAccount = Optional.empty();

        private Builder() {
        }

        public Builder object(SignUpObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder status(SignUpStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder requiredFields(List<String> requiredFields) {
            Utils.checkNotNull(requiredFields, "requiredFields");
            this.requiredFields = requiredFields;
            return this;
        }

        public Builder optionalFields(List<String> optionalFields) {
            Utils.checkNotNull(optionalFields, "optionalFields");
            this.optionalFields = optionalFields;
            return this;
        }

        public Builder missingFields(List<String> missingFields) {
            Utils.checkNotNull(missingFields, "missingFields");
            this.missingFields = missingFields;
            return this;
        }

        public Builder unverifiedFields(List<String> unverifiedFields) {
            Utils.checkNotNull(unverifiedFields, "unverifiedFields");
            this.unverifiedFields = unverifiedFields;
            return this;
        }

        public Builder verifications(SignUpVerifications verifications) {
            Utils.checkNotNull(verifications, "verifications");
            this.verifications = verifications;
            return this;
        }

        public Builder username(String username) {
            Utils.checkNotNull(username, "username");
            this.username = Optional.ofNullable(username);
            return this;
        }

        public Builder username(Optional<String> username) {
            Utils.checkNotNull(username, "username");
            this.username = username;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            Utils.checkNotNull(emailAddress, "emailAddress");
            this.emailAddress = Optional.ofNullable(emailAddress);
            return this;
        }

        public Builder emailAddress(Optional<String> emailAddress) {
            Utils.checkNotNull(emailAddress, "emailAddress");
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            Utils.checkNotNull(phoneNumber, "phoneNumber");
            this.phoneNumber = Optional.ofNullable(phoneNumber);
            return this;
        }

        public Builder phoneNumber(Optional<String> phoneNumber) {
            Utils.checkNotNull(phoneNumber, "phoneNumber");
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder web3Wallet(String web3Wallet) {
            Utils.checkNotNull(web3Wallet, "web3Wallet");
            this.web3Wallet = Optional.ofNullable(web3Wallet);
            return this;
        }

        public Builder web3Wallet(Optional<String> web3Wallet) {
            Utils.checkNotNull(web3Wallet, "web3Wallet");
            this.web3Wallet = web3Wallet;
            return this;
        }

        public Builder passwordEnabled(boolean passwordEnabled) {
            Utils.checkNotNull(passwordEnabled, "passwordEnabled");
            this.passwordEnabled = passwordEnabled;
            return this;
        }

        public Builder firstName(String firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = Optional.ofNullable(firstName);
            return this;
        }

        public Builder firstName(Optional<String> firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = Optional.ofNullable(lastName);
            return this;
        }

        public Builder lastName(Optional<String> lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = lastName;
            return this;
        }

        public Builder unsafeMetadata(Map<String, Object> unsafeMetadata) {
            Utils.checkNotNull(unsafeMetadata, "unsafeMetadata");
            this.unsafeMetadata = Optional.ofNullable(unsafeMetadata);
            return this;
        }

        public Builder unsafeMetadata(Optional<? extends Map<String, Object>> unsafeMetadata) {
            Utils.checkNotNull(unsafeMetadata, "unsafeMetadata");
            this.unsafeMetadata = unsafeMetadata;
            return this;
        }

        public Builder publicMetadata(Map<String, Object> publicMetadata) {
            Utils.checkNotNull(publicMetadata, "publicMetadata");
            this.publicMetadata = Optional.ofNullable(publicMetadata);
            return this;
        }

        public Builder publicMetadata(Optional<? extends Map<String, Object>> publicMetadata) {
            Utils.checkNotNull(publicMetadata, "publicMetadata");
            this.publicMetadata = publicMetadata;
            return this;
        }

        public Builder customAction(boolean customAction) {
            Utils.checkNotNull(customAction, "customAction");
            this.customAction = customAction;
            return this;
        }

        public Builder externalId(String externalId) {
            Utils.checkNotNull(externalId, "externalId");
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        public Builder externalId(Optional<String> externalId) {
            Utils.checkNotNull(externalId, "externalId");
            this.externalId = externalId;
            return this;
        }

        public Builder createdSessionId(String createdSessionId) {
            Utils.checkNotNull(createdSessionId, "createdSessionId");
            this.createdSessionId = Optional.ofNullable(createdSessionId);
            return this;
        }

        public Builder createdSessionId(Optional<String> createdSessionId) {
            Utils.checkNotNull(createdSessionId, "createdSessionId");
            this.createdSessionId = createdSessionId;
            return this;
        }

        public Builder createdUserId(String createdUserId) {
            Utils.checkNotNull(createdUserId, "createdUserId");
            this.createdUserId = Optional.ofNullable(createdUserId);
            return this;
        }

        public Builder createdUserId(Optional<String> createdUserId) {
            Utils.checkNotNull(createdUserId, "createdUserId");
            this.createdUserId = createdUserId;
            return this;
        }

        public Builder abandonAt(long abandonAt) {
            Utils.checkNotNull(abandonAt, "abandonAt");
            this.abandonAt = abandonAt;
            return this;
        }

        public Builder legalAcceptedAt(long legalAcceptedAt) {
            Utils.checkNotNull(legalAcceptedAt, "legalAcceptedAt");
            this.legalAcceptedAt = Optional.ofNullable(legalAcceptedAt);
            return this;
        }

        public Builder legalAcceptedAt(Optional<Long> legalAcceptedAt) {
            Utils.checkNotNull(legalAcceptedAt, "legalAcceptedAt");
            this.legalAcceptedAt = legalAcceptedAt;
            return this;
        }

        @Deprecated
        public Builder externalAccount(SignUpExternalAccount externalAccount) {
            Utils.checkNotNull(externalAccount, "externalAccount");
            this.externalAccount = Optional.ofNullable(externalAccount);
            return this;
        }

        @Deprecated
        public Builder externalAccount(Optional<? extends SignUpExternalAccount> externalAccount) {
            Utils.checkNotNull(externalAccount, "externalAccount");
            this.externalAccount = externalAccount;
            return this;
        }

        public SignUp build() {
            return new SignUp(this.object, this.id, this.status, this.requiredFields, this.optionalFields, this.missingFields, this.unverifiedFields, this.verifications, this.username, this.emailAddress, this.phoneNumber, this.web3Wallet, this.passwordEnabled, this.firstName, this.lastName, this.unsafeMetadata, this.publicMetadata, this.customAction, this.externalId, this.createdSessionId, this.createdUserId, this.abandonAt, this.legalAcceptedAt, this.externalAccount);
        }
    }
}

