/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.EmailAddress;
import com.clerk.backend_api.models.components.ExternalAccountWithVerification;
import com.clerk.backend_api.models.components.PhoneNumber;
import com.clerk.backend_api.models.components.SAMLAccount;
import com.clerk.backend_api.models.components.SchemasPasskey;
import com.clerk.backend_api.models.components.UserObject;
import com.clerk.backend_api.models.components.Web3Wallet;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class User {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private Optional<String> id;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="object")
    private Optional<? extends UserObject> object;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="external_id")
    private JsonNullable<String> externalId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="primary_email_address_id")
    private JsonNullable<String> primaryEmailAddressId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="primary_phone_number_id")
    private JsonNullable<String> primaryPhoneNumberId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="primary_web3_wallet_id")
    private JsonNullable<String> primaryWeb3WalletId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="username")
    private JsonNullable<String> username;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="first_name")
    private JsonNullable<String> firstName;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="last_name")
    private JsonNullable<String> lastName;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="profile_image_url")
    @Deprecated
    private Optional<String> profileImageUrl;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="image_url")
    private Optional<String> imageUrl;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="has_image")
    private Optional<Boolean> hasImage;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="public_metadata")
    private Optional<? extends Map<String, Object>> publicMetadata;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="private_metadata")
    private JsonNullable<? extends Map<String, Object>> privateMetadata;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="unsafe_metadata")
    private Optional<? extends Map<String, Object>> unsafeMetadata;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="email_addresses")
    private Optional<? extends List<EmailAddress>> emailAddresses;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="phone_numbers")
    private Optional<? extends List<PhoneNumber>> phoneNumbers;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="web3_wallets")
    private Optional<? extends List<Web3Wallet>> web3Wallets;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="passkeys")
    private Optional<? extends List<SchemasPasskey>> passkeys;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="password_enabled")
    private Optional<Boolean> passwordEnabled;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="two_factor_enabled")
    private Optional<Boolean> twoFactorEnabled;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="totp_enabled")
    private Optional<Boolean> totpEnabled;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="backup_code_enabled")
    private Optional<Boolean> backupCodeEnabled;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="mfa_enabled_at")
    private JsonNullable<Long> mfaEnabledAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="mfa_disabled_at")
    private JsonNullable<Long> mfaDisabledAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="external_accounts")
    private Optional<? extends List<ExternalAccountWithVerification>> externalAccounts;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="saml_accounts")
    private Optional<? extends List<SAMLAccount>> samlAccounts;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="last_sign_in_at")
    private JsonNullable<Long> lastSignInAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="banned")
    private Optional<Boolean> banned;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="locked")
    private Optional<Boolean> locked;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="lockout_expires_in_seconds")
    private JsonNullable<Long> lockoutExpiresInSeconds;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="verification_attempts_remaining")
    private JsonNullable<Long> verificationAttemptsRemaining;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="updated_at")
    private Optional<Long> updatedAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="created_at")
    private Optional<Long> createdAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="delete_self_enabled")
    private Optional<Boolean> deleteSelfEnabled;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="create_organization_enabled")
    private Optional<Boolean> createOrganizationEnabled;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="create_organizations_limit")
    private JsonNullable<Long> createOrganizationsLimit;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="last_active_at")
    private JsonNullable<Long> lastActiveAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="legal_accepted_at")
    private JsonNullable<Long> legalAcceptedAt;

    @JsonCreator
    public User(@JsonProperty(value="id") Optional<String> id, @JsonProperty(value="object") Optional<? extends UserObject> object, @JsonProperty(value="external_id") JsonNullable<String> externalId, @JsonProperty(value="primary_email_address_id") JsonNullable<String> primaryEmailAddressId, @JsonProperty(value="primary_phone_number_id") JsonNullable<String> primaryPhoneNumberId, @JsonProperty(value="primary_web3_wallet_id") JsonNullable<String> primaryWeb3WalletId, @JsonProperty(value="username") JsonNullable<String> username, @JsonProperty(value="first_name") JsonNullable<String> firstName, @JsonProperty(value="last_name") JsonNullable<String> lastName, @JsonProperty(value="profile_image_url") Optional<String> profileImageUrl, @JsonProperty(value="image_url") Optional<String> imageUrl, @JsonProperty(value="has_image") Optional<Boolean> hasImage, @JsonProperty(value="public_metadata") Optional<? extends Map<String, Object>> publicMetadata, @JsonProperty(value="private_metadata") JsonNullable<? extends Map<String, Object>> privateMetadata, @JsonProperty(value="unsafe_metadata") Optional<? extends Map<String, Object>> unsafeMetadata, @JsonProperty(value="email_addresses") Optional<? extends List<EmailAddress>> emailAddresses, @JsonProperty(value="phone_numbers") Optional<? extends List<PhoneNumber>> phoneNumbers, @JsonProperty(value="web3_wallets") Optional<? extends List<Web3Wallet>> web3Wallets, @JsonProperty(value="passkeys") Optional<? extends List<SchemasPasskey>> passkeys, @JsonProperty(value="password_enabled") Optional<Boolean> passwordEnabled, @JsonProperty(value="two_factor_enabled") Optional<Boolean> twoFactorEnabled, @JsonProperty(value="totp_enabled") Optional<Boolean> totpEnabled, @JsonProperty(value="backup_code_enabled") Optional<Boolean> backupCodeEnabled, @JsonProperty(value="mfa_enabled_at") JsonNullable<Long> mfaEnabledAt, @JsonProperty(value="mfa_disabled_at") JsonNullable<Long> mfaDisabledAt, @JsonProperty(value="external_accounts") Optional<? extends List<ExternalAccountWithVerification>> externalAccounts, @JsonProperty(value="saml_accounts") Optional<? extends List<SAMLAccount>> samlAccounts, @JsonProperty(value="last_sign_in_at") JsonNullable<Long> lastSignInAt, @JsonProperty(value="banned") Optional<Boolean> banned, @JsonProperty(value="locked") Optional<Boolean> locked, @JsonProperty(value="lockout_expires_in_seconds") JsonNullable<Long> lockoutExpiresInSeconds, @JsonProperty(value="verification_attempts_remaining") JsonNullable<Long> verificationAttemptsRemaining, @JsonProperty(value="updated_at") Optional<Long> updatedAt, @JsonProperty(value="created_at") Optional<Long> createdAt, @JsonProperty(value="delete_self_enabled") Optional<Boolean> deleteSelfEnabled, @JsonProperty(value="create_organization_enabled") Optional<Boolean> createOrganizationEnabled, @JsonProperty(value="create_organizations_limit") JsonNullable<Long> createOrganizationsLimit, @JsonProperty(value="last_active_at") JsonNullable<Long> lastActiveAt, @JsonProperty(value="legal_accepted_at") JsonNullable<Long> legalAcceptedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(externalId, "externalId");
        Utils.checkNotNull(primaryEmailAddressId, "primaryEmailAddressId");
        Utils.checkNotNull(primaryPhoneNumberId, "primaryPhoneNumberId");
        Utils.checkNotNull(primaryWeb3WalletId, "primaryWeb3WalletId");
        Utils.checkNotNull(username, "username");
        Utils.checkNotNull(firstName, "firstName");
        Utils.checkNotNull(lastName, "lastName");
        Utils.checkNotNull(profileImageUrl, "profileImageUrl");
        Utils.checkNotNull(imageUrl, "imageUrl");
        Utils.checkNotNull(hasImage, "hasImage");
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        Utils.checkNotNull(privateMetadata, "privateMetadata");
        Utils.checkNotNull(unsafeMetadata, "unsafeMetadata");
        Utils.checkNotNull(emailAddresses, "emailAddresses");
        Utils.checkNotNull(phoneNumbers, "phoneNumbers");
        Utils.checkNotNull(web3Wallets, "web3Wallets");
        Utils.checkNotNull(passkeys, "passkeys");
        Utils.checkNotNull(passwordEnabled, "passwordEnabled");
        Utils.checkNotNull(twoFactorEnabled, "twoFactorEnabled");
        Utils.checkNotNull(totpEnabled, "totpEnabled");
        Utils.checkNotNull(backupCodeEnabled, "backupCodeEnabled");
        Utils.checkNotNull(mfaEnabledAt, "mfaEnabledAt");
        Utils.checkNotNull(mfaDisabledAt, "mfaDisabledAt");
        Utils.checkNotNull(externalAccounts, "externalAccounts");
        Utils.checkNotNull(samlAccounts, "samlAccounts");
        Utils.checkNotNull(lastSignInAt, "lastSignInAt");
        Utils.checkNotNull(banned, "banned");
        Utils.checkNotNull(locked, "locked");
        Utils.checkNotNull(lockoutExpiresInSeconds, "lockoutExpiresInSeconds");
        Utils.checkNotNull(verificationAttemptsRemaining, "verificationAttemptsRemaining");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(deleteSelfEnabled, "deleteSelfEnabled");
        Utils.checkNotNull(createOrganizationEnabled, "createOrganizationEnabled");
        Utils.checkNotNull(createOrganizationsLimit, "createOrganizationsLimit");
        Utils.checkNotNull(lastActiveAt, "lastActiveAt");
        Utils.checkNotNull(legalAcceptedAt, "legalAcceptedAt");
        this.id = id;
        this.object = object;
        this.externalId = externalId;
        this.primaryEmailAddressId = primaryEmailAddressId;
        this.primaryPhoneNumberId = primaryPhoneNumberId;
        this.primaryWeb3WalletId = primaryWeb3WalletId;
        this.username = username;
        this.firstName = firstName;
        this.lastName = lastName;
        this.profileImageUrl = profileImageUrl;
        this.imageUrl = imageUrl;
        this.hasImage = hasImage;
        this.publicMetadata = publicMetadata;
        this.privateMetadata = privateMetadata;
        this.unsafeMetadata = unsafeMetadata;
        this.emailAddresses = emailAddresses;
        this.phoneNumbers = phoneNumbers;
        this.web3Wallets = web3Wallets;
        this.passkeys = passkeys;
        this.passwordEnabled = passwordEnabled;
        this.twoFactorEnabled = twoFactorEnabled;
        this.totpEnabled = totpEnabled;
        this.backupCodeEnabled = backupCodeEnabled;
        this.mfaEnabledAt = mfaEnabledAt;
        this.mfaDisabledAt = mfaDisabledAt;
        this.externalAccounts = externalAccounts;
        this.samlAccounts = samlAccounts;
        this.lastSignInAt = lastSignInAt;
        this.banned = banned;
        this.locked = locked;
        this.lockoutExpiresInSeconds = lockoutExpiresInSeconds;
        this.verificationAttemptsRemaining = verificationAttemptsRemaining;
        this.updatedAt = updatedAt;
        this.createdAt = createdAt;
        this.deleteSelfEnabled = deleteSelfEnabled;
        this.createOrganizationEnabled = createOrganizationEnabled;
        this.createOrganizationsLimit = createOrganizationsLimit;
        this.lastActiveAt = lastActiveAt;
        this.legalAcceptedAt = legalAcceptedAt;
    }

    public User() {
        this(Optional.empty(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (JsonNullable<? extends Map<String, Object>>)JsonNullable.undefined(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (JsonNullable<Long>)JsonNullable.undefined(), (JsonNullable<Long>)JsonNullable.undefined(), Optional.empty(), Optional.empty(), (JsonNullable<Long>)JsonNullable.undefined(), Optional.empty(), Optional.empty(), (JsonNullable<Long>)JsonNullable.undefined(), (JsonNullable<Long>)JsonNullable.undefined(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (JsonNullable<Long>)JsonNullable.undefined(), (JsonNullable<Long>)JsonNullable.undefined(), (JsonNullable<Long>)JsonNullable.undefined());
    }

    @JsonIgnore
    public Optional<String> id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<UserObject> object() {
        return this.object;
    }

    @JsonIgnore
    public JsonNullable<String> externalId() {
        return this.externalId;
    }

    @JsonIgnore
    public JsonNullable<String> primaryEmailAddressId() {
        return this.primaryEmailAddressId;
    }

    @JsonIgnore
    public JsonNullable<String> primaryPhoneNumberId() {
        return this.primaryPhoneNumberId;
    }

    @JsonIgnore
    public JsonNullable<String> primaryWeb3WalletId() {
        return this.primaryWeb3WalletId;
    }

    @JsonIgnore
    public JsonNullable<String> username() {
        return this.username;
    }

    @JsonIgnore
    public JsonNullable<String> firstName() {
        return this.firstName;
    }

    @JsonIgnore
    public JsonNullable<String> lastName() {
        return this.lastName;
    }

    @Deprecated
    @JsonIgnore
    public Optional<String> profileImageUrl() {
        return this.profileImageUrl;
    }

    @JsonIgnore
    public Optional<String> imageUrl() {
        return this.imageUrl;
    }

    @JsonIgnore
    public Optional<Boolean> hasImage() {
        return this.hasImage;
    }

    @JsonIgnore
    public Optional<Map<String, Object>> publicMetadata() {
        return this.publicMetadata;
    }

    @JsonIgnore
    public JsonNullable<Map<String, Object>> privateMetadata() {
        return this.privateMetadata;
    }

    @JsonIgnore
    public Optional<Map<String, Object>> unsafeMetadata() {
        return this.unsafeMetadata;
    }

    @JsonIgnore
    public Optional<List<EmailAddress>> emailAddresses() {
        return this.emailAddresses;
    }

    @JsonIgnore
    public Optional<List<PhoneNumber>> phoneNumbers() {
        return this.phoneNumbers;
    }

    @JsonIgnore
    public Optional<List<Web3Wallet>> web3Wallets() {
        return this.web3Wallets;
    }

    @JsonIgnore
    public Optional<List<SchemasPasskey>> passkeys() {
        return this.passkeys;
    }

    @JsonIgnore
    public Optional<Boolean> passwordEnabled() {
        return this.passwordEnabled;
    }

    @JsonIgnore
    public Optional<Boolean> twoFactorEnabled() {
        return this.twoFactorEnabled;
    }

    @JsonIgnore
    public Optional<Boolean> totpEnabled() {
        return this.totpEnabled;
    }

    @JsonIgnore
    public Optional<Boolean> backupCodeEnabled() {
        return this.backupCodeEnabled;
    }

    @JsonIgnore
    public JsonNullable<Long> mfaEnabledAt() {
        return this.mfaEnabledAt;
    }

    @JsonIgnore
    public JsonNullable<Long> mfaDisabledAt() {
        return this.mfaDisabledAt;
    }

    @JsonIgnore
    public Optional<List<ExternalAccountWithVerification>> externalAccounts() {
        return this.externalAccounts;
    }

    @JsonIgnore
    public Optional<List<SAMLAccount>> samlAccounts() {
        return this.samlAccounts;
    }

    @JsonIgnore
    public JsonNullable<Long> lastSignInAt() {
        return this.lastSignInAt;
    }

    @JsonIgnore
    public Optional<Boolean> banned() {
        return this.banned;
    }

    @JsonIgnore
    public Optional<Boolean> locked() {
        return this.locked;
    }

    @JsonIgnore
    public JsonNullable<Long> lockoutExpiresInSeconds() {
        return this.lockoutExpiresInSeconds;
    }

    @JsonIgnore
    public JsonNullable<Long> verificationAttemptsRemaining() {
        return this.verificationAttemptsRemaining;
    }

    @JsonIgnore
    public Optional<Long> updatedAt() {
        return this.updatedAt;
    }

    @JsonIgnore
    public Optional<Long> createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public Optional<Boolean> deleteSelfEnabled() {
        return this.deleteSelfEnabled;
    }

    @JsonIgnore
    public Optional<Boolean> createOrganizationEnabled() {
        return this.createOrganizationEnabled;
    }

    @JsonIgnore
    public JsonNullable<Long> createOrganizationsLimit() {
        return this.createOrganizationsLimit;
    }

    @JsonIgnore
    public JsonNullable<Long> lastActiveAt() {
        return this.lastActiveAt;
    }

    @JsonIgnore
    public JsonNullable<Long> legalAcceptedAt() {
        return this.legalAcceptedAt;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public User withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = Optional.ofNullable(id);
        return this;
    }

    public User withId(Optional<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public User withObject(UserObject object) {
        Utils.checkNotNull(object, "object");
        this.object = Optional.ofNullable(object);
        return this;
    }

    public User withObject(Optional<? extends UserObject> object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public User withExternalId(String externalId) {
        Utils.checkNotNull(externalId, "externalId");
        this.externalId = JsonNullable.of((Object)externalId);
        return this;
    }

    public User withExternalId(JsonNullable<String> externalId) {
        Utils.checkNotNull(externalId, "externalId");
        this.externalId = externalId;
        return this;
    }

    public User withPrimaryEmailAddressId(String primaryEmailAddressId) {
        Utils.checkNotNull(primaryEmailAddressId, "primaryEmailAddressId");
        this.primaryEmailAddressId = JsonNullable.of((Object)primaryEmailAddressId);
        return this;
    }

    public User withPrimaryEmailAddressId(JsonNullable<String> primaryEmailAddressId) {
        Utils.checkNotNull(primaryEmailAddressId, "primaryEmailAddressId");
        this.primaryEmailAddressId = primaryEmailAddressId;
        return this;
    }

    public User withPrimaryPhoneNumberId(String primaryPhoneNumberId) {
        Utils.checkNotNull(primaryPhoneNumberId, "primaryPhoneNumberId");
        this.primaryPhoneNumberId = JsonNullable.of((Object)primaryPhoneNumberId);
        return this;
    }

    public User withPrimaryPhoneNumberId(JsonNullable<String> primaryPhoneNumberId) {
        Utils.checkNotNull(primaryPhoneNumberId, "primaryPhoneNumberId");
        this.primaryPhoneNumberId = primaryPhoneNumberId;
        return this;
    }

    public User withPrimaryWeb3WalletId(String primaryWeb3WalletId) {
        Utils.checkNotNull(primaryWeb3WalletId, "primaryWeb3WalletId");
        this.primaryWeb3WalletId = JsonNullable.of((Object)primaryWeb3WalletId);
        return this;
    }

    public User withPrimaryWeb3WalletId(JsonNullable<String> primaryWeb3WalletId) {
        Utils.checkNotNull(primaryWeb3WalletId, "primaryWeb3WalletId");
        this.primaryWeb3WalletId = primaryWeb3WalletId;
        return this;
    }

    public User withUsername(String username) {
        Utils.checkNotNull(username, "username");
        this.username = JsonNullable.of((Object)username);
        return this;
    }

    public User withUsername(JsonNullable<String> username) {
        Utils.checkNotNull(username, "username");
        this.username = username;
        return this;
    }

    public User withFirstName(String firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = JsonNullable.of((Object)firstName);
        return this;
    }

    public User withFirstName(JsonNullable<String> firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = firstName;
        return this;
    }

    public User withLastName(String lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = JsonNullable.of((Object)lastName);
        return this;
    }

    public User withLastName(JsonNullable<String> lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = lastName;
        return this;
    }

    @Deprecated
    public User withProfileImageUrl(String profileImageUrl) {
        Utils.checkNotNull(profileImageUrl, "profileImageUrl");
        this.profileImageUrl = Optional.ofNullable(profileImageUrl);
        return this;
    }

    @Deprecated
    public User withProfileImageUrl(Optional<String> profileImageUrl) {
        Utils.checkNotNull(profileImageUrl, "profileImageUrl");
        this.profileImageUrl = profileImageUrl;
        return this;
    }

    public User withImageUrl(String imageUrl) {
        Utils.checkNotNull(imageUrl, "imageUrl");
        this.imageUrl = Optional.ofNullable(imageUrl);
        return this;
    }

    public User withImageUrl(Optional<String> imageUrl) {
        Utils.checkNotNull(imageUrl, "imageUrl");
        this.imageUrl = imageUrl;
        return this;
    }

    public User withHasImage(boolean hasImage) {
        Utils.checkNotNull(hasImage, "hasImage");
        this.hasImage = Optional.ofNullable(hasImage);
        return this;
    }

    public User withHasImage(Optional<Boolean> hasImage) {
        Utils.checkNotNull(hasImage, "hasImage");
        this.hasImage = hasImage;
        return this;
    }

    public User withPublicMetadata(Map<String, Object> publicMetadata) {
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        this.publicMetadata = Optional.ofNullable(publicMetadata);
        return this;
    }

    public User withPublicMetadata(Optional<? extends Map<String, Object>> publicMetadata) {
        Utils.checkNotNull(publicMetadata, "publicMetadata");
        this.publicMetadata = publicMetadata;
        return this;
    }

    public User withPrivateMetadata(Map<String, Object> privateMetadata) {
        Utils.checkNotNull(privateMetadata, "privateMetadata");
        this.privateMetadata = JsonNullable.of(privateMetadata);
        return this;
    }

    public User withPrivateMetadata(JsonNullable<? extends Map<String, Object>> privateMetadata) {
        Utils.checkNotNull(privateMetadata, "privateMetadata");
        this.privateMetadata = privateMetadata;
        return this;
    }

    public User withUnsafeMetadata(Map<String, Object> unsafeMetadata) {
        Utils.checkNotNull(unsafeMetadata, "unsafeMetadata");
        this.unsafeMetadata = Optional.ofNullable(unsafeMetadata);
        return this;
    }

    public User withUnsafeMetadata(Optional<? extends Map<String, Object>> unsafeMetadata) {
        Utils.checkNotNull(unsafeMetadata, "unsafeMetadata");
        this.unsafeMetadata = unsafeMetadata;
        return this;
    }

    public User withEmailAddresses(List<EmailAddress> emailAddresses) {
        Utils.checkNotNull(emailAddresses, "emailAddresses");
        this.emailAddresses = Optional.ofNullable(emailAddresses);
        return this;
    }

    public User withEmailAddresses(Optional<? extends List<EmailAddress>> emailAddresses) {
        Utils.checkNotNull(emailAddresses, "emailAddresses");
        this.emailAddresses = emailAddresses;
        return this;
    }

    public User withPhoneNumbers(List<PhoneNumber> phoneNumbers) {
        Utils.checkNotNull(phoneNumbers, "phoneNumbers");
        this.phoneNumbers = Optional.ofNullable(phoneNumbers);
        return this;
    }

    public User withPhoneNumbers(Optional<? extends List<PhoneNumber>> phoneNumbers) {
        Utils.checkNotNull(phoneNumbers, "phoneNumbers");
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    public User withWeb3Wallets(List<Web3Wallet> web3Wallets) {
        Utils.checkNotNull(web3Wallets, "web3Wallets");
        this.web3Wallets = Optional.ofNullable(web3Wallets);
        return this;
    }

    public User withWeb3Wallets(Optional<? extends List<Web3Wallet>> web3Wallets) {
        Utils.checkNotNull(web3Wallets, "web3Wallets");
        this.web3Wallets = web3Wallets;
        return this;
    }

    public User withPasskeys(List<SchemasPasskey> passkeys) {
        Utils.checkNotNull(passkeys, "passkeys");
        this.passkeys = Optional.ofNullable(passkeys);
        return this;
    }

    public User withPasskeys(Optional<? extends List<SchemasPasskey>> passkeys) {
        Utils.checkNotNull(passkeys, "passkeys");
        this.passkeys = passkeys;
        return this;
    }

    public User withPasswordEnabled(boolean passwordEnabled) {
        Utils.checkNotNull(passwordEnabled, "passwordEnabled");
        this.passwordEnabled = Optional.ofNullable(passwordEnabled);
        return this;
    }

    public User withPasswordEnabled(Optional<Boolean> passwordEnabled) {
        Utils.checkNotNull(passwordEnabled, "passwordEnabled");
        this.passwordEnabled = passwordEnabled;
        return this;
    }

    public User withTwoFactorEnabled(boolean twoFactorEnabled) {
        Utils.checkNotNull(twoFactorEnabled, "twoFactorEnabled");
        this.twoFactorEnabled = Optional.ofNullable(twoFactorEnabled);
        return this;
    }

    public User withTwoFactorEnabled(Optional<Boolean> twoFactorEnabled) {
        Utils.checkNotNull(twoFactorEnabled, "twoFactorEnabled");
        this.twoFactorEnabled = twoFactorEnabled;
        return this;
    }

    public User withTotpEnabled(boolean totpEnabled) {
        Utils.checkNotNull(totpEnabled, "totpEnabled");
        this.totpEnabled = Optional.ofNullable(totpEnabled);
        return this;
    }

    public User withTotpEnabled(Optional<Boolean> totpEnabled) {
        Utils.checkNotNull(totpEnabled, "totpEnabled");
        this.totpEnabled = totpEnabled;
        return this;
    }

    public User withBackupCodeEnabled(boolean backupCodeEnabled) {
        Utils.checkNotNull(backupCodeEnabled, "backupCodeEnabled");
        this.backupCodeEnabled = Optional.ofNullable(backupCodeEnabled);
        return this;
    }

    public User withBackupCodeEnabled(Optional<Boolean> backupCodeEnabled) {
        Utils.checkNotNull(backupCodeEnabled, "backupCodeEnabled");
        this.backupCodeEnabled = backupCodeEnabled;
        return this;
    }

    public User withMfaEnabledAt(long mfaEnabledAt) {
        Utils.checkNotNull(mfaEnabledAt, "mfaEnabledAt");
        this.mfaEnabledAt = JsonNullable.of((Object)mfaEnabledAt);
        return this;
    }

    public User withMfaEnabledAt(JsonNullable<Long> mfaEnabledAt) {
        Utils.checkNotNull(mfaEnabledAt, "mfaEnabledAt");
        this.mfaEnabledAt = mfaEnabledAt;
        return this;
    }

    public User withMfaDisabledAt(long mfaDisabledAt) {
        Utils.checkNotNull(mfaDisabledAt, "mfaDisabledAt");
        this.mfaDisabledAt = JsonNullable.of((Object)mfaDisabledAt);
        return this;
    }

    public User withMfaDisabledAt(JsonNullable<Long> mfaDisabledAt) {
        Utils.checkNotNull(mfaDisabledAt, "mfaDisabledAt");
        this.mfaDisabledAt = mfaDisabledAt;
        return this;
    }

    public User withExternalAccounts(List<ExternalAccountWithVerification> externalAccounts) {
        Utils.checkNotNull(externalAccounts, "externalAccounts");
        this.externalAccounts = Optional.ofNullable(externalAccounts);
        return this;
    }

    public User withExternalAccounts(Optional<? extends List<ExternalAccountWithVerification>> externalAccounts) {
        Utils.checkNotNull(externalAccounts, "externalAccounts");
        this.externalAccounts = externalAccounts;
        return this;
    }

    public User withSamlAccounts(List<SAMLAccount> samlAccounts) {
        Utils.checkNotNull(samlAccounts, "samlAccounts");
        this.samlAccounts = Optional.ofNullable(samlAccounts);
        return this;
    }

    public User withSamlAccounts(Optional<? extends List<SAMLAccount>> samlAccounts) {
        Utils.checkNotNull(samlAccounts, "samlAccounts");
        this.samlAccounts = samlAccounts;
        return this;
    }

    public User withLastSignInAt(long lastSignInAt) {
        Utils.checkNotNull(lastSignInAt, "lastSignInAt");
        this.lastSignInAt = JsonNullable.of((Object)lastSignInAt);
        return this;
    }

    public User withLastSignInAt(JsonNullable<Long> lastSignInAt) {
        Utils.checkNotNull(lastSignInAt, "lastSignInAt");
        this.lastSignInAt = lastSignInAt;
        return this;
    }

    public User withBanned(boolean banned) {
        Utils.checkNotNull(banned, "banned");
        this.banned = Optional.ofNullable(banned);
        return this;
    }

    public User withBanned(Optional<Boolean> banned) {
        Utils.checkNotNull(banned, "banned");
        this.banned = banned;
        return this;
    }

    public User withLocked(boolean locked) {
        Utils.checkNotNull(locked, "locked");
        this.locked = Optional.ofNullable(locked);
        return this;
    }

    public User withLocked(Optional<Boolean> locked) {
        Utils.checkNotNull(locked, "locked");
        this.locked = locked;
        return this;
    }

    public User withLockoutExpiresInSeconds(long lockoutExpiresInSeconds) {
        Utils.checkNotNull(lockoutExpiresInSeconds, "lockoutExpiresInSeconds");
        this.lockoutExpiresInSeconds = JsonNullable.of((Object)lockoutExpiresInSeconds);
        return this;
    }

    public User withLockoutExpiresInSeconds(JsonNullable<Long> lockoutExpiresInSeconds) {
        Utils.checkNotNull(lockoutExpiresInSeconds, "lockoutExpiresInSeconds");
        this.lockoutExpiresInSeconds = lockoutExpiresInSeconds;
        return this;
    }

    public User withVerificationAttemptsRemaining(long verificationAttemptsRemaining) {
        Utils.checkNotNull(verificationAttemptsRemaining, "verificationAttemptsRemaining");
        this.verificationAttemptsRemaining = JsonNullable.of((Object)verificationAttemptsRemaining);
        return this;
    }

    public User withVerificationAttemptsRemaining(JsonNullable<Long> verificationAttemptsRemaining) {
        Utils.checkNotNull(verificationAttemptsRemaining, "verificationAttemptsRemaining");
        this.verificationAttemptsRemaining = verificationAttemptsRemaining;
        return this;
    }

    public User withUpdatedAt(long updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = Optional.ofNullable(updatedAt);
        return this;
    }

    public User withUpdatedAt(Optional<Long> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public User withCreatedAt(long createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = Optional.ofNullable(createdAt);
        return this;
    }

    public User withCreatedAt(Optional<Long> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public User withDeleteSelfEnabled(boolean deleteSelfEnabled) {
        Utils.checkNotNull(deleteSelfEnabled, "deleteSelfEnabled");
        this.deleteSelfEnabled = Optional.ofNullable(deleteSelfEnabled);
        return this;
    }

    public User withDeleteSelfEnabled(Optional<Boolean> deleteSelfEnabled) {
        Utils.checkNotNull(deleteSelfEnabled, "deleteSelfEnabled");
        this.deleteSelfEnabled = deleteSelfEnabled;
        return this;
    }

    public User withCreateOrganizationEnabled(boolean createOrganizationEnabled) {
        Utils.checkNotNull(createOrganizationEnabled, "createOrganizationEnabled");
        this.createOrganizationEnabled = Optional.ofNullable(createOrganizationEnabled);
        return this;
    }

    public User withCreateOrganizationEnabled(Optional<Boolean> createOrganizationEnabled) {
        Utils.checkNotNull(createOrganizationEnabled, "createOrganizationEnabled");
        this.createOrganizationEnabled = createOrganizationEnabled;
        return this;
    }

    public User withCreateOrganizationsLimit(long createOrganizationsLimit) {
        Utils.checkNotNull(createOrganizationsLimit, "createOrganizationsLimit");
        this.createOrganizationsLimit = JsonNullable.of((Object)createOrganizationsLimit);
        return this;
    }

    public User withCreateOrganizationsLimit(JsonNullable<Long> createOrganizationsLimit) {
        Utils.checkNotNull(createOrganizationsLimit, "createOrganizationsLimit");
        this.createOrganizationsLimit = createOrganizationsLimit;
        return this;
    }

    public User withLastActiveAt(long lastActiveAt) {
        Utils.checkNotNull(lastActiveAt, "lastActiveAt");
        this.lastActiveAt = JsonNullable.of((Object)lastActiveAt);
        return this;
    }

    public User withLastActiveAt(JsonNullable<Long> lastActiveAt) {
        Utils.checkNotNull(lastActiveAt, "lastActiveAt");
        this.lastActiveAt = lastActiveAt;
        return this;
    }

    public User withLegalAcceptedAt(long legalAcceptedAt) {
        Utils.checkNotNull(legalAcceptedAt, "legalAcceptedAt");
        this.legalAcceptedAt = JsonNullable.of((Object)legalAcceptedAt);
        return this;
    }

    public User withLegalAcceptedAt(JsonNullable<Long> legalAcceptedAt) {
        Utils.checkNotNull(legalAcceptedAt, "legalAcceptedAt");
        this.legalAcceptedAt = legalAcceptedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User other = (User)o;
        return Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.object, other.object) && Objects.deepEquals(this.externalId, other.externalId) && Objects.deepEquals(this.primaryEmailAddressId, other.primaryEmailAddressId) && Objects.deepEquals(this.primaryPhoneNumberId, other.primaryPhoneNumberId) && Objects.deepEquals(this.primaryWeb3WalletId, other.primaryWeb3WalletId) && Objects.deepEquals(this.username, other.username) && Objects.deepEquals(this.firstName, other.firstName) && Objects.deepEquals(this.lastName, other.lastName) && Objects.deepEquals(this.profileImageUrl, other.profileImageUrl) && Objects.deepEquals(this.imageUrl, other.imageUrl) && Objects.deepEquals(this.hasImage, other.hasImage) && Objects.deepEquals(this.publicMetadata, other.publicMetadata) && Objects.deepEquals(this.privateMetadata, other.privateMetadata) && Objects.deepEquals(this.unsafeMetadata, other.unsafeMetadata) && Objects.deepEquals(this.emailAddresses, other.emailAddresses) && Objects.deepEquals(this.phoneNumbers, other.phoneNumbers) && Objects.deepEquals(this.web3Wallets, other.web3Wallets) && Objects.deepEquals(this.passkeys, other.passkeys) && Objects.deepEquals(this.passwordEnabled, other.passwordEnabled) && Objects.deepEquals(this.twoFactorEnabled, other.twoFactorEnabled) && Objects.deepEquals(this.totpEnabled, other.totpEnabled) && Objects.deepEquals(this.backupCodeEnabled, other.backupCodeEnabled) && Objects.deepEquals(this.mfaEnabledAt, other.mfaEnabledAt) && Objects.deepEquals(this.mfaDisabledAt, other.mfaDisabledAt) && Objects.deepEquals(this.externalAccounts, other.externalAccounts) && Objects.deepEquals(this.samlAccounts, other.samlAccounts) && Objects.deepEquals(this.lastSignInAt, other.lastSignInAt) && Objects.deepEquals(this.banned, other.banned) && Objects.deepEquals(this.locked, other.locked) && Objects.deepEquals(this.lockoutExpiresInSeconds, other.lockoutExpiresInSeconds) && Objects.deepEquals(this.verificationAttemptsRemaining, other.verificationAttemptsRemaining) && Objects.deepEquals(this.updatedAt, other.updatedAt) && Objects.deepEquals(this.createdAt, other.createdAt) && Objects.deepEquals(this.deleteSelfEnabled, other.deleteSelfEnabled) && Objects.deepEquals(this.createOrganizationEnabled, other.createOrganizationEnabled) && Objects.deepEquals(this.createOrganizationsLimit, other.createOrganizationsLimit) && Objects.deepEquals(this.lastActiveAt, other.lastActiveAt) && Objects.deepEquals(this.legalAcceptedAt, other.legalAcceptedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.object, this.externalId, this.primaryEmailAddressId, this.primaryPhoneNumberId, this.primaryWeb3WalletId, this.username, this.firstName, this.lastName, this.profileImageUrl, this.imageUrl, this.hasImage, this.publicMetadata, this.privateMetadata, this.unsafeMetadata, this.emailAddresses, this.phoneNumbers, this.web3Wallets, this.passkeys, this.passwordEnabled, this.twoFactorEnabled, this.totpEnabled, this.backupCodeEnabled, this.mfaEnabledAt, this.mfaDisabledAt, this.externalAccounts, this.samlAccounts, this.lastSignInAt, this.banned, this.locked, this.lockoutExpiresInSeconds, this.verificationAttemptsRemaining, this.updatedAt, this.createdAt, this.deleteSelfEnabled, this.createOrganizationEnabled, this.createOrganizationsLimit, this.lastActiveAt, this.legalAcceptedAt);
    }

    public String toString() {
        return Utils.toString(User.class, "id", this.id, "object", this.object, "externalId", this.externalId, "primaryEmailAddressId", this.primaryEmailAddressId, "primaryPhoneNumberId", this.primaryPhoneNumberId, "primaryWeb3WalletId", this.primaryWeb3WalletId, "username", this.username, "firstName", this.firstName, "lastName", this.lastName, "profileImageUrl", this.profileImageUrl, "imageUrl", this.imageUrl, "hasImage", this.hasImage, "publicMetadata", this.publicMetadata, "privateMetadata", this.privateMetadata, "unsafeMetadata", this.unsafeMetadata, "emailAddresses", this.emailAddresses, "phoneNumbers", this.phoneNumbers, "web3Wallets", this.web3Wallets, "passkeys", this.passkeys, "passwordEnabled", this.passwordEnabled, "twoFactorEnabled", this.twoFactorEnabled, "totpEnabled", this.totpEnabled, "backupCodeEnabled", this.backupCodeEnabled, "mfaEnabledAt", this.mfaEnabledAt, "mfaDisabledAt", this.mfaDisabledAt, "externalAccounts", this.externalAccounts, "samlAccounts", this.samlAccounts, "lastSignInAt", this.lastSignInAt, "banned", this.banned, "locked", this.locked, "lockoutExpiresInSeconds", this.lockoutExpiresInSeconds, "verificationAttemptsRemaining", this.verificationAttemptsRemaining, "updatedAt", this.updatedAt, "createdAt", this.createdAt, "deleteSelfEnabled", this.deleteSelfEnabled, "createOrganizationEnabled", this.createOrganizationEnabled, "createOrganizationsLimit", this.createOrganizationsLimit, "lastActiveAt", this.lastActiveAt, "legalAcceptedAt", this.legalAcceptedAt);
    }

    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<? extends UserObject> object = Optional.empty();
        private JsonNullable<String> externalId = JsonNullable.undefined();
        private JsonNullable<String> primaryEmailAddressId = JsonNullable.undefined();
        private JsonNullable<String> primaryPhoneNumberId = JsonNullable.undefined();
        private JsonNullable<String> primaryWeb3WalletId = JsonNullable.undefined();
        private JsonNullable<String> username = JsonNullable.undefined();
        private JsonNullable<String> firstName = JsonNullable.undefined();
        private JsonNullable<String> lastName = JsonNullable.undefined();
        @Deprecated
        private Optional<String> profileImageUrl = Optional.empty();
        private Optional<String> imageUrl = Optional.empty();
        private Optional<Boolean> hasImage = Optional.empty();
        private Optional<? extends Map<String, Object>> publicMetadata = Optional.empty();
        private JsonNullable<? extends Map<String, Object>> privateMetadata = JsonNullable.undefined();
        private Optional<? extends Map<String, Object>> unsafeMetadata = Optional.empty();
        private Optional<? extends List<EmailAddress>> emailAddresses = Optional.empty();
        private Optional<? extends List<PhoneNumber>> phoneNumbers = Optional.empty();
        private Optional<? extends List<Web3Wallet>> web3Wallets = Optional.empty();
        private Optional<? extends List<SchemasPasskey>> passkeys = Optional.empty();
        private Optional<Boolean> passwordEnabled = Optional.empty();
        private Optional<Boolean> twoFactorEnabled = Optional.empty();
        private Optional<Boolean> totpEnabled = Optional.empty();
        private Optional<Boolean> backupCodeEnabled = Optional.empty();
        private JsonNullable<Long> mfaEnabledAt = JsonNullable.undefined();
        private JsonNullable<Long> mfaDisabledAt = JsonNullable.undefined();
        private Optional<? extends List<ExternalAccountWithVerification>> externalAccounts = Optional.empty();
        private Optional<? extends List<SAMLAccount>> samlAccounts = Optional.empty();
        private JsonNullable<Long> lastSignInAt = JsonNullable.undefined();
        private Optional<Boolean> banned = Optional.empty();
        private Optional<Boolean> locked = Optional.empty();
        private JsonNullable<Long> lockoutExpiresInSeconds = JsonNullable.undefined();
        private JsonNullable<Long> verificationAttemptsRemaining = JsonNullable.undefined();
        private Optional<Long> updatedAt = Optional.empty();
        private Optional<Long> createdAt = Optional.empty();
        private Optional<Boolean> deleteSelfEnabled = Optional.empty();
        private Optional<Boolean> createOrganizationEnabled = Optional.empty();
        private JsonNullable<Long> createOrganizationsLimit = JsonNullable.undefined();
        private JsonNullable<Long> lastActiveAt = JsonNullable.undefined();
        private JsonNullable<Long> legalAcceptedAt = JsonNullable.undefined();

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = Optional.ofNullable(id);
            return this;
        }

        public Builder id(Optional<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder object(UserObject object) {
            Utils.checkNotNull(object, "object");
            this.object = Optional.ofNullable(object);
            return this;
        }

        public Builder object(Optional<? extends UserObject> object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder externalId(String externalId) {
            Utils.checkNotNull(externalId, "externalId");
            this.externalId = JsonNullable.of((Object)externalId);
            return this;
        }

        public Builder externalId(JsonNullable<String> externalId) {
            Utils.checkNotNull(externalId, "externalId");
            this.externalId = externalId;
            return this;
        }

        public Builder primaryEmailAddressId(String primaryEmailAddressId) {
            Utils.checkNotNull(primaryEmailAddressId, "primaryEmailAddressId");
            this.primaryEmailAddressId = JsonNullable.of((Object)primaryEmailAddressId);
            return this;
        }

        public Builder primaryEmailAddressId(JsonNullable<String> primaryEmailAddressId) {
            Utils.checkNotNull(primaryEmailAddressId, "primaryEmailAddressId");
            this.primaryEmailAddressId = primaryEmailAddressId;
            return this;
        }

        public Builder primaryPhoneNumberId(String primaryPhoneNumberId) {
            Utils.checkNotNull(primaryPhoneNumberId, "primaryPhoneNumberId");
            this.primaryPhoneNumberId = JsonNullable.of((Object)primaryPhoneNumberId);
            return this;
        }

        public Builder primaryPhoneNumberId(JsonNullable<String> primaryPhoneNumberId) {
            Utils.checkNotNull(primaryPhoneNumberId, "primaryPhoneNumberId");
            this.primaryPhoneNumberId = primaryPhoneNumberId;
            return this;
        }

        public Builder primaryWeb3WalletId(String primaryWeb3WalletId) {
            Utils.checkNotNull(primaryWeb3WalletId, "primaryWeb3WalletId");
            this.primaryWeb3WalletId = JsonNullable.of((Object)primaryWeb3WalletId);
            return this;
        }

        public Builder primaryWeb3WalletId(JsonNullable<String> primaryWeb3WalletId) {
            Utils.checkNotNull(primaryWeb3WalletId, "primaryWeb3WalletId");
            this.primaryWeb3WalletId = primaryWeb3WalletId;
            return this;
        }

        public Builder username(String username) {
            Utils.checkNotNull(username, "username");
            this.username = JsonNullable.of((Object)username);
            return this;
        }

        public Builder username(JsonNullable<String> username) {
            Utils.checkNotNull(username, "username");
            this.username = username;
            return this;
        }

        public Builder firstName(String firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = JsonNullable.of((Object)firstName);
            return this;
        }

        public Builder firstName(JsonNullable<String> firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = JsonNullable.of((Object)lastName);
            return this;
        }

        public Builder lastName(JsonNullable<String> lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = lastName;
            return this;
        }

        @Deprecated
        public Builder profileImageUrl(String profileImageUrl) {
            Utils.checkNotNull(profileImageUrl, "profileImageUrl");
            this.profileImageUrl = Optional.ofNullable(profileImageUrl);
            return this;
        }

        @Deprecated
        public Builder profileImageUrl(Optional<String> profileImageUrl) {
            Utils.checkNotNull(profileImageUrl, "profileImageUrl");
            this.profileImageUrl = profileImageUrl;
            return this;
        }

        public Builder imageUrl(String imageUrl) {
            Utils.checkNotNull(imageUrl, "imageUrl");
            this.imageUrl = Optional.ofNullable(imageUrl);
            return this;
        }

        public Builder imageUrl(Optional<String> imageUrl) {
            Utils.checkNotNull(imageUrl, "imageUrl");
            this.imageUrl = imageUrl;
            return this;
        }

        public Builder hasImage(boolean hasImage) {
            Utils.checkNotNull(hasImage, "hasImage");
            this.hasImage = Optional.ofNullable(hasImage);
            return this;
        }

        public Builder hasImage(Optional<Boolean> hasImage) {
            Utils.checkNotNull(hasImage, "hasImage");
            this.hasImage = hasImage;
            return this;
        }

        public Builder publicMetadata(Map<String, Object> publicMetadata) {
            Utils.checkNotNull(publicMetadata, "publicMetadata");
            this.publicMetadata = Optional.ofNullable(publicMetadata);
            return this;
        }

        public Builder publicMetadata(Optional<? extends Map<String, Object>> publicMetadata) {
            Utils.checkNotNull(publicMetadata, "publicMetadata");
            this.publicMetadata = publicMetadata;
            return this;
        }

        public Builder privateMetadata(Map<String, Object> privateMetadata) {
            Utils.checkNotNull(privateMetadata, "privateMetadata");
            this.privateMetadata = JsonNullable.of(privateMetadata);
            return this;
        }

        public Builder privateMetadata(JsonNullable<? extends Map<String, Object>> privateMetadata) {
            Utils.checkNotNull(privateMetadata, "privateMetadata");
            this.privateMetadata = privateMetadata;
            return this;
        }

        public Builder unsafeMetadata(Map<String, Object> unsafeMetadata) {
            Utils.checkNotNull(unsafeMetadata, "unsafeMetadata");
            this.unsafeMetadata = Optional.ofNullable(unsafeMetadata);
            return this;
        }

        public Builder unsafeMetadata(Optional<? extends Map<String, Object>> unsafeMetadata) {
            Utils.checkNotNull(unsafeMetadata, "unsafeMetadata");
            this.unsafeMetadata = unsafeMetadata;
            return this;
        }

        public Builder emailAddresses(List<EmailAddress> emailAddresses) {
            Utils.checkNotNull(emailAddresses, "emailAddresses");
            this.emailAddresses = Optional.ofNullable(emailAddresses);
            return this;
        }

        public Builder emailAddresses(Optional<? extends List<EmailAddress>> emailAddresses) {
            Utils.checkNotNull(emailAddresses, "emailAddresses");
            this.emailAddresses = emailAddresses;
            return this;
        }

        public Builder phoneNumbers(List<PhoneNumber> phoneNumbers) {
            Utils.checkNotNull(phoneNumbers, "phoneNumbers");
            this.phoneNumbers = Optional.ofNullable(phoneNumbers);
            return this;
        }

        public Builder phoneNumbers(Optional<? extends List<PhoneNumber>> phoneNumbers) {
            Utils.checkNotNull(phoneNumbers, "phoneNumbers");
            this.phoneNumbers = phoneNumbers;
            return this;
        }

        public Builder web3Wallets(List<Web3Wallet> web3Wallets) {
            Utils.checkNotNull(web3Wallets, "web3Wallets");
            this.web3Wallets = Optional.ofNullable(web3Wallets);
            return this;
        }

        public Builder web3Wallets(Optional<? extends List<Web3Wallet>> web3Wallets) {
            Utils.checkNotNull(web3Wallets, "web3Wallets");
            this.web3Wallets = web3Wallets;
            return this;
        }

        public Builder passkeys(List<SchemasPasskey> passkeys) {
            Utils.checkNotNull(passkeys, "passkeys");
            this.passkeys = Optional.ofNullable(passkeys);
            return this;
        }

        public Builder passkeys(Optional<? extends List<SchemasPasskey>> passkeys) {
            Utils.checkNotNull(passkeys, "passkeys");
            this.passkeys = passkeys;
            return this;
        }

        public Builder passwordEnabled(boolean passwordEnabled) {
            Utils.checkNotNull(passwordEnabled, "passwordEnabled");
            this.passwordEnabled = Optional.ofNullable(passwordEnabled);
            return this;
        }

        public Builder passwordEnabled(Optional<Boolean> passwordEnabled) {
            Utils.checkNotNull(passwordEnabled, "passwordEnabled");
            this.passwordEnabled = passwordEnabled;
            return this;
        }

        public Builder twoFactorEnabled(boolean twoFactorEnabled) {
            Utils.checkNotNull(twoFactorEnabled, "twoFactorEnabled");
            this.twoFactorEnabled = Optional.ofNullable(twoFactorEnabled);
            return this;
        }

        public Builder twoFactorEnabled(Optional<Boolean> twoFactorEnabled) {
            Utils.checkNotNull(twoFactorEnabled, "twoFactorEnabled");
            this.twoFactorEnabled = twoFactorEnabled;
            return this;
        }

        public Builder totpEnabled(boolean totpEnabled) {
            Utils.checkNotNull(totpEnabled, "totpEnabled");
            this.totpEnabled = Optional.ofNullable(totpEnabled);
            return this;
        }

        public Builder totpEnabled(Optional<Boolean> totpEnabled) {
            Utils.checkNotNull(totpEnabled, "totpEnabled");
            this.totpEnabled = totpEnabled;
            return this;
        }

        public Builder backupCodeEnabled(boolean backupCodeEnabled) {
            Utils.checkNotNull(backupCodeEnabled, "backupCodeEnabled");
            this.backupCodeEnabled = Optional.ofNullable(backupCodeEnabled);
            return this;
        }

        public Builder backupCodeEnabled(Optional<Boolean> backupCodeEnabled) {
            Utils.checkNotNull(backupCodeEnabled, "backupCodeEnabled");
            this.backupCodeEnabled = backupCodeEnabled;
            return this;
        }

        public Builder mfaEnabledAt(long mfaEnabledAt) {
            Utils.checkNotNull(mfaEnabledAt, "mfaEnabledAt");
            this.mfaEnabledAt = JsonNullable.of((Object)mfaEnabledAt);
            return this;
        }

        public Builder mfaEnabledAt(JsonNullable<Long> mfaEnabledAt) {
            Utils.checkNotNull(mfaEnabledAt, "mfaEnabledAt");
            this.mfaEnabledAt = mfaEnabledAt;
            return this;
        }

        public Builder mfaDisabledAt(long mfaDisabledAt) {
            Utils.checkNotNull(mfaDisabledAt, "mfaDisabledAt");
            this.mfaDisabledAt = JsonNullable.of((Object)mfaDisabledAt);
            return this;
        }

        public Builder mfaDisabledAt(JsonNullable<Long> mfaDisabledAt) {
            Utils.checkNotNull(mfaDisabledAt, "mfaDisabledAt");
            this.mfaDisabledAt = mfaDisabledAt;
            return this;
        }

        public Builder externalAccounts(List<ExternalAccountWithVerification> externalAccounts) {
            Utils.checkNotNull(externalAccounts, "externalAccounts");
            this.externalAccounts = Optional.ofNullable(externalAccounts);
            return this;
        }

        public Builder externalAccounts(Optional<? extends List<ExternalAccountWithVerification>> externalAccounts) {
            Utils.checkNotNull(externalAccounts, "externalAccounts");
            this.externalAccounts = externalAccounts;
            return this;
        }

        public Builder samlAccounts(List<SAMLAccount> samlAccounts) {
            Utils.checkNotNull(samlAccounts, "samlAccounts");
            this.samlAccounts = Optional.ofNullable(samlAccounts);
            return this;
        }

        public Builder samlAccounts(Optional<? extends List<SAMLAccount>> samlAccounts) {
            Utils.checkNotNull(samlAccounts, "samlAccounts");
            this.samlAccounts = samlAccounts;
            return this;
        }

        public Builder lastSignInAt(long lastSignInAt) {
            Utils.checkNotNull(lastSignInAt, "lastSignInAt");
            this.lastSignInAt = JsonNullable.of((Object)lastSignInAt);
            return this;
        }

        public Builder lastSignInAt(JsonNullable<Long> lastSignInAt) {
            Utils.checkNotNull(lastSignInAt, "lastSignInAt");
            this.lastSignInAt = lastSignInAt;
            return this;
        }

        public Builder banned(boolean banned) {
            Utils.checkNotNull(banned, "banned");
            this.banned = Optional.ofNullable(banned);
            return this;
        }

        public Builder banned(Optional<Boolean> banned) {
            Utils.checkNotNull(banned, "banned");
            this.banned = banned;
            return this;
        }

        public Builder locked(boolean locked) {
            Utils.checkNotNull(locked, "locked");
            this.locked = Optional.ofNullable(locked);
            return this;
        }

        public Builder locked(Optional<Boolean> locked) {
            Utils.checkNotNull(locked, "locked");
            this.locked = locked;
            return this;
        }

        public Builder lockoutExpiresInSeconds(long lockoutExpiresInSeconds) {
            Utils.checkNotNull(lockoutExpiresInSeconds, "lockoutExpiresInSeconds");
            this.lockoutExpiresInSeconds = JsonNullable.of((Object)lockoutExpiresInSeconds);
            return this;
        }

        public Builder lockoutExpiresInSeconds(JsonNullable<Long> lockoutExpiresInSeconds) {
            Utils.checkNotNull(lockoutExpiresInSeconds, "lockoutExpiresInSeconds");
            this.lockoutExpiresInSeconds = lockoutExpiresInSeconds;
            return this;
        }

        public Builder verificationAttemptsRemaining(long verificationAttemptsRemaining) {
            Utils.checkNotNull(verificationAttemptsRemaining, "verificationAttemptsRemaining");
            this.verificationAttemptsRemaining = JsonNullable.of((Object)verificationAttemptsRemaining);
            return this;
        }

        public Builder verificationAttemptsRemaining(JsonNullable<Long> verificationAttemptsRemaining) {
            Utils.checkNotNull(verificationAttemptsRemaining, "verificationAttemptsRemaining");
            this.verificationAttemptsRemaining = verificationAttemptsRemaining;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        public Builder updatedAt(Optional<Long> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder createdAt(long createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        public Builder createdAt(Optional<Long> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder deleteSelfEnabled(boolean deleteSelfEnabled) {
            Utils.checkNotNull(deleteSelfEnabled, "deleteSelfEnabled");
            this.deleteSelfEnabled = Optional.ofNullable(deleteSelfEnabled);
            return this;
        }

        public Builder deleteSelfEnabled(Optional<Boolean> deleteSelfEnabled) {
            Utils.checkNotNull(deleteSelfEnabled, "deleteSelfEnabled");
            this.deleteSelfEnabled = deleteSelfEnabled;
            return this;
        }

        public Builder createOrganizationEnabled(boolean createOrganizationEnabled) {
            Utils.checkNotNull(createOrganizationEnabled, "createOrganizationEnabled");
            this.createOrganizationEnabled = Optional.ofNullable(createOrganizationEnabled);
            return this;
        }

        public Builder createOrganizationEnabled(Optional<Boolean> createOrganizationEnabled) {
            Utils.checkNotNull(createOrganizationEnabled, "createOrganizationEnabled");
            this.createOrganizationEnabled = createOrganizationEnabled;
            return this;
        }

        public Builder createOrganizationsLimit(long createOrganizationsLimit) {
            Utils.checkNotNull(createOrganizationsLimit, "createOrganizationsLimit");
            this.createOrganizationsLimit = JsonNullable.of((Object)createOrganizationsLimit);
            return this;
        }

        public Builder createOrganizationsLimit(JsonNullable<Long> createOrganizationsLimit) {
            Utils.checkNotNull(createOrganizationsLimit, "createOrganizationsLimit");
            this.createOrganizationsLimit = createOrganizationsLimit;
            return this;
        }

        public Builder lastActiveAt(long lastActiveAt) {
            Utils.checkNotNull(lastActiveAt, "lastActiveAt");
            this.lastActiveAt = JsonNullable.of((Object)lastActiveAt);
            return this;
        }

        public Builder lastActiveAt(JsonNullable<Long> lastActiveAt) {
            Utils.checkNotNull(lastActiveAt, "lastActiveAt");
            this.lastActiveAt = lastActiveAt;
            return this;
        }

        public Builder legalAcceptedAt(long legalAcceptedAt) {
            Utils.checkNotNull(legalAcceptedAt, "legalAcceptedAt");
            this.legalAcceptedAt = JsonNullable.of((Object)legalAcceptedAt);
            return this;
        }

        public Builder legalAcceptedAt(JsonNullable<Long> legalAcceptedAt) {
            Utils.checkNotNull(legalAcceptedAt, "legalAcceptedAt");
            this.legalAcceptedAt = legalAcceptedAt;
            return this;
        }

        public User build() {
            return new User(this.id, this.object, this.externalId, this.primaryEmailAddressId, this.primaryPhoneNumberId, this.primaryWeb3WalletId, this.username, this.firstName, this.lastName, this.profileImageUrl, this.imageUrl, this.hasImage, this.publicMetadata, this.privateMetadata, this.unsafeMetadata, this.emailAddresses, this.phoneNumbers, this.web3Wallets, this.passkeys, this.passwordEnabled, this.twoFactorEnabled, this.totpEnabled, this.backupCodeEnabled, this.mfaEnabledAt, this.mfaDisabledAt, this.externalAccounts, this.samlAccounts, this.lastSignInAt, this.banned, this.locked, this.lockoutExpiresInSeconds, this.verificationAttemptsRemaining, this.updatedAt, this.createdAt, this.deleteSelfEnabled, this.createOrganizationEnabled, this.createOrganizationsLimit, this.lastActiveAt, this.legalAcceptedAt);
        }
    }
}

