/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.components;

import com.clerk.backend_api.models.components.Web3SignatureVerificationStatus;
import com.clerk.backend_api.models.components.Web3SignatureVerificationStrategy;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class Web3Signature {
    @JsonProperty(value="status")
    private Web3SignatureVerificationStatus status;
    @JsonProperty(value="strategy")
    private Web3SignatureVerificationStrategy strategy;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="nonce")
    private JsonNullable<String> nonce;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="message")
    private JsonNullable<String> message;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="attempts")
    private Optional<Long> attempts;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="expire_at")
    private Optional<Long> expireAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="verified_at_client")
    private JsonNullable<String> verifiedAtClient;

    @JsonCreator
    public Web3Signature(@JsonProperty(value="status") Web3SignatureVerificationStatus status, @JsonProperty(value="strategy") Web3SignatureVerificationStrategy strategy, @JsonProperty(value="nonce") JsonNullable<String> nonce, @JsonProperty(value="message") JsonNullable<String> message, @JsonProperty(value="attempts") Optional<Long> attempts, @JsonProperty(value="expire_at") Optional<Long> expireAt, @JsonProperty(value="verified_at_client") JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(strategy, "strategy");
        Utils.checkNotNull(nonce, "nonce");
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(attempts, "attempts");
        Utils.checkNotNull(expireAt, "expireAt");
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.status = status;
        this.strategy = strategy;
        this.nonce = nonce;
        this.message = message;
        this.attempts = attempts;
        this.expireAt = expireAt;
        this.verifiedAtClient = verifiedAtClient;
    }

    public Web3Signature(Web3SignatureVerificationStatus status, Web3SignatureVerificationStrategy strategy) {
        this(status, strategy, (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), Optional.empty(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @JsonIgnore
    public Web3SignatureVerificationStatus status() {
        return this.status;
    }

    @JsonIgnore
    public Web3SignatureVerificationStrategy strategy() {
        return this.strategy;
    }

    @JsonIgnore
    public JsonNullable<String> nonce() {
        return this.nonce;
    }

    @JsonIgnore
    public JsonNullable<String> message() {
        return this.message;
    }

    @JsonIgnore
    public Optional<Long> attempts() {
        return this.attempts;
    }

    @JsonIgnore
    public Optional<Long> expireAt() {
        return this.expireAt;
    }

    @JsonIgnore
    public JsonNullable<String> verifiedAtClient() {
        return this.verifiedAtClient;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Web3Signature withStatus(Web3SignatureVerificationStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public Web3Signature withStrategy(Web3SignatureVerificationStrategy strategy) {
        Utils.checkNotNull(strategy, "strategy");
        this.strategy = strategy;
        return this;
    }

    public Web3Signature withNonce(String nonce) {
        Utils.checkNotNull(nonce, "nonce");
        this.nonce = JsonNullable.of((Object)nonce);
        return this;
    }

    public Web3Signature withNonce(JsonNullable<String> nonce) {
        Utils.checkNotNull(nonce, "nonce");
        this.nonce = nonce;
        return this;
    }

    public Web3Signature withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = JsonNullable.of((Object)message);
        return this;
    }

    public Web3Signature withMessage(JsonNullable<String> message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    public Web3Signature withAttempts(long attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = Optional.ofNullable(attempts);
        return this;
    }

    public Web3Signature withAttempts(Optional<Long> attempts) {
        Utils.checkNotNull(attempts, "attempts");
        this.attempts = attempts;
        return this;
    }

    public Web3Signature withExpireAt(long expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = Optional.ofNullable(expireAt);
        return this;
    }

    public Web3Signature withExpireAt(Optional<Long> expireAt) {
        Utils.checkNotNull(expireAt, "expireAt");
        this.expireAt = expireAt;
        return this;
    }

    public Web3Signature withVerifiedAtClient(String verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
        return this;
    }

    public Web3Signature withVerifiedAtClient(JsonNullable<String> verifiedAtClient) {
        Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
        this.verifiedAtClient = verifiedAtClient;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Web3Signature other = (Web3Signature)o;
        return Objects.deepEquals((Object)this.status, (Object)other.status) && Objects.deepEquals((Object)this.strategy, (Object)other.strategy) && Objects.deepEquals(this.nonce, other.nonce) && Objects.deepEquals(this.message, other.message) && Objects.deepEquals(this.attempts, other.attempts) && Objects.deepEquals(this.expireAt, other.expireAt) && Objects.deepEquals(this.verifiedAtClient, other.verifiedAtClient);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.strategy, this.nonce, this.message, this.attempts, this.expireAt, this.verifiedAtClient});
    }

    public String toString() {
        return Utils.toString(Web3Signature.class, new Object[]{"status", this.status, "strategy", this.strategy, "nonce", this.nonce, "message", this.message, "attempts", this.attempts, "expireAt", this.expireAt, "verifiedAtClient", this.verifiedAtClient});
    }

    public static final class Builder {
        private Web3SignatureVerificationStatus status;
        private Web3SignatureVerificationStrategy strategy;
        private JsonNullable<String> nonce = JsonNullable.undefined();
        private JsonNullable<String> message = JsonNullable.undefined();
        private Optional<Long> attempts = Optional.empty();
        private Optional<Long> expireAt = Optional.empty();
        private JsonNullable<String> verifiedAtClient = JsonNullable.undefined();

        private Builder() {
        }

        public Builder status(Web3SignatureVerificationStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder strategy(Web3SignatureVerificationStrategy strategy) {
            Utils.checkNotNull(strategy, "strategy");
            this.strategy = strategy;
            return this;
        }

        public Builder nonce(String nonce) {
            Utils.checkNotNull(nonce, "nonce");
            this.nonce = JsonNullable.of((Object)nonce);
            return this;
        }

        public Builder nonce(JsonNullable<String> nonce) {
            Utils.checkNotNull(nonce, "nonce");
            this.nonce = nonce;
            return this;
        }

        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = JsonNullable.of((Object)message);
            return this;
        }

        public Builder message(JsonNullable<String> message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }

        public Builder attempts(long attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = Optional.ofNullable(attempts);
            return this;
        }

        public Builder attempts(Optional<Long> attempts) {
            Utils.checkNotNull(attempts, "attempts");
            this.attempts = attempts;
            return this;
        }

        public Builder expireAt(long expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = Optional.ofNullable(expireAt);
            return this;
        }

        public Builder expireAt(Optional<Long> expireAt) {
            Utils.checkNotNull(expireAt, "expireAt");
            this.expireAt = expireAt;
            return this;
        }

        public Builder verifiedAtClient(String verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = JsonNullable.of((Object)verifiedAtClient);
            return this;
        }

        public Builder verifiedAtClient(JsonNullable<String> verifiedAtClient) {
            Utils.checkNotNull(verifiedAtClient, "verifiedAtClient");
            this.verifiedAtClient = verifiedAtClient;
            return this;
        }

        public Web3Signature build() {
            return new Web3Signature(this.status, this.strategy, this.nonce, this.message, this.attempts, this.expireAt, this.verifiedAtClient);
        }
    }
}

