/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.errors;

import com.clerk.backend_api.models.components.ClerkError;
import com.clerk.backend_api.models.errors.Meta;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ClerkErrors
extends RuntimeException {
    @JsonProperty(value="errors")
    private List<ClerkError> errors;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="meta")
    private Optional<? extends Meta> meta;

    @JsonCreator
    public ClerkErrors(@JsonProperty(value="errors") List<ClerkError> errors, @JsonProperty(value="meta") Optional<? extends Meta> meta) {
        Utils.checkNotNull(errors, "errors");
        Utils.checkNotNull(meta, "meta");
        this.errors = errors;
        this.meta = meta;
    }

    public ClerkErrors(List<ClerkError> errors) {
        this(errors, Optional.empty());
    }

    @JsonIgnore
    public List<ClerkError> errors() {
        return this.errors;
    }

    @JsonIgnore
    public Optional<Meta> meta() {
        return this.meta;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public ClerkErrors withErrors(List<ClerkError> errors) {
        Utils.checkNotNull(errors, "errors");
        this.errors = errors;
        return this;
    }

    public ClerkErrors withMeta(Meta meta) {
        Utils.checkNotNull(meta, "meta");
        this.meta = Optional.ofNullable(meta);
        return this;
    }

    public ClerkErrors withMeta(Optional<? extends Meta> meta) {
        Utils.checkNotNull(meta, "meta");
        this.meta = meta;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClerkErrors other = (ClerkErrors)o;
        return Objects.deepEquals(this.errors, other.errors) && Objects.deepEquals(this.meta, other.meta);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.meta);
    }

    @Override
    public String toString() {
        return Utils.toString(ClerkErrors.class, "errors", this.errors, "meta", this.meta);
    }

    public static final class Builder {
        private List<ClerkError> errors;
        private Optional<? extends Meta> meta = Optional.empty();

        private Builder() {
        }

        public Builder errors(List<ClerkError> errors) {
            Utils.checkNotNull(errors, "errors");
            this.errors = errors;
            return this;
        }

        public Builder meta(Meta meta) {
            Utils.checkNotNull(meta, "meta");
            this.meta = Optional.ofNullable(meta);
            return this;
        }

        public Builder meta(Optional<? extends Meta> meta) {
            Utils.checkNotNull(meta, "meta");
            this.meta = meta;
            return this;
        }

        public ClerkErrors build() {
            return new ClerkErrors(this.errors, this.meta);
        }
    }
}

