/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.CreateBulkInvitationsResponse;
import com.clerk.backend_api.models.operations.RequestBody;
import com.clerk.backend_api.models.operations.SDKMethodInterfaces;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.List;
import java.util.Optional;

public class CreateBulkInvitationsRequestBuilder {
    private Optional<? extends List<RequestBody>> request = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallCreateBulkInvitations sdk;

    public CreateBulkInvitationsRequestBuilder(SDKMethodInterfaces.MethodCallCreateBulkInvitations sdk) {
        this.sdk = sdk;
    }

    public CreateBulkInvitationsRequestBuilder request(List<RequestBody> request) {
        Utils.checkNotNull(request, "request");
        this.request = Optional.of(request);
        return this;
    }

    public CreateBulkInvitationsRequestBuilder request(Optional<? extends List<RequestBody>> request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public CreateBulkInvitationsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public CreateBulkInvitationsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CreateBulkInvitationsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.bulkCreate(this.request, options);
    }
}

