/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.Invitation;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateBulkInvitationsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends List<Invitation>> invitationList;

    @JsonCreator
    public CreateBulkInvitationsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends List<Invitation>> invitationList) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(invitationList, "invitationList");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.invitationList = invitationList;
    }

    public CreateBulkInvitationsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<List<Invitation>> invitationList() {
        return this.invitationList;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public CreateBulkInvitationsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public CreateBulkInvitationsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public CreateBulkInvitationsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public CreateBulkInvitationsResponse withInvitationList(List<Invitation> invitationList) {
        Utils.checkNotNull(invitationList, "invitationList");
        this.invitationList = Optional.ofNullable(invitationList);
        return this;
    }

    public CreateBulkInvitationsResponse withInvitationList(Optional<? extends List<Invitation>> invitationList) {
        Utils.checkNotNull(invitationList, "invitationList");
        this.invitationList = invitationList;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateBulkInvitationsResponse other = (CreateBulkInvitationsResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.invitationList, other.invitationList);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.invitationList);
    }

    public String toString() {
        return Utils.toString(CreateBulkInvitationsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "invitationList", this.invitationList);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends List<Invitation>> invitationList = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder invitationList(List<Invitation> invitationList) {
            Utils.checkNotNull(invitationList, "invitationList");
            this.invitationList = Optional.ofNullable(invitationList);
            return this;
        }

        public Builder invitationList(Optional<? extends List<Invitation>> invitationList) {
            Utils.checkNotNull(invitationList, "invitationList");
            this.invitationList = invitationList;
            return this;
        }

        public CreateBulkInvitationsResponse build() {
            return new CreateBulkInvitationsResponse(this.contentType, this.statusCode, this.rawResponse, this.invitationList);
        }
    }
}

