/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.Claims;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class CreateJWTTemplateRequestBody {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="claims")
    private Claims claims;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="lifetime")
    private JsonNullable<Double> lifetime;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="allowed_clock_skew")
    private JsonNullable<Double> allowedClockSkew;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="custom_signing_key")
    private Optional<Boolean> customSigningKey;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="signing_algorithm")
    private JsonNullable<String> signingAlgorithm;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="signing_key")
    private JsonNullable<String> signingKey;

    @JsonCreator
    public CreateJWTTemplateRequestBody(@JsonProperty(value="name") String name, @JsonProperty(value="claims") Claims claims, @JsonProperty(value="lifetime") JsonNullable<Double> lifetime, @JsonProperty(value="allowed_clock_skew") JsonNullable<Double> allowedClockSkew, @JsonProperty(value="custom_signing_key") Optional<Boolean> customSigningKey, @JsonProperty(value="signing_algorithm") JsonNullable<String> signingAlgorithm, @JsonProperty(value="signing_key") JsonNullable<String> signingKey) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(claims, "claims");
        Utils.checkNotNull(lifetime, "lifetime");
        Utils.checkNotNull(allowedClockSkew, "allowedClockSkew");
        Utils.checkNotNull(customSigningKey, "customSigningKey");
        Utils.checkNotNull(signingAlgorithm, "signingAlgorithm");
        Utils.checkNotNull(signingKey, "signingKey");
        this.name = name;
        this.claims = claims;
        this.lifetime = lifetime;
        this.allowedClockSkew = allowedClockSkew;
        this.customSigningKey = customSigningKey;
        this.signingAlgorithm = signingAlgorithm;
        this.signingKey = signingKey;
    }

    public CreateJWTTemplateRequestBody(String name, Claims claims) {
        this(name, claims, (JsonNullable<Double>)JsonNullable.undefined(), (JsonNullable<Double>)JsonNullable.undefined(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public Claims claims() {
        return this.claims;
    }

    @JsonIgnore
    public JsonNullable<Double> lifetime() {
        return this.lifetime;
    }

    @JsonIgnore
    public JsonNullable<Double> allowedClockSkew() {
        return this.allowedClockSkew;
    }

    @JsonIgnore
    public Optional<Boolean> customSigningKey() {
        return this.customSigningKey;
    }

    @JsonIgnore
    public JsonNullable<String> signingAlgorithm() {
        return this.signingAlgorithm;
    }

    @JsonIgnore
    public JsonNullable<String> signingKey() {
        return this.signingKey;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public CreateJWTTemplateRequestBody withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public CreateJWTTemplateRequestBody withClaims(Claims claims) {
        Utils.checkNotNull(claims, "claims");
        this.claims = claims;
        return this;
    }

    public CreateJWTTemplateRequestBody withLifetime(double lifetime) {
        Utils.checkNotNull(lifetime, "lifetime");
        this.lifetime = JsonNullable.of((Object)lifetime);
        return this;
    }

    public CreateJWTTemplateRequestBody withLifetime(JsonNullable<Double> lifetime) {
        Utils.checkNotNull(lifetime, "lifetime");
        this.lifetime = lifetime;
        return this;
    }

    public CreateJWTTemplateRequestBody withAllowedClockSkew(double allowedClockSkew) {
        Utils.checkNotNull(allowedClockSkew, "allowedClockSkew");
        this.allowedClockSkew = JsonNullable.of((Object)allowedClockSkew);
        return this;
    }

    public CreateJWTTemplateRequestBody withAllowedClockSkew(JsonNullable<Double> allowedClockSkew) {
        Utils.checkNotNull(allowedClockSkew, "allowedClockSkew");
        this.allowedClockSkew = allowedClockSkew;
        return this;
    }

    public CreateJWTTemplateRequestBody withCustomSigningKey(boolean customSigningKey) {
        Utils.checkNotNull(customSigningKey, "customSigningKey");
        this.customSigningKey = Optional.ofNullable(customSigningKey);
        return this;
    }

    public CreateJWTTemplateRequestBody withCustomSigningKey(Optional<Boolean> customSigningKey) {
        Utils.checkNotNull(customSigningKey, "customSigningKey");
        this.customSigningKey = customSigningKey;
        return this;
    }

    public CreateJWTTemplateRequestBody withSigningAlgorithm(String signingAlgorithm) {
        Utils.checkNotNull(signingAlgorithm, "signingAlgorithm");
        this.signingAlgorithm = JsonNullable.of((Object)signingAlgorithm);
        return this;
    }

    public CreateJWTTemplateRequestBody withSigningAlgorithm(JsonNullable<String> signingAlgorithm) {
        Utils.checkNotNull(signingAlgorithm, "signingAlgorithm");
        this.signingAlgorithm = signingAlgorithm;
        return this;
    }

    public CreateJWTTemplateRequestBody withSigningKey(String signingKey) {
        Utils.checkNotNull(signingKey, "signingKey");
        this.signingKey = JsonNullable.of((Object)signingKey);
        return this;
    }

    public CreateJWTTemplateRequestBody withSigningKey(JsonNullable<String> signingKey) {
        Utils.checkNotNull(signingKey, "signingKey");
        this.signingKey = signingKey;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateJWTTemplateRequestBody other = (CreateJWTTemplateRequestBody)o;
        return Objects.deepEquals(this.name, other.name) && Objects.deepEquals(this.claims, other.claims) && Objects.deepEquals(this.lifetime, other.lifetime) && Objects.deepEquals(this.allowedClockSkew, other.allowedClockSkew) && Objects.deepEquals(this.customSigningKey, other.customSigningKey) && Objects.deepEquals(this.signingAlgorithm, other.signingAlgorithm) && Objects.deepEquals(this.signingKey, other.signingKey);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.claims, this.lifetime, this.allowedClockSkew, this.customSigningKey, this.signingAlgorithm, this.signingKey);
    }

    public String toString() {
        return Utils.toString(CreateJWTTemplateRequestBody.class, "name", this.name, "claims", this.claims, "lifetime", this.lifetime, "allowedClockSkew", this.allowedClockSkew, "customSigningKey", this.customSigningKey, "signingAlgorithm", this.signingAlgorithm, "signingKey", this.signingKey);
    }

    public static final class Builder {
        private String name;
        private Claims claims;
        private JsonNullable<Double> lifetime = JsonNullable.undefined();
        private JsonNullable<Double> allowedClockSkew = JsonNullable.undefined();
        private Optional<Boolean> customSigningKey = Optional.empty();
        private JsonNullable<String> signingAlgorithm = JsonNullable.undefined();
        private JsonNullable<String> signingKey = JsonNullable.undefined();

        private Builder() {
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder claims(Claims claims) {
            Utils.checkNotNull(claims, "claims");
            this.claims = claims;
            return this;
        }

        public Builder lifetime(double lifetime) {
            Utils.checkNotNull(lifetime, "lifetime");
            this.lifetime = JsonNullable.of((Object)lifetime);
            return this;
        }

        public Builder lifetime(JsonNullable<Double> lifetime) {
            Utils.checkNotNull(lifetime, "lifetime");
            this.lifetime = lifetime;
            return this;
        }

        public Builder allowedClockSkew(double allowedClockSkew) {
            Utils.checkNotNull(allowedClockSkew, "allowedClockSkew");
            this.allowedClockSkew = JsonNullable.of((Object)allowedClockSkew);
            return this;
        }

        public Builder allowedClockSkew(JsonNullable<Double> allowedClockSkew) {
            Utils.checkNotNull(allowedClockSkew, "allowedClockSkew");
            this.allowedClockSkew = allowedClockSkew;
            return this;
        }

        public Builder customSigningKey(boolean customSigningKey) {
            Utils.checkNotNull(customSigningKey, "customSigningKey");
            this.customSigningKey = Optional.ofNullable(customSigningKey);
            return this;
        }

        public Builder customSigningKey(Optional<Boolean> customSigningKey) {
            Utils.checkNotNull(customSigningKey, "customSigningKey");
            this.customSigningKey = customSigningKey;
            return this;
        }

        public Builder signingAlgorithm(String signingAlgorithm) {
            Utils.checkNotNull(signingAlgorithm, "signingAlgorithm");
            this.signingAlgorithm = JsonNullable.of((Object)signingAlgorithm);
            return this;
        }

        public Builder signingAlgorithm(JsonNullable<String> signingAlgorithm) {
            Utils.checkNotNull(signingAlgorithm, "signingAlgorithm");
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        public Builder signingKey(String signingKey) {
            Utils.checkNotNull(signingKey, "signingKey");
            this.signingKey = JsonNullable.of((Object)signingKey);
            return this;
        }

        public Builder signingKey(JsonNullable<String> signingKey) {
            Utils.checkNotNull(signingKey, "signingKey");
            this.signingKey = signingKey;
            return this;
        }

        public CreateJWTTemplateRequestBody build() {
            return new CreateJWTTemplateRequestBody(this.name, this.claims, this.lifetime, this.allowedClockSkew, this.customSigningKey, this.signingAlgorithm, this.signingKey);
        }
    }
}

