/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.CreateOrganizationInvitationBulkRequestBody;
import com.clerk.backend_api.models.operations.CreateOrganizationInvitationBulkResponse;
import com.clerk.backend_api.models.operations.SDKMethodInterfaces;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.List;
import java.util.Optional;

public class CreateOrganizationInvitationBulkRequestBuilder {
    private String organizationId;
    private List<CreateOrganizationInvitationBulkRequestBody> requestBody;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallCreateOrganizationInvitationBulk sdk;

    public CreateOrganizationInvitationBulkRequestBuilder(SDKMethodInterfaces.MethodCallCreateOrganizationInvitationBulk sdk) {
        this.sdk = sdk;
    }

    public CreateOrganizationInvitationBulkRequestBuilder organizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public CreateOrganizationInvitationBulkRequestBuilder requestBody(List<CreateOrganizationInvitationBulkRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public CreateOrganizationInvitationBulkRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public CreateOrganizationInvitationBulkRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CreateOrganizationInvitationBulkResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.bulkCreate(this.organizationId, this.requestBody, options);
    }
}

