/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.OrganizationInvitation;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class CreateOrganizationInvitationResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends OrganizationInvitation> organizationInvitation;

    @JsonCreator
    public CreateOrganizationInvitationResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends OrganizationInvitation> organizationInvitation) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(organizationInvitation, "organizationInvitation");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.organizationInvitation = organizationInvitation;
    }

    public CreateOrganizationInvitationResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<OrganizationInvitation> organizationInvitation() {
        return this.organizationInvitation;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public CreateOrganizationInvitationResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public CreateOrganizationInvitationResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public CreateOrganizationInvitationResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public CreateOrganizationInvitationResponse withOrganizationInvitation(OrganizationInvitation organizationInvitation) {
        Utils.checkNotNull(organizationInvitation, "organizationInvitation");
        this.organizationInvitation = Optional.ofNullable(organizationInvitation);
        return this;
    }

    public CreateOrganizationInvitationResponse withOrganizationInvitation(Optional<? extends OrganizationInvitation> organizationInvitation) {
        Utils.checkNotNull(organizationInvitation, "organizationInvitation");
        this.organizationInvitation = organizationInvitation;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOrganizationInvitationResponse other = (CreateOrganizationInvitationResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.organizationInvitation, other.organizationInvitation);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.organizationInvitation);
    }

    public String toString() {
        return Utils.toString(CreateOrganizationInvitationResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "organizationInvitation", this.organizationInvitation);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends OrganizationInvitation> organizationInvitation = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder organizationInvitation(OrganizationInvitation organizationInvitation) {
            Utils.checkNotNull(organizationInvitation, "organizationInvitation");
            this.organizationInvitation = Optional.ofNullable(organizationInvitation);
            return this;
        }

        public Builder organizationInvitation(Optional<? extends OrganizationInvitation> organizationInvitation) {
            Utils.checkNotNull(organizationInvitation, "organizationInvitation");
            this.organizationInvitation = organizationInvitation;
            return this;
        }

        public CreateOrganizationInvitationResponse build() {
            return new CreateOrganizationInvitationResponse(this.contentType, this.statusCode, this.rawResponse, this.organizationInvitation);
        }
    }
}

