/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.CreateOrganizationMembershipRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public class CreateOrganizationMembershipRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=organization_id")
    private String organizationId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private CreateOrganizationMembershipRequestBody requestBody;

    @JsonCreator
    public CreateOrganizationMembershipRequest(String organizationId, CreateOrganizationMembershipRequestBody requestBody) {
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.organizationId = organizationId;
        this.requestBody = requestBody;
    }

    @JsonIgnore
    public String organizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public CreateOrganizationMembershipRequestBody requestBody() {
        return this.requestBody;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public CreateOrganizationMembershipRequest withOrganizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public CreateOrganizationMembershipRequest withRequestBody(CreateOrganizationMembershipRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOrganizationMembershipRequest other = (CreateOrganizationMembershipRequest)o;
        return Objects.deepEquals(this.organizationId, other.organizationId) && Objects.deepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Objects.hash(this.organizationId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(CreateOrganizationMembershipRequest.class, "organizationId", this.organizationId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String organizationId;
        private CreateOrganizationMembershipRequestBody requestBody;

        private Builder() {
        }

        public Builder organizationId(String organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder requestBody(CreateOrganizationMembershipRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public CreateOrganizationMembershipRequest build() {
            return new CreateOrganizationMembershipRequest(this.organizationId, this.requestBody);
        }
    }
}

